/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline;

import com.sun.forte.st.mpmt.AnLocale;
import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.timeline.AnalyzerState;
import com.sun.forte.st.mpmt.timeline.AnalyzerThread;
import com.sun.forte.st.mpmt.timeline.AnalyzerTimeline;
import com.sun.forte.st.mpmt.timeline.Data;
import com.sun.forte.st.mpmt.timeline.Entity;
import com.sun.forte.st.mpmt.timeline.Event;
import com.sun.forte.st.mpmt.timeline.Experiment;
import com.sun.forte.st.mpmt.timeline.TimelineMetaState;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TimelineMetaExperiment
extends Experiment {
    public static final int META = -1;
    protected static Hashtable knownExperiments = new Hashtable();
    protected Experiment[] experiments = this.getExperiments();
    protected String[] curExpNames;

    public TimelineMetaExperiment() {
        super(-1);
        this.start_time = 0L;
        this.end_time = 0L;
    }

    private Experiment[] getExperiments() {
        int[] nArray = AnUtility.getExpEnable();
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        Experiment[] experimentArray = new Experiment[n];
        int n2 = 0;
        while (n2 < n) {
            experimentArray[n2] = new Experiment(nArray[n2]);
            ++n2;
        }
        return experimentArray;
    }

    public boolean needReload() {
        int n;
        int n2;
        boolean bl = false;
        Experiment[] experimentArray = this.getExperiments();
        if (this.experiments == null) {
            bl = experimentArray != null;
        } else if (experimentArray == null) {
            bl = true;
        } else {
            n2 = experimentArray.length;
            if (n2 != this.experiments.length) {
                bl = true;
            } else {
                n = 0;
                while (n < n2) {
                    if (!experimentArray[n].getName().equals(this.curExpNames[n])) {
                        bl = true;
                        break;
                    }
                    if (this.experiments[n].needReload()) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        Hashtable<String, Experiment> hashtable = new Hashtable<String, Experiment>();
        if (experimentArray != null) {
            n2 = experimentArray.length;
            n = 0;
            while (n < n2) {
                String string = experimentArray[n].getName();
                if (knownExperiments.containsKey(string)) {
                    // empty if block
                }
                hashtable.put(string, experimentArray[n]);
                ++n;
            }
        }
        knownExperiments = hashtable;
        if (bl) {
            this.experiments = experimentArray;
        }
        return bl;
    }

    public void gatherData() {
        Vector<AnalyzerThread> vector = new Vector<AnalyzerThread>();
        Vector<AnalyzerState> vector2 = new Vector<AnalyzerState>();
        int n = 0;
        if (this.experiments == null || this.experiments.length == 0) {
            vector.add(new AnalyzerThread(new Event[0], new Entity(1, 0), new Data(AnLocale.getString("<unknown>"), 0), this));
            vector2.add(new AnalyzerState(AnLocale.getString("<unknown>"), 0L));
            this.setStates(vector2);
            this.setThreads(vector);
            this.createMapping(n);
            return;
        }
        this.states = new Hashtable();
        int n2 = this.experiments.length;
        this.curExpNames = new String[n2];
        Hashtable hashtable = new Hashtable();
        int n3 = 0;
        while (n3 < n2) {
            this.curExpNames[n3] = this.experiments[n3].getName();
            if (knownExperiments.containsKey(this.curExpNames[n3])) {
                this.experiments[n3] = (Experiment)knownExperiments.get(this.curExpNames[n3]);
                if (this.experiments[n3].needReload()) {
                    this.experiments[n3].gatherData();
                }
            } else {
                this.experiments[n3].gatherData();
                knownExperiments.put(this.curExpNames[n3], this.experiments[n3]);
            }
            this.addStates(this.experiments[n3], vector2, hashtable);
            this.addThreads(this.experiments[n3], vector);
            this.max_stack_frames = Math.max(this.max_stack_frames, this.experiments[n3].getMaxStackFrames());
            n += this.experiments[n3].getMapping().length;
            ++n3;
        }
        this.adjustTimes();
        this.setStates(vector2);
        this.setThreads(vector);
        this.createMapping(n);
    }

    private void createMapping(int n) {
        AnalyzerThread[] analyzerThreadArray = new AnalyzerThread[n];
        if (this.experiments == null) {
            this.mapping = analyzerThreadArray;
            return;
        }
        int n2 = 0;
        int n3 = this.experiments.length;
        Hashtable<String, Data> hashtable = new Hashtable<String, Data>();
        int n4 = 0;
        while (n4 < n3) {
            AnalyzerThread[] analyzerThreadArray2 = this.experiments[n4].getMapping();
            int n5 = 0;
            while (n5 < analyzerThreadArray2.length) {
                if (n5 > 0 && analyzerThreadArray2[n5] == null && analyzerThreadArray2[n5 - 1] == null) break;
                analyzerThreadArray[n2++] = analyzerThreadArray2[n5];
                ++n5;
            }
            Data[] dataArray = this.experiments[n4].getDataDescriptions();
            n5 = 0;
            while (n5 < dataArray.length) {
                if (!hashtable.containsKey(dataArray[n5].getDescription())) {
                    hashtable.put(dataArray[n5].getDescription(), dataArray[n5]);
                }
                ++n5;
            }
            ++n4;
        }
        this.data_desc = new Data[hashtable.size()];
        n4 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.data_desc[n4++] = (Data)enumeration.nextElement();
        }
        this.mapping = new AnalyzerThread[n2];
        System.arraycopy(analyzerThreadArray, 0, this.mapping, 0, n2);
    }

    protected void addStates(Experiment experiment, Vector vector, Hashtable hashtable) {
        Enumeration enumeration = experiment.getAllFunctions().elements();
        while (enumeration.hasMoreElements()) {
            PhatState phatState = (PhatState)enumeration.nextElement();
            long l = phatState.getNumber();
            String string = phatState.getName();
            PhatState phatState2 = phatState = this.states.containsKey(string) ? (PhatState)this.states.get(string) : phatState;
            if (phatState instanceof TimelineMetaState) {
                TimelineMetaState timelineMetaState = (TimelineMetaState)phatState;
                timelineMetaState.addAlias(l);
                timelineMetaState.setDataSet(experiment);
                if (phatState.getColor().equals(timelineMetaState.getColor())) continue;
                timelineMetaState.setColor(phatState.getColor());
                continue;
            }
            if (l > (long)AnalyzerTimeline.MSTATE_DESC.length) {
                phatState = new TimelineMetaState(string, l, experiment);
            }
            this.states.put(string, phatState);
            vector.add(phatState);
            if (hashtable.containsKey(string) && phatState.getColor() == Color.black) {
                phatState.setColor((Color)hashtable.get(string));
                continue;
            }
            if (phatState.getColor() != Color.black) continue;
            phatState.setColor(new Color(string.hashCode()));
            hashtable.put(string, phatState.getColor());
        }
    }

    protected void addThreads(Experiment experiment, Vector vector) {
        Enumeration enumeration = experiment.getAllThreads().getAllThreads().elements();
        while (enumeration.hasMoreElements()) {
            vector.add(0, enumeration.nextElement());
        }
    }

    public void adjustTimes() {
        Experiment experiment;
        long l;
        long l2;
        Vector<Experiment> vector;
        int n;
        if (this.experiments == null || this.experiments.length == 0) {
            return;
        }
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < this.experiments.length) {
            long l3 = this.experiments[n2].getStartTime();
            long l4 = this.experiments[n2].getEndTime();
            boolean bl = false;
            n = 0;
            while (n < vector2.size()) {
                vector = (Vector)vector2.elementAt(n);
                l2 = Long.MAX_VALUE;
                l = 0L;
                int n3 = 0;
                while (n3 < vector.size()) {
                    experiment = (Experiment)vector.elementAt(n3);
                    l2 = Math.min(l2, experiment.getStartTime() + experiment.getCurrentTimeAdjust());
                    l = Math.max(l, experiment.getEndTime() + experiment.getCurrentTimeAdjust());
                    if (l3 >= l2 && l3 <= l) break;
                    ++n3;
                }
                if (l3 >= l2 && l3 <= l) {
                    vector.add(this.experiments[n2]);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector = new Vector<Experiment>();
                vector.add(this.experiments[n2]);
                vector2.add(vector);
            }
            ++n2;
        }
        this.end_time = 0L;
        n2 = 0;
        while (n2 < vector2.size()) {
            vector = (Vector<Experiment>)vector2.elementAt(n2);
            l2 = Long.MAX_VALUE;
            l = 0L;
            n = 0;
            while (n < vector.size()) {
                experiment = (Experiment)vector.elementAt(n);
                l2 = Math.min(l2, experiment.getStartTime() + experiment.getCurrentTimeAdjust());
                l = Math.max(l, experiment.getEndTime() + experiment.getCurrentTimeAdjust());
                ++n;
            }
            n = 0;
            while (n < vector.size()) {
                experiment = (Experiment)vector.elementAt(n);
                if (experiment.getCurrentTimeAdjust() != l2) {
                    experiment.adjustTime(l2 - experiment.getCurrentTimeAdjust());
                    experiment.setCurrentTimeAdjust(l2);
                }
                ++n;
            }
            this.end_time = Math.max(l - l2, this.end_time);
            ++n2;
        }
    }

    public PhatState getState(long l) {
        Enumeration enumeration = this.defaultStateGroup.getStates().elements();
        PhatState phatState = null;
        while (enumeration.hasMoreElements()) {
            phatState = (PhatState)enumeration.nextElement();
            if (phatState instanceof TimelineMetaState && ((TimelineMetaState)phatState).hasAlias(l)) {
                return phatState;
            }
            if (phatState instanceof TimelineMetaState || phatState.getNumber() != l) continue;
            return phatState;
        }
        return null;
    }

    public String getName() {
        return AnLocale.getString("All Experiments");
    }

    public Entity[] getEntities(int n) {
        return this.experiments == null || this.experiments.length == 0 ? null : this.experiments[0].getEntities(n);
    }

    public Object[] getEvents(Entity entity, long l, long l2, Data data) {
        return null;
    }

    public static long[] getStackFunctions(long l) {
        Long l2 = new Long(l);
        Experiment cfr_ignored_0 = (Experiment)Experiment.stackToExp.get(l2);
        return Experiment.getStackFunctions(l);
    }

    public String getFunctionName(long l) {
        PhatState phatState = this.getState(l);
        if (phatState != null) {
            return phatState.getName();
        }
        return AnLocale.getString("<unknown>");
    }
}

