/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.AnUtility;
import com.sun.forte.st.mpmt.timeline.ats.NavigationListener;
import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class NavigationBar
extends JToolBar {
    protected static final int threadCols = 3;
    protected static final int stateCols = -1;
    protected static final int atTimeCols = 7;
    protected static final int lengthCols = 7;
    protected JButton forward;
    protected JButton back;
    protected JButton up;
    protected JButton down;
    protected JTextField threadText;
    protected JTextField stateText;
    protected JTextField atTimeText;
    protected JTextField lengthText;
    protected Timeline canvas;
    protected PhatDataSet set;
    protected int numThreads;
    protected Vector threads;
    protected boolean clear;
    protected boolean labelsShowing;
    protected static final NumberFormat numberFormat = new DecimalFormat();

    public NavigationBar(Timeline timeline) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFloatable(false);
        this.canvas = timeline;
        this.labelsShowing = true;
        this.back = this.createNavButton(AnUtility.leftIcon, "Back One Event", -3);
        this.forward = this.createNavButton(AnUtility.rightIcon, "Forward One Event", -2);
        this.up = this.createNavButton(AnUtility.upIcon, "Up One Bar", -4);
        this.down = this.createNavButton(AnUtility.downIcon, "Down One Bar", -5);
        this.add(this.back);
        this.add(this.forward);
        this.add(this.up);
        this.add(this.down);
        int n = this.down.getPreferredSize().height;
        this.threadText = this.createField("Thread", "", 3, n);
        this.add(this.threadText);
        this.stateText = this.createField("State", "", -1, n);
        this.add(this.stateText);
        this.atTimeText = this.createField("At time", "", 7, n);
        this.add(this.atTimeText);
        this.lengthText = this.createField("Length", "", 7, n);
        this.add(this.lengthText);
    }

    public void setDataSet(PhatDataSet phatDataSet) {
        this.set = phatDataSet;
        this.numThreads = phatDataSet.getAllThreads().numThreads();
    }

    public void removeLabels() {
        this.removeAll();
        this.add(this.back);
        this.add(this.forward);
        this.add(this.up);
        this.add(this.down);
        this.labelsShowing = false;
    }

    public void update(ThreadViewEvent threadViewEvent) {
        if (threadViewEvent.state != -1L) {
            this.numThreads = this.set.getAllThreads().numThreads();
            if (this.labelsShowing) {
                this.resetTextAreas(threadViewEvent);
            }
            if (threadViewEvent.thread == this.numThreads - 1) {
                this.down.setEnabled(false);
            } else {
                this.down.setEnabled(true);
            }
            if (threadViewEvent.thread == 0) {
                this.up.setEnabled(false);
            } else {
                this.up.setEnabled(true);
            }
            try {
                this.forward.setEnabled(threadViewEvent.enableForward);
                this.forward.setEnabled(threadViewEvent.enableForward);
                this.back.setEnabled(threadViewEvent.enableBack);
                this.back.setEnabled(threadViewEvent.enableBack);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.clear = false;
        } else if (!this.clear) {
            this.stateText.setText("");
            this.threadText.setText("");
            this.atTimeText.setText("");
            this.lengthText.setText("");
            this.forward.setEnabled(false);
            this.back.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.clear = true;
        }
    }

    private void resetTextAreas(ThreadViewEvent threadViewEvent) {
        PhatState phatState;
        if (this.threads == null) {
            this.threads = this.canvas.getThreadViews();
        }
        if ((phatState = this.set.getState(threadViewEvent.state)) != null) {
            this.stateText.setText(phatState.toString());
            this.stateText.setCaretPosition(0);
            this.threadText.setText("" + ((PhatThread)this.threads.elementAt(threadViewEvent.thread)).getNumber());
        } else {
            this.stateText.setText("<Unknown>");
        }
        if (threadViewEvent.timeAt < 1000000000L) {
            this.atTimeText.setText(numberFormat.format((double)threadViewEvent.timeAt / 1000000.0) + "ms");
        } else {
            this.atTimeText.setText(numberFormat.format((double)threadViewEvent.timeAt / 1.0E9) + "s");
        }
        this.lengthText.setText(numberFormat.format((double)threadViewEvent.time / 1000000.0) + "ms");
    }

    private JButton createNavButton(ImageIcon imageIcon, String string, int n) {
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setToolTipText(string);
        jButton.addActionListener(new NavigationListener(n, this.canvas));
        return jButton;
    }

    private JTextField createField(String string, String string2, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string2);
        this.add(jLabel);
        JTextField jTextField = new JTextField("");
        jTextField.setEditable(false);
        jTextField.setToolTipText("");
        if (n > 0) {
            jTextField.setColumns(n);
            Dimension dimension = jTextField.getPreferredSize();
            dimension.height = n2;
            jTextField.setMaximumSize(dimension);
        }
        return jTextField;
    }

    static {
        numberFormat.setMaximumFractionDigits(3);
    }
}

