/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.PhatObject;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.PhatStateGroup;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import com.sun.forte.st.mpmt.timeline.ats.PhatThreadGroup;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PhatDataSet
extends PhatObject {
    protected static ImageIcon icon;
    protected Hashtable states;
    protected Hashtable threads;
    protected PhatStateGroup defaultStateGroup;
    protected PhatThreadGroup defaultThreadGroup;
    protected double[] averageTimeIn;

    public PhatDataSet() {
        this.name = "PHAT data set";
    }

    public PhatDataSet(String string, Vector vector, Vector vector2) {
        this(vector, vector2);
        this.name = string;
    }

    public PhatDataSet(String string, PhatStateGroup phatStateGroup, Vector vector) {
        this.name = string;
        this.defaultStateGroup = phatStateGroup;
        this.states = phatStateGroup.getMap();
        this.setThreads(vector);
        phatStateGroup.setDataSet(this);
    }

    public PhatDataSet(Vector vector, Vector vector2) {
        this.setStates(vector);
        this.setThreads(vector2);
        this.averageTimeIn = new double[255];
        int n = 0;
        while (n < vector.size()) {
            this.averageTimeIn[n] = this.defaultThreadGroup.getAverageTimeIn(this.getState(n));
            ++n;
        }
    }

    public void setThreads(Vector vector) {
        this.defaultThreadGroup = new PhatThreadGroup(vector, this);
        this.threads = this.defaultThreadGroup.getMap();
    }

    public void setStates(Vector vector) {
        this.defaultStateGroup = new PhatStateGroup(vector, this);
        this.states = this.defaultStateGroup.getMap();
    }

    public PhatThreadGroup getAllThreads() {
        return this.defaultThreadGroup;
    }

    public PhatStateGroup getAllStates() {
        return this.defaultStateGroup;
    }

    public PhatStateGroup getNewSetOfStates() {
        this.defaultStateGroup = (PhatStateGroup)this.defaultStateGroup.clone();
        return this.defaultStateGroup;
    }

    public String getName() {
        return this.name;
    }

    public PhatState getState(String string) {
        return (PhatState)this.states.get(string);
    }

    public double getAverageTimeIn(int n) {
        return this.averageTimeIn[n];
    }

    public PhatState getState(long l) {
        Enumeration enumeration = this.states.elements();
        while (enumeration.hasMoreElements()) {
            PhatState phatState = (PhatState)enumeration.nextElement();
            if (phatState.getNumber() != l) continue;
            return phatState;
        }
        return null;
    }

    public PhatStateGroup getStates(Vector vector) {
        Vector<PhatState> vector2 = new Vector<PhatState>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PhatState phatState = (PhatState)this.states.get(string);
            if (phatState == null) {
                return null;
            }
            vector2.addElement(phatState);
        }
        return new PhatStateGroup(vector2, this);
    }

    public PhatThreadGroup getThreads(Vector vector) {
        Vector<PhatThread> vector2 = new Vector<PhatThread>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            PhatThread phatThread = (PhatThread)this.threads.get(n);
            if (phatThread == null) {
                return null;
            }
            vector2.addElement(phatThread);
        }
        return new PhatThreadGroup(vector2, this, vector.toString());
    }

    public PhatThread getThread(int n) {
        return (PhatThread)this.threads.get(new Integer(n));
    }

    public PhatThreadGroup getThreads(int n, int n2) {
        Vector<PhatThread> vector = new Vector<PhatThread>();
        int n3 = n;
        while (n3 <= n2) {
            PhatThread phatThread = (PhatThread)this.threads.get(new Integer(n3));
            if (phatThread == null) {
                return null;
            }
            vector.addElement(phatThread);
            ++n3;
        }
        return new PhatThreadGroup(vector, this);
    }
}

