/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.PhatObject;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PhatState
extends PhatObject {
    protected long number;
    protected String sourceFile;
    protected static ImageIcon icon;
    protected JPopupMenu menu;
    protected PhatDataSet set;
    protected String timeIn = null;
    protected int badness;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public PhatState(String string, long l, String string2) {
        this.name = string;
        this.number = l;
        this.sourceFile = string2;
        this.color = Color.black;
        this.badness = 0;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == this.color) {
            return;
        }
        this.pcs.firePropertyChange("color", this.color, color);
        this.color = color;
    }

    public void setBadness(int n) {
        this.badness = n;
    }

    public int getBadness() {
        return this.badness;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        return this.number;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public Object clone() {
        PhatState phatState = new PhatState(this.name, this.number, this.sourceFile);
        phatState.color = this.color;
        phatState.timeIn = this.timeIn;
        phatState.set = this.set;
        return phatState;
    }

    public String toString() {
        return this.name;
    }

    public boolean isRemovable() {
        return false;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public void setDataSet(PhatDataSet phatDataSet) {
        this.set = phatDataSet;
    }

    public PhatDataSet getDataSet() {
        return this.set;
    }

    public String getExtendedInfo() {
        if (this.timeIn == null && this.set != null) {
            int n = (int)((float)this.set.getAllThreads().getTimeIn(this) / (float)this.set.getAllThreads().getCPUTime() * 100.0f);
            this.timeIn = n == 0 ? "" : "" + n + "%";
        } else if (this.set == null) {
            return "<UNKNOWN>";
        }
        return this.timeIn;
    }

    public String getPercentRuntime() {
        return this.getExtendedInfo();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static Image createContigIcon(PhatState phatState) {
        return PhatState.createIcon(phatState.getColor(), 18, 18, false);
    }

    public static Image createIcon(PhatState phatState) {
        return PhatState.createIcon(phatState.getColor());
    }

    public static Image createIcon(Color color) {
        return PhatState.createIcon(color, 16, 16, true);
    }

    public static Image createIcon(Color color, int n, int n2, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n3 = color.getRGB();
        Object object = colorModel.getDataElements(n3, null);
        int n4 = 1;
        while (n4 < n - 1) {
            int n5 = 1;
            while (n5 < n2 - 1) {
                writableRaster.setDataElements(n4, n5, object);
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            color = Color.black;
            n3 = color.getRGB();
            object = colorModel.getDataElements(n3, null);
            int n6 = 0;
            while (n6 < n) {
                writableRaster.setDataElements(n6, 0, object);
                writableRaster.setDataElements(n6, n2 - 1, object);
                ++n6;
            }
            int n7 = 0;
            while (n7 < n2) {
                writableRaster.setDataElements(0, n7, object);
                writableRaster.setDataElements(n2 - 1, n7, object);
                ++n7;
            }
        }
        return bufferedImage;
    }
}

