/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.PhatStateGroup;
import com.sun.forte.st.mpmt.timeline.ats.TimedObject;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class PhatThread
implements TimedObject {
    protected int number;
    protected transient short[] states;
    protected transient long[] times;
    protected JPopupMenu popup;
    protected static ResourceBundle messages;
    protected long[] timeIn;
    protected long[] numberTimesIn;

    public PhatThread() {
        this.number = 0;
        this.states = null;
        this.times = null;
        this.timeIn = new long[255];
        this.numberTimesIn = new long[255];
    }

    public PhatThread(int n, short[] sArray, long[] lArray) {
        this.number = n;
        this.states = sArray;
        this.times = lArray;
        this.timeIn = new long[255];
        this.numberTimesIn = new long[255];
        this.computeTimeIns();
    }

    public int getNumber() {
        return this.number;
    }

    public short[] getStates() {
        return this.states;
    }

    public long[] getTimes() {
        return this.times;
    }

    public long getStartTime() {
        return this.times[0];
    }

    public long getEndTime() {
        return this.times[this.times.length - 1];
    }

    public long getWallClockTime() {
        return this.getEndTime() - this.getStartTime();
    }

    public long getCPUTime() {
        return this.getWallClockTime();
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Visible", true);
            jCheckBoxMenuItem.setActionCommand("Toggle thread");
            this.popup.add(jCheckBoxMenuItem);
        }
        return this.popup;
    }

    public long getNumberTimesIn(PhatState phatState) {
        return 0L;
    }

    public long getTimeIn(PhatState phatState) {
        return 0L;
    }

    public long getTimeIn(PhatState phatState, long l, long l2) {
        int n = 0;
        while (n < this.times.length && this.times[n++] < l) {
        }
        int n2 = n - 1;
        while (n < this.times.length && this.times[n++] < l2) {
        }
        int n3 = n - 1;
        return this.compute(phatState, n2, n3, l, l2);
    }

    public long getTimeIn(PhatState phatState, float f, float f2) {
        long l = this.getWallClockTime();
        long l2 = (long)((float)l * f);
        long l3 = (long)((float)l * f2);
        return this.getTimeIn(phatState, l2, l3);
    }

    public long getTimeIn(PhatState phatState, double d, double d2) {
        long l = this.getWallClockTime();
        long l2 = (long)((double)l * d);
        long l3 = (long)((double)l * d2);
        return this.getTimeIn(phatState, l2, l3);
    }

    public long compute(PhatState phatState, int n, int n2, long l, long l2) {
        long l3 = phatState.getNumber();
        long l4 = 0L;
        int n3 = n;
        if (this.times[n] < l2) {
            while (n3 < n2) {
                if ((long)this.states[n3++] != l3) continue;
                l4 += this.times[n3] - this.times[n3 - 1];
            }
            if (n > 0 && (long)this.states[n - 1] == l3 && this.times[n] > l) {
                l4 += this.times[n] - l;
            }
            if ((long)this.states[n] == l3 && this.times[n] < l) {
                l4 -= l - this.times[n];
            }
            if ((long)this.states[n2 - 1] == l3 && this.times[n2] > l2) {
                l4 -= this.times[n2] - l2;
            }
        } else if (n > 0 && (long)this.states[n - 1] == l3 && this.times[n - 1] < l && this.times[n] > l2) {
            l4 += l2 - l;
        }
        return l4;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l += this.getTimeIn((PhatState)enumeration.nextElement());
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, float f, float f2) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l += this.getTimeIn((PhatState)enumeration.nextElement(), f, f2);
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, double d, double d2) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l += this.getTimeIn((PhatState)enumeration.nextElement(), d, d2);
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, long l, long l2) {
        long l3 = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l3 += this.getTimeIn((PhatState)enumeration.nextElement(), l, l2);
        }
        return l3;
    }

    public void computeTimeIns() {
        this.timeIn = new long[255];
        this.numberTimesIn = new long[255];
        int n = 0;
        while (n < this.times.length - 1) {
            short s = this.states[n];
            this.timeIn[s] = this.timeIn[s] + (this.times[n + 1] - this.times[n]);
            short s2 = this.states[n];
            this.numberTimesIn[s2] = this.numberTimesIn[s2] + 1L;
            ++n;
        }
    }

    public String toString() {
        return "Thread: " + this.number;
    }

    public String getVersion() {
        return "PhatThread 1.5 03/07/02";
    }
}

