/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.PhatObject;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.PhatStateGroup;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import com.sun.forte.st.mpmt.timeline.ats.TimedObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class PhatThreadGroup
extends PhatObject
implements TimedObject {
    protected Hashtable threads = new Hashtable();
    protected Hashtable states;
    protected Vector threadVector = new Vector();
    protected long min;
    protected long max;
    protected long wallClockTime;
    protected long cpuTime;
    protected String name;
    protected PhatDataSet data;
    protected static ResourceBundle messages;

    public PhatThreadGroup(Vector vector, PhatDataSet phatDataSet) {
        this(vector, phatDataSet, "zzzz");
    }

    public PhatThreadGroup(Vector vector, PhatDataSet phatDataSet, String string) {
        this.data = phatDataSet;
        this.min = Long.MAX_VALUE;
        this.max = 0L;
        this.cpuTime = 0L;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TimedObject timedObject = (TimedObject)enumeration.nextElement();
            this.threadVector.add(0, timedObject);
            if (timedObject instanceof PhatThread) {
                this.threads.put(new Integer(((PhatThread)timedObject).getNumber()), timedObject);
            } else {
                ((PhatThreadGroup)timedObject).data = phatDataSet;
            }
            if (timedObject.getStartTime() < this.min) {
                this.min = timedObject.getStartTime();
            }
            if (timedObject.getEndTime() > this.max) {
                this.max = timedObject.getEndTime();
            }
            this.cpuTime += timedObject.getCPUTime();
        }
        this.wallClockTime = this.max - this.min;
        this.name = string;
    }

    public Hashtable getMap() {
        return this.doRecurse(new Hashtable(), this);
    }

    public long getStartTime() {
        return this.min;
    }

    public long getEndTime() {
        return this.max;
    }

    public long getWallClockTime() {
        return this.wallClockTime;
    }

    public long getCPUTime() {
        return this.cpuTime;
    }

    public double getAverageTimeIn(PhatState phatState) {
        long l = this.getTimeIn(phatState);
        long l2 = 0L;
        Enumeration enumeration = this.doRecurse(new Vector(), this);
        while (enumeration.hasMoreElements()) {
            l2 += ((PhatThread)enumeration.nextElement()).getNumberTimesIn(phatState);
        }
        return (double)l / (double)l2 / 1000000.0;
    }

    public long getTimeIn(PhatState phatState) {
        long l = 0L;
        Enumeration enumeration = this.doRecurse(new Vector(), this);
        while (enumeration.hasMoreElements()) {
            l += ((PhatThread)enumeration.nextElement()).getTimeIn(phatState);
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof PhatState) {
                l += this.getTimeIn((PhatState)v);
                continue;
            }
            if (!(v instanceof PhatStateGroup)) continue;
            l += this.getTimeIn((PhatStateGroup)v);
        }
        return l;
    }

    public long getTimeIn(PhatState phatState, long l, long l2) {
        long l3 = 0L;
        Enumeration enumeration = this.doRecurse(new Vector(), this);
        while (enumeration.hasMoreElements()) {
            l3 += ((PhatThread)enumeration.nextElement()).getTimeIn(phatState, l, l2);
        }
        return l3;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, long l, long l2) {
        long l3 = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l3 += ((PhatThread)enumeration.nextElement()).getTimeIn(phatStateGroup, l, l2);
        }
        return l3;
    }

    public long getTimeIn(PhatState phatState, double d, double d2) {
        long l = 0L;
        Enumeration enumeration = this.doRecurse(new Vector(), this);
        while (enumeration.hasMoreElements()) {
            l += ((PhatThread)enumeration.nextElement()).getTimeIn(phatState, d, d2);
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, double d, double d2) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l += ((PhatThread)enumeration.nextElement()).getTimeIn(phatStateGroup, d, d2);
        }
        return l;
    }

    public long getTimeIn(PhatState phatState, float f, float f2) {
        long l = 0L;
        Enumeration enumeration = this.doRecurse(new Vector(), this);
        while (enumeration.hasMoreElements()) {
            l += ((PhatThread)enumeration.nextElement()).getTimeIn(phatState, f, f2);
        }
        return l;
    }

    public long getTimeIn(PhatStateGroup phatStateGroup, float f, float f2) {
        long l = 0L;
        Enumeration enumeration = phatStateGroup.getMap().elements();
        while (enumeration.hasMoreElements()) {
            l += ((PhatThread)enumeration.nextElement()).getTimeIn(phatStateGroup, f, f2);
        }
        return l;
    }

    public Enumeration elements() {
        return this.threadVector.elements();
    }

    public Enumeration allChildThreads() {
        Vector vector = new Vector();
        return this.doRecurse(vector, this);
    }

    public Vector getAllThreads() {
        if (this.threadVector.elementAt(0) instanceof PhatThreadGroup) {
            return ((PhatThreadGroup)this.threadVector.elementAt(0)).getAllThreads();
        }
        return this.threadVector;
    }

    public int numThreads() {
        Vector vector = new Vector();
        this.doRecurse(vector, this);
        return vector.size();
    }

    private Enumeration doRecurse(Vector vector, PhatThreadGroup phatThreadGroup) {
        Enumeration enumeration = phatThreadGroup.threadVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PhatThread) {
                vector.add(e);
                continue;
            }
            if (!(e instanceof PhatThreadGroup)) continue;
            this.doRecurse(vector, (PhatThreadGroup)e);
        }
        return vector.elements();
    }

    private Hashtable doRecurse(Hashtable hashtable, PhatThreadGroup phatThreadGroup) {
        Enumeration enumeration = phatThreadGroup.threadVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PhatThread) {
                hashtable.put(new Integer(((PhatThread)e).getNumber()), e);
                continue;
            }
            if (!(e instanceof PhatThreadGroup)) continue;
            this.doRecurse(hashtable, (PhatThreadGroup)e);
        }
        return hashtable;
    }

    public PhatDataSet getParentDataSet() {
        return this.data;
    }

    public String toString() {
        return this.name;
    }

    public boolean isRemovable() {
        return false;
    }

    public void status(String string) {
        System.out.println("PhatThreadGroup: " + string);
    }

    public Vector getObjects() {
        return this.threadVector;
    }
}

