/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.TimeRule;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import com.sun.forte.st.mpmt.timeline.ats.VerticalRuler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;

public class ThreadDraw
extends JComponent {
    protected Timeline canvas;
    protected ThreadViewEvent eventHolder;
    protected boolean[] activeArray;
    protected transient Hashtable colorMap;
    protected int numThreads;
    protected transient TimeRule rule;
    protected transient VerticalRuler vRule;

    public ThreadDraw(Timeline timeline, TimeRule timeRule, boolean[] blArray, Hashtable hashtable, int n) {
        this.canvas = timeline;
        this.rule = timeRule;
        this.numThreads = n;
        this.activeArray = blArray;
        this.colorMap = hashtable;
        this.vRule = (VerticalRuler)timeline.getVerticalRuler();
        this.eventHolder = new ThreadViewEvent(this, "tmp");
        this.setupActions();
    }

    public void setEventHolder(ThreadViewEvent threadViewEvent) {
        this.eventHolder = threadViewEvent;
    }

    public void setActiveArray(boolean[] blArray) {
        this.activeArray = blArray;
    }

    public void setColorMap(Hashtable hashtable) {
        this.colorMap = hashtable;
    }

    public void update(Graphics graphics) {
        int n;
        if (this.eventHolder.data == null) {
            return;
        }
        this.canvas.setRepainting(true);
        int n2 = this.canvas.getVScroll().getValue();
        int n3 = n = this.canvas.getBarHeight();
        int n4 = this.canvas.getBarSpace();
        int n5 = n3 + n4;
        boolean bl = true;
        this.canvas.getHScroll().setValue(this.eventHolder.hScroll);
        int n6 = 0;
        while (n6 < this.numThreads) {
            if (!this.activeArray[n6]) {
                n2 += n + n4;
            } else {
                int n7 = 0;
                int n8 = 0;
                long[] lArray = this.eventHolder.data[n6];
                int n9 = lArray.length;
                n = n3;
                bl = this.eventHolder.x == -1;
                int n10 = 0;
                while (n10 < n9 && lArray[n10] != -1L) {
                    Color color = (Color)this.colorMap.get(new Long(lArray[n10]));
                    n8 = (int)lArray[n10 + 1];
                    if (!bl && n7 + n8 > this.eventHolder.x) {
                        if (this.eventHolder.isSmall && n6 == this.eventHolder.thread) {
                            graphics.setColor(Color.white);
                            graphics.fillRect(n7, n6 * n5 - n2, 1, n);
                            ++n7;
                            --n8;
                            graphics.setColor(color);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        bl = true;
                    } else {
                        graphics.setColor(color);
                    }
                    graphics.fillRect(n7, n6 * n5 - n2, n8, n);
                    n7 += n8;
                    n10 += 2;
                }
                if (this.eventHolder.thread == n6) {
                    graphics.setColor(Color.white);
                    graphics.setXORMode(Color.gray);
                    graphics.drawLine(0, n6 * n5 - n2 + n / 2, this.getWidth(), n6 * n5 - n2 + n / 2);
                    graphics.setPaintMode();
                }
            }
            ++n6;
        }
        this.rule.setUnits((long)this.eventHolder.hScroll * this.eventHolder.timeStep, (long)(this.eventHolder.hScroll + this.eventHolder.width) * this.eventHolder.timeStep);
        this.rule.repaint();
        this.vRule.repaint();
        if (this.eventHolder.x != -1) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.gray);
            graphics.drawLine(this.eventHolder.x, 0, this.eventHolder.x, this.getHeight());
        }
        this.canvas.setRepainting(false);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public int getThreadAt(int n) {
        int n2;
        int n3 = this.canvas.getVScroll().getValue();
        int n4 = n2 = this.canvas.getBarHeight();
        int n5 = this.canvas.getBarSpace();
        int n6 = n4 + n5;
        this.canvas.getHScroll().setValue(this.eventHolder.hScroll);
        int n7 = 0;
        while (n7 < this.numThreads) {
            if (!this.activeArray[n7]) {
                n3 += n2 + n5;
            } else {
                n2 = n4;
                if (n7 * n6 - n3 < n && n7 * n6 - n3 + n2 > n) {
                    return n7;
                }
            }
            ++n7;
        }
        return -1;
    }

    public void processClick(int n, int n2) {
        ThreadViewEvent threadViewEvent = new ThreadViewEvent(this.canvas, "Clicked");
        threadViewEvent.thread = this.getThreadAt(n2);
        threadViewEvent.x = n;
        this.canvas.getRenderer().computeDrawing(threadViewEvent);
    }

    public int getUsedHeight() {
        return this.getHeight();
    }

    public String getDescription(MouseEvent mouseEvent) {
        return null;
    }

    protected void setupActions() {
        MoveLeft moveLeft = new MoveLeft();
        this.registerKeyboardAction(moveLeft, KeyStroke.getKeyStroke(37, 0), 0);
        this.registerKeyboardAction(moveLeft, KeyStroke.getKeyStroke(226, 0), 0);
        this.registerKeyboardAction(moveLeft, KeyStroke.getKeyStroke(100, 0), 0);
        MoveRight moveRight = new MoveRight();
        this.registerKeyboardAction(moveRight, KeyStroke.getKeyStroke(39, 0), 0);
        this.registerKeyboardAction(moveRight, KeyStroke.getKeyStroke(227, 0), 0);
        this.registerKeyboardAction(moveRight, KeyStroke.getKeyStroke(102, 0), 0);
        Home home = new Home();
        this.registerKeyboardAction(home, KeyStroke.getKeyStroke(36, 0), 0);
        this.registerKeyboardAction(home, KeyStroke.getKeyStroke(103, 0), 0);
        End end = new End();
        this.registerKeyboardAction(end, KeyStroke.getKeyStroke(35, 0), 0);
        this.registerKeyboardAction(end, KeyStroke.getKeyStroke(97, 0), 0);
    }

    public String getVersion() {
        return "ThreadDraw 1.6 08/21/00";
    }

    protected class End
    implements ActionListener,
    Serializable {
        protected End() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = ThreadDraw.this.canvas.getHScroll();
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
    }

    protected class Home
    implements ActionListener,
    Serializable {
        protected Home() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = ThreadDraw.this.canvas.getHScroll();
            jScrollBar.setValue(0);
        }
    }

    protected class MoveRight
    implements ActionListener,
    Serializable {
        protected MoveRight() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = ThreadDraw.this.canvas.getHScroll();
            jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement());
        }
    }

    protected class MoveLeft
    implements ActionListener,
    Serializable {
        protected MoveLeft() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = ThreadDraw.this.canvas.getHScroll();
            jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getBlockIncrement());
        }
    }
}

