/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.ThreadDraw;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import com.sun.forte.st.mpmt.timeline.ats.ZoomHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

class ThreadMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private int beginDragX = -1;
    private int beginDragY = -1;
    private int endDragX = -1;
    private int endDragY = -1;
    private int rubberBandMode = 2;
    private Timeline canvas;
    private ThreadDraw draw;
    private ZoomHandler zoomHandler;
    private Stroke outlineStroke;

    public ThreadMouseAdapter(Timeline timeline, ThreadDraw threadDraw) {
        this.draw = threadDraw;
        this.canvas = timeline;
        this.zoomHandler = timeline.getZoomHandler();
        this.outlineStroke = new BasicStroke(2.0f);
    }

    public void setRubberBanding(int n) {
        this.rubberBandMode = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.draw.processClick(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.beginDragX = -mouseEvent.getX();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.draw.setCursor(Cursor.getPredefinedCursor(1));
        this.draw.requestFocus();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.beginDragX < 0) {
            this.beginDragX = -this.beginDragX;
            this.beginDragY = mouseEvent.getY();
        }
        Graphics2D graphics2D = (Graphics2D)this.draw.getGraphics();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.setColor(Color.black);
        graphics2D.setXORMode(Color.gray);
        if (this.endDragX != -1) {
            switch (this.rubberBandMode) {
                case 2: {
                    graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), Math.min(this.beginDragY, this.endDragY), Math.abs(this.endDragX - this.beginDragX), Math.abs(this.endDragY - this.beginDragY));
                    break;
                }
                case 1: {
                    graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), 0, Math.abs(this.endDragX - this.beginDragX), this.draw.getUsedHeight());
                }
            }
        }
        this.endDragY = mouseEvent.getY();
        this.endDragX = mouseEvent.getX();
        switch (this.rubberBandMode) {
            case 2: {
                graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), Math.min(this.beginDragY, this.endDragY), Math.abs(this.endDragX - this.beginDragX), Math.abs(this.endDragY - this.beginDragY));
                break;
            }
            case 1: {
                graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), 0, Math.abs(this.endDragX - this.beginDragX), this.draw.getUsedHeight());
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.beginDragX < 0) {
            return;
        }
        int n = Math.min(this.beginDragX, mouseEvent.getX());
        int n2 = Math.max(this.beginDragX, mouseEvent.getX());
        int n3 = Math.min(this.beginDragY, mouseEvent.getY());
        int n4 = Math.max(this.beginDragY, mouseEvent.getY());
        Graphics2D graphics2D = (Graphics2D)this.draw.getGraphics();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.setColor(Color.black);
        graphics2D.setXORMode(Color.gray);
        switch (this.rubberBandMode) {
            case 2: {
                graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), Math.min(this.beginDragY, this.endDragY), Math.abs(this.endDragX - this.beginDragX), Math.abs(this.endDragY - this.beginDragY));
                break;
            }
            case 1: {
                graphics2D.drawRect(Math.min(this.beginDragX, this.endDragX), 0, Math.abs(this.endDragX - this.beginDragX), this.draw.getUsedHeight());
            }
        }
        if (Math.abs(n - n2) > 5) {
            this.zoomHandler.rubberbandZoom(n, n2, n3, n4);
        }
        this.beginDragX = -1;
        this.beginDragY = -1;
        this.endDragX = -1;
        this.endDragY = -1;
        graphics2D.setStroke(stroke);
    }
}

