/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import com.sun.forte.st.mpmt.timeline.ats.PhatThreadGroup;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import java.util.Enumeration;

public class ThreadViewRenderer {
    protected transient PhatThreadGroup group;
    protected long[][] subData;
    protected transient long[][] subTimes;
    protected transient short[][] data;
    protected transient long[][] times;
    protected int[] lastIndex;
    protected long lastStart;
    protected int start;
    protected int width;
    protected long maxTime;
    protected long timeStep;
    protected int windowWidth;
    protected float zoom;
    protected ThreadViewEvent currentEvent;
    protected int numThreads;
    protected int thread = -1;
    protected int navigationIndex = -2;
    protected int xSel = -1;
    protected long time = -1L;
    protected long timeAt = -1L;
    protected int lastThread;
    protected int lastNav;
    protected boolean isSmall;
    protected ThreadViewEvent out;
    protected ThreadViewEvent last;
    private static int nextInstance = 0;
    private int myInstance;
    protected PhatDataSet set;
    protected Timeline canvas;

    public ThreadViewRenderer() {
    }

    public ThreadViewRenderer(Timeline timeline) {
        this.canvas = timeline;
        this.out = new ThreadViewEvent(this, "Render");
        this.zoom = 1.0f;
    }

    public void setDataSet(PhatDataSet phatDataSet) {
        this.set = phatDataSet;
        this.group = phatDataSet.getAllThreads();
        this.maxTime = this.group.getEndTime();
        this.numThreads = this.group.numThreads();
        this.data = new short[this.numThreads][];
        this.times = new long[this.numThreads][];
        this.lastIndex = new int[this.numThreads];
        int n = 0;
        Enumeration enumeration = this.group.allChildThreads();
        while (enumeration.hasMoreElements()) {
            PhatThread phatThread = (PhatThread)enumeration.nextElement();
            this.data[n] = phatThread.getStates();
            this.times[n] = phatThread.getTimes();
            this.lastIndex[n] = -1;
            ++n;
        }
        this.subData = new long[n][];
        this.myInstance = ++nextInstance;
    }

    public short[][] getData() {
        return this.data;
    }

    public ThreadViewEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void computeDrawing(ThreadViewEvent threadViewEvent) {
        ThreadViewEvent threadViewEvent2 = threadViewEvent;
        if (threadViewEvent2.zoom == -1.0f && threadViewEvent2.width == -1 && threadViewEvent2.hScroll == this.start && threadViewEvent2.direction == -1 && threadViewEvent2.x <= 0) {
            return;
        }
        if (threadViewEvent2.zoom != -1.0f) {
            this.zoom = threadViewEvent2.zoom;
        }
        this.out.zoom = this.zoom;
        if (threadViewEvent2.width > 0) {
            this.width = threadViewEvent2.width;
            this.subData = new long[this.numThreads][];
            int n = 0;
            while (n < this.numThreads) {
                this.subData[n] = new long[(this.width + 1) * 2 + 1];
                ++n;
            }
        }
        this.out.width = this.width;
        if (threadViewEvent2.hScroll != -1) {
            this.start = threadViewEvent2.hScroll;
        }
        this.out.hScroll = this.start;
        if (threadViewEvent2.windowWidth != -1) {
            this.windowWidth = threadViewEvent2.windowWidth;
        }
        this.out.windowWidth = this.windowWidth;
        if (threadViewEvent2.findIndex != -1) {
            this.navigationIndex = threadViewEvent2.findIndex - 1;
            this.thread = threadViewEvent2.thread;
        }
        if (threadViewEvent2.direction == -2) {
            ++this.navigationIndex;
            this.render();
            threadViewEvent2.x = this.xSel;
        } else if (threadViewEvent2.direction == -3) {
            --this.navigationIndex;
            this.render();
            threadViewEvent2.x = this.xSel;
        } else if (threadViewEvent2.direction == -4 && this.thread > 0) {
            --this.thread;
            this.last.thread = this.thread;
            this.findState(this.last, this.out);
            threadViewEvent2 = this.last;
        } else if (threadViewEvent2.direction == -5 && this.thread < this.numThreads - 1) {
            ++this.thread;
            this.last.thread = this.thread;
            this.findState(this.last, this.out);
            threadViewEvent2 = this.last;
        } else if (threadViewEvent2.x >= 0 && threadViewEvent2.thread != -1) {
            this.findState(threadViewEvent2, this.out);
        } else if (threadViewEvent2.findIndex == -1 && threadViewEvent2.x == -1) {
            this.navigationIndex = -2;
            this.render();
        } else {
            this.render();
        }
        if (this.navigationIndex == -1) {
            this.out.thread = this.thread;
            this.out.state = 0L;
            this.out.x = this.xSel;
            this.out.time = this.times[this.thread][0];
            this.out.timeAt = 0L;
            this.out.isSmall = this.isSmall;
        } else if (this.navigationIndex != -2 && this.navigationIndex < this.times[this.thread].length - 1) {
            this.out.thread = this.thread;
            this.out.state = this.data[this.thread][this.navigationIndex];
            this.out.x = this.xSel;
            this.out.time = this.times[this.thread][this.navigationIndex + 1] - this.times[this.thread][this.navigationIndex];
            this.out.timeAt = this.times[this.thread][this.navigationIndex];
            this.out.isSmall = this.isSmall;
        }
        this.out.data = this.subData;
        this.out.timeStep = this.timeStep;
        this.currentEvent = this.out;
        this.last = threadViewEvent2;
        this.sendReply(this.out);
    }

    public void sendReply(ThreadViewEvent threadViewEvent) {
        this.canvas.redraw(threadViewEvent);
        this.out = new ThreadViewEvent(this, "Render");
    }

    private void findState(ThreadViewEvent threadViewEvent, ThreadViewEvent threadViewEvent2) {
        this.doCalculations();
        short s = 0;
        int n = this.start - 1;
        int n2 = 0;
        int n3 = -1;
        short[] sArray = this.data[threadViewEvent.thread];
        long[] lArray = this.times[threadViewEvent.thread];
        this.navigationIndex = -1;
        int n4 = sArray.length;
        int n5 = -1;
        long l = this.timeStep * (long)this.start;
        while (n3 == -1 && n5 + 1 < n4) {
            if (l >= lArray[n5 + 1]) {
                while (n5 + 1 < n4 && l > lArray[n5 + 1]) {
                    ++n5;
                }
                s = sArray[n5];
                if (n < threadViewEvent.x + this.start) {
                    n2 = n;
                    this.navigationIndex = n5;
                } else if (n >= threadViewEvent.x) {
                    n3 = n;
                }
            }
            ++n;
            l += this.timeStep;
        }
        if (this.navigationIndex == -1) {
            this.thread = threadViewEvent.thread;
            this.xSel = threadViewEvent.x;
            this.time = lArray[0];
            this.timeAt = 0L;
            this.isSmall = false;
        } else if (lArray.length > this.navigationIndex + 1) {
            this.thread = threadViewEvent.thread;
            this.xSel = threadViewEvent.x;
            this.time = lArray[this.navigationIndex + 1] - lArray[this.navigationIndex];
            this.timeAt = lArray[this.navigationIndex];
            this.isSmall = false;
        } else {
            this.navigationIndex = -2;
        }
        if (this.navigationIndex == this.lastNav && this.thread == this.lastThread) {
            this.navigationIndex = -2;
            this.lastNav = -2;
            this.lastThread = -1;
        } else {
            this.lastNav = this.navigationIndex;
            this.lastThread = this.thread;
        }
    }

    private void render() {
        this.doCalculations();
        int n = 0;
        while (n < this.numThreads) {
            int n2 = this.findFirstIndex(n);
            if (this.data[n] != null) {
                this.render(this.data[n], this.times[n], n, n2);
            }
            ++n;
        }
        this.lastStart = this.start;
    }

    public void doCalculations() {
        if (this.width == 0) {
            return;
        }
        if (this.zoom <= 0.0f) {
            this.zoom = 1.0f;
        }
        this.timeStep = (float)this.width * this.zoom > (float)this.maxTime ? 1L : (long)((float)this.maxTime / this.zoom / (float)this.width);
    }

    protected void render(short[] sArray, long[] lArray, int n, int n2) {
        int n3 = this.start;
        int n4 = 0;
        int n5 = sArray.length;
        int n6 = n2 + 1;
        this.lastIndex[n] = -1;
        int n7 = 0;
        int n8 = this.start;
        boolean bl = false;
        long l = this.timeStep * (long)this.start;
        int n9 = this.start + this.width;
        boolean bl2 = false;
        if (n == this.thread) {
            bl2 = true;
            this.xSel = -1;
            this.isSmall = false;
        }
        while (n3 < n9) {
            if (n6 <= n5 && l >= lArray[n6]) {
                this.subData[n][n4++] = n7;
                this.subData[n][n4++] = (short)(n3 - n8);
                if (bl2 && this.xSel == -1 && n2 == this.navigationIndex) {
                    this.xSel = n8 + (n3 - n8) / 2 - this.start;
                } else if (bl2 && this.xSel == -1 && n2 > this.navigationIndex) {
                    this.xSel = n8 - this.start;
                    this.isSmall = true;
                }
                try {
                    while (l > lArray[n6]) {
                        ++n6;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                n2 = n6 - 1;
                if (this.lastIndex[n] == -1) {
                    this.lastIndex[n] = n2;
                }
                n8 = n3;
                n7 = sArray[n2];
            }
            ++n3;
            l += this.timeStep;
        }
        if (this.xSel == 0) {
            this.xSel = -1;
        }
        this.subData[n][n4++] = n7;
        this.subData[n][n4++] = (short)(n3 - n8);
        this.subData[n][n4++] = -1L;
    }

    private int findFirstIndex(int n) {
        int n2 = this.lastIndex[n];
        long l = this.timeStep * (long)this.start;
        if (this.out.windowWidth != -1) {
            return -1;
        }
        try {
            if (this.lastStart > (long)this.start) {
                ++n2;
                while (l < this.times[n][n2]) {
                    --n2;
                }
            }
            long l2 = this.times[n][--n2];
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public String toString() {
        return "ViewRenderer " + this.myInstance;
    }

    public String getVersion() {
        return "ThreadViewRenderer 1.8 04/04/02";
    }
}

