/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import com.sun.forte.st.mpmt.timeline.ats.VerticalRuler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class TimeRule
extends JComponent {
    public static final int HEIGHT = 27;
    public static final int PAD = 30;
    public static final int OUTLINE = 1;
    public static final int OUTLINE_THRESH = 1;
    public int size;
    private int increment;
    private long startTime;
    private long stopTime;
    private long timeStep;
    private int selection = -1;
    private int selectWidth = -1;
    private Component rigidArea;
    private JComponent infoPanel;
    private Timeline canvas;
    private String labelText = "";
    private Color backColor;

    public TimeRule(Timeline timeline) {
        this.setLayout(new BoxLayout(this, 1));
        this.canvas = timeline;
        this.infoPanel = timeline.getNavigationBar();
        this.add(this.infoPanel);
        this.size += this.infoPanel.getPreferredSize().height;
        this.rigidArea = Box.createRigidArea(new Dimension(0, 27));
        this.add(this.rigidArea);
        this.size += 27;
    }

    public void setIncrement(int n) {
        this.increment = n;
    }

    public void setUnits(long l, long l2) {
        this.startTime = l;
        this.stopTime = l2;
    }

    public void setSelection(int n, int n2) {
        this.selection = n;
        this.selectWidth = n2;
    }

    public void setTimeStep(long l) {
        this.timeStep = l;
    }

    public void setLabelString(String string) {
        this.labelText = string;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.canvas.getWidth(), this.size);
    }

    public void paintComponent(Graphics graphics) {
        long l;
        int n;
        this.infoPanel.repaint();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.selection != -1) {
            graphics.setColor(VerticalRuler.SELECT_COLOR);
            if (this.selectWidth > 1) {
                graphics.fillRect(this.selection + 30 - 1, this.size - 27, 1, 27);
                graphics.fillRect(this.selection + 30 + this.selectWidth, this.size - 27, 1, 27);
                graphics.setColor(Color.white);
                graphics.fillRect(this.selection + 30, this.size - 27, this.selectWidth, 27);
            } else {
                graphics.fillRect(this.selection + 30, this.size - 27, this.selectWidth, 27);
            }
        }
        graphics.setColor(Color.white);
        graphics.drawLine(0, this.size - 1, rectangle.width, this.size - 1);
        graphics.drawLine(29, 0, 29, this.size - 3);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, this.size - 2, rectangle.width, this.size - 2);
        graphics.drawLine(28, 0, 28, this.size - 3);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.setColor(Color.black);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        long l2 = 1L;
        boolean bl = false;
        string = this.labelText;
        if (this.stopTime - this.startTime < 10000000L) {
            n = 3;
            l = 1000000L;
        } else if (this.stopTime - this.startTime < 40000000L) {
            n = 3;
            l = 5000000L;
            l2 = 5L;
        } else if (this.stopTime - this.startTime < 100000000L) {
            n = 2;
            l = 10000000L;
        } else if (this.stopTime - this.startTime < 400000000L) {
            n = 2;
            l = 50000000L;
            l2 = 5L;
        } else if (this.stopTime - this.startTime < 1000000000L) {
            n = 1;
            l = 100000000L;
        } else if (this.stopTime - this.startTime < 4000000000L) {
            n = 1;
            l = 500000000L;
            l2 = 5L;
        } else {
            n = 0;
            l = 1000000000L;
        }
        long l3 = l;
        graphics.setColor(Color.black);
        graphics.drawString(string, 15 - string.length() * 5 / 2, this.size - 13);
        n3 = 30;
        n2 = this.getWidth();
        string = null;
        int n5 = n2 - n3;
        long l4 = this.stopTime - this.startTime;
        while (l4 / l > 30L) {
            l *= 2L;
        }
        long l5 = 0L;
        int n6 = 0;
        while (n6 < n2 - n3) {
            long l6 = this.startTime + (long)n6 * this.timeStep;
            if (l6 % l < l5 % l) {
                string = Long.toString(l6 / l3 * l2);
                n4 = 6;
            } else if (l6 % (l / 2L) < l5 % (l / 2L)) {
                string = null;
                n4 = 4;
            } else if (l6 % (l / 4L) < l5 % (l / 4L)) {
                string = null;
                n4 = 2;
            } else if (l6 % (l / 8L) < l5 % (l / 8L)) {
                string = null;
                n4 = 1;
            } else {
                n4 = 0;
            }
            if (n4 != 0) {
                graphics.drawLine(n6 + n3, this.size - 3, n6 + n3, this.size - n4 - 3);
                if (string != null) {
                    if (n > 0) {
                        String string2;
                        String string3;
                        if (string.length() >= n) {
                            string3 = string.substring(0, string.length() - n);
                            string2 = "." + string.substring(string.length() - n);
                        } else {
                            string3 = ".";
                            int n7 = 0;
                            while (n7 < n - string.length()) {
                                string3 = string3 + "0";
                                ++n7;
                            }
                            string2 = string;
                        }
                        string = string3 + string2;
                    }
                    if (bl) {
                        string = string.substring(0, 1) + "e" + string.length();
                    }
                    graphics.drawString(string, n6 + n3 - 3, this.size - 13);
                }
            }
            l5 = l6;
            ++n6;
        }
    }
}

