/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.NavigationBar;
import com.sun.forte.st.mpmt.timeline.ats.PhatDataSet;
import com.sun.forte.st.mpmt.timeline.ats.PhatState;
import com.sun.forte.st.mpmt.timeline.ats.PhatStateGroup;
import com.sun.forte.st.mpmt.timeline.ats.PhatThread;
import com.sun.forte.st.mpmt.timeline.ats.PhatThreadGroup;
import com.sun.forte.st.mpmt.timeline.ats.ThreadDraw;
import com.sun.forte.st.mpmt.timeline.ats.ThreadMouseAdapter;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewLayout;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewRenderer;
import com.sun.forte.st.mpmt.timeline.ats.TimeRule;
import com.sun.forte.st.mpmt.timeline.ats.VerticalRuler;
import com.sun.forte.st.mpmt.timeline.ats.ZoomHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JScrollBar;

public class Timeline
extends JComponent
implements AdjustmentListener,
ComponentListener,
PropertyChangeListener {
    public static final int STATIC_BARS = 1;
    public static final int DYNAMIC_BARS = 2;
    protected static Hashtable installedViews;
    protected PhatDataSet set;
    protected PhatThreadGroup group;
    protected PhatStateGroup sGroup;
    protected Vector states;
    protected Hashtable colorMap;
    protected transient NavigationBar navigationBar;
    protected transient JScrollBar hScroll;
    protected transient JScrollBar vScroll;
    protected transient TimeRule rule;
    protected transient VerticalRuler verticalRuler;
    protected ZoomHandler zoomHandler;
    protected ThreadMouseAdapter mouseAdapter;
    protected boolean showSnapShot = false;
    protected transient ThreadViewRenderer renderer;
    protected transient ThreadViewRenderer originalRenderer;
    private Vector threads;
    protected transient JComboBox comboBox;
    protected transient JButton next;
    protected transient JButton prev;
    protected transient JButton up;
    protected transient JButton down;
    protected String name;
    protected String title;
    protected int numThreads;
    protected transient JMenu linkMenu;
    protected transient ThreadViewEvent eventHolder;
    protected transient ThreadDraw threadDraw;
    protected PhatStateGroup stateGroup;
    protected boolean isFullDataSet;
    protected boolean[] activeArray;
    protected boolean compilerDelayHack = false;
    private int oldWidth = 0;
    protected int oldHScroll;
    boolean repainting = false;
    protected static Color[] allColors;
    private static ResourceBundle messages;
    static final NumberFormat numberFormat;

    public Timeline() {
        this.setLayout(new ThreadViewLayout(this));
        this.navigationBar = new NavigationBar(this);
        this.renderer = new ThreadViewRenderer(this);
        this.rule = new TimeRule(this);
        this.rule.setIncrement(50);
        this.add(this.rule);
        this.verticalRuler = new VerticalRuler(this);
        this.add(this.verticalRuler);
        this.hScroll = new JScrollBar(0);
        this.vScroll = new JScrollBar(1);
        this.hScroll.addAdjustmentListener(this);
        this.vScroll.addAdjustmentListener(this);
        this.add(this.hScroll);
        this.add(this.vScroll);
        this.eventHolder = new ThreadViewEvent(this, "Initial sizing");
        this.eventHolder.width = 630;
        this.eventHolder.zoom = 1.0f;
        this.eventHolder.windowWidth = 640;
        this.zoomHandler = new ZoomHandler(this);
        this.zoomHandler.setEventHolder(this.eventHolder);
        this.addComponentListener(this);
    }

    public void setDataSet(PhatDataSet phatDataSet) {
        PhatState phatState;
        this.set = phatDataSet;
        this.name = phatDataSet.getName();
        this.group = phatDataSet.getAllThreads();
        this.isFullDataSet = true;
        this.stateGroup = phatDataSet.getAllStates();
        this.states = this.stateGroup.getStates();
        if (!installedViews.containsKey(phatDataSet)) {
            installedViews.put(phatDataSet, new Vector());
        }
        this.setName(this.name);
        this.navigationBar.setDataSet(phatDataSet);
        this.renderer.setDataSet(phatDataSet);
        this.threads = new Vector();
        int n = 0;
        Enumeration enumeration = this.group.allChildThreads();
        while (enumeration.hasMoreElements()) {
            PhatThread phatThread = (PhatThread)enumeration.nextElement();
            this.threads.addElement(phatThread);
            ++n;
        }
        this.numThreads = this.threads.size();
        this.activeArray = new boolean[this.numThreads];
        n = 0;
        while (n < this.numThreads) {
            this.activeArray[n] = true;
            ++n;
        }
        this.colorMap = new Hashtable();
        this.setThreadDraw(new ThreadDraw(this, this.rule, this.activeArray, this.colorMap, this.numThreads));
        boolean bl = false;
        Enumeration enumeration2 = this.states.elements();
        while (enumeration2.hasMoreElements()) {
            phatState = (PhatState)enumeration2.nextElement();
            phatState.addPropertyChangeListener(this);
            this.colorMap.put(new Long(phatState.getNumber()), phatState.getColor());
            if (phatState.getColor() == Color.black) continue;
            bl = true;
        }
        if (!bl) {
            Random random = new Random();
            int n2 = 0;
            n = 0;
            while (n < this.states.size()) {
                Color color = Color.black;
                phatState = (PhatState)this.states.elementAt(n);
                int n3 = Math.abs(random.nextInt() % 255);
                int n4 = Math.abs(random.nextInt() % 255);
                int n5 = Math.abs(random.nextInt() % 255);
                if (phatState.getName().equals("NONE") || phatState.getName().indexOf("barrier") != -1 || phatState.getName().indexOf("Barrier") != -1 || phatState.getName().indexOf("wait") != -1 || phatState.getName().indexOf("Wait") != -1 || phatState.getName().indexOf("sync") != -1 || phatState.getName().indexOf("Sync") != -1) {
                    color = Color.red;
                } else if (!phatState.getExtendedInfo().equals("") && n2 != allColors.length) {
                    color = allColors[n2];
                    ++n2;
                } else if (!phatState.getExtendedInfo().equals("")) {
                    color = new Color(n3, n4, n5);
                }
                this.colorMap.put(new Long(phatState.getNumber()), color);
                phatState.setColor(color);
                ++n;
            }
        }
        this.threadDraw.setColorMap(this.colorMap);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.repainting) {
            ThreadViewEvent threadViewEvent = new ThreadViewEvent(this, "Scrollbar changed");
            this.oldHScroll = this.eventHolder.hScroll;
            threadViewEvent.hScroll = this.hScroll.getValue();
            threadViewEvent.x = this.eventHolder.x;
            Dimension dimension = this.getParent().getSize();
            if (dimension.width != this.eventHolder.windowWidth) {
                threadViewEvent.windowWidth = dimension.width;
            }
            this.renderer.computeDrawing(threadViewEvent);
        }
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.vScroll) {
            this.revalidate();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (!(object instanceof PhatState)) {
            return;
        }
        PhatState phatState = (PhatState)object;
        long l = phatState.getNumber();
        if (propertyChangeEvent.getNewValue() instanceof Color) {
            this.colorMap.put(new Long(l), (Color)propertyChangeEvent.getNewValue());
            this.threadDraw.setColorMap(this.colorMap);
            this.threadDraw.repaint();
        }
    }

    public synchronized void redraw(ThreadViewEvent threadViewEvent) {
        ThreadViewEvent threadViewEvent2 = threadViewEvent;
        if (this.eventHolder.zoom != threadViewEvent2.zoom || threadViewEvent2.x != -1) {
            this.zoomHandler.setEventHolder(threadViewEvent2);
        }
        if (this.eventHolder.zoom != threadViewEvent2.zoom) {
            this.zoomHandler.setZoom();
        } else if (this.eventHolder.windowWidth != threadViewEvent2.windowWidth) {
            this.repainting = true;
            this.setSize(threadViewEvent2.windowWidth, this.getHeight());
            this.revalidate();
            this.repainting = false;
        }
        this.eventHolder = threadViewEvent2;
        if (this.threadDraw != null) {
            this.threadDraw.setEventHolder(this.eventHolder);
            this.threadDraw.repaint();
        }
        if (this.vScroll.getMaximum() == 0) {
            this.revalidate();
        }
        this.navigationBar.update(this.eventHolder);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n;
        if (this.repainting) {
            return;
        }
        if (this.oldWidth == 0) {
            this.oldWidth = this.eventHolder.width;
            this.zoomHandler.fitBarsToWindow();
        }
        if (this.oldWidth == (n = this.getSize().width)) {
            return;
        }
        this.oldWidth = n;
        this.oldHScroll = 0;
        this.revalidate();
        ThreadViewEvent threadViewEvent = new ThreadViewEvent(this, "Window resized");
        threadViewEvent.width = this.getWidth() - this.vScroll.getPreferredSize().width - this.verticalRuler.getPreferredSize().width;
        threadViewEvent.hScroll = this.hScroll.getValue();
        threadViewEvent.x = this.eventHolder.x;
        threadViewEvent.windowWidth = this.getParent().getSize().width;
        this.renderer.computeDrawing(threadViewEvent);
    }

    public void setRepainting(boolean bl) {
        this.repainting = bl;
    }

    public void setThreadActive(int n, boolean bl) {
        this.activeArray[n] = bl;
        this.threadDraw.setActiveArray(this.activeArray);
        this.threadDraw.revalidate();
        this.threadDraw.repaint();
    }

    public boolean[] getActiveArray() {
        return this.activeArray;
    }

    public void setBarHeightMode(int n) {
        if (n == 1) {
            this.mouseAdapter.setRubberBanding(1);
            this.zoomHandler.setZooming(1);
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMenuItemName() {
        return "Create a new thread view";
    }

    public NavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public JComponent getRuler() {
        return this.rule;
    }

    public JComponent getVerticalRuler() {
        return this.verticalRuler;
    }

    public ThreadViewEvent getCurrentEvent() {
        return this.eventHolder;
    }

    public float getScaleFactor() {
        return this.eventHolder.zoom;
    }

    public int getBarHeight() {
        return this.zoomHandler.getBarHeight();
    }

    public int getBarSpace() {
        return this.zoomHandler.getBarSpace();
    }

    public JScrollBar getHScroll() {
        return this.hScroll;
    }

    public JScrollBar getVScroll() {
        return this.vScroll;
    }

    public int getStart() {
        return this.eventHolder.hScroll;
    }

    public boolean isThreadActive(int n) {
        return this.activeArray[n];
    }

    public PhatDataSet getDataSet() {
        return this.set;
    }

    public Vector getThreadViews() {
        return this.threads;
    }

    public ZoomHandler getZoomHandler() {
        return this.zoomHandler;
    }

    public PhatStateGroup getStates() {
        return this.stateGroup;
    }

    public PhatThreadGroup getThreads() {
        return this.set.getAllThreads();
    }

    public void setBarHeight(int n) {
        this.zoomHandler.setBarHeight(n);
        this.redraw(this.eventHolder);
    }

    public void setBarSpace(int n) {
        this.zoomHandler.setBarSpace(n);
        this.redraw(this.eventHolder);
    }

    public void setScaleFactor(float f) {
        this.zoomHandler.setZoom(f);
    }

    public ThreadViewRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ThreadViewRenderer threadViewRenderer) {
        this.renderer = threadViewRenderer;
    }

    public void setThreadDraw(ThreadDraw threadDraw) {
        if (this.threadDraw != null) {
            this.remove(this.threadDraw);
        }
        this.threadDraw = threadDraw;
        this.mouseAdapter = new ThreadMouseAdapter(this, this.threadDraw);
        this.threadDraw.addMouseListener(this.mouseAdapter);
        this.threadDraw.addMouseMotionListener(this.mouseAdapter);
        this.threadDraw.setBackground(this.getBackground());
        this.add(this.threadDraw);
    }

    public JComponent getThreadDraw() {
        return this.threadDraw;
    }

    public int getNumThreads() {
        if (this.activeArray == null) {
            return this.numThreads;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.numThreads) {
            if (this.activeArray[n2]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setOldWidth(int n) {
        this.oldWidth = n;
    }

    public void setOldHScroll(int n) {
        this.oldHScroll = n;
    }

    static {
        allColors = new Color[]{Color.blue, Color.green, Color.magenta, Color.orange, Color.pink, Color.cyan, Color.yellow};
        installedViews = new Hashtable();
        numberFormat = new DecimalFormat();
        numberFormat.setMaximumFractionDigits(3);
    }
}

