/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.st.mpmt.timeline.ats;

import com.sun.forte.st.mpmt.timeline.ats.ThreadDraw;
import com.sun.forte.st.mpmt.timeline.ats.ThreadViewEvent;
import com.sun.forte.st.mpmt.timeline.ats.TimeRule;
import com.sun.forte.st.mpmt.timeline.ats.Timeline;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class ZoomHandler {
    private static final int BAR_SPACE = 5;
    private static final int BAR_HEIGHT = 15;
    protected Timeline canvas;
    protected float zoom;
    protected ThreadViewEvent eventHolder;
    private int barSpace;
    private int barHeight;
    private JScrollBar hScroll;
    private JScrollBar vScroll;
    private TimeRule rule;
    private int rubberBandMode;

    public ZoomHandler(Timeline timeline) {
        this.canvas = timeline;
        this.zoom = 1.0f;
        this.barSpace = 5;
        this.barHeight = 15;
        this.hScroll = timeline.getHScroll();
        this.vScroll = timeline.getVScroll();
        this.rule = (TimeRule)timeline.getRuler();
        this.setDimensions(this.barHeight);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setBarHeight(int n) {
        this.barHeight = n;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarSpace(int n) {
        this.barSpace = n;
    }

    public int getBarSpace() {
        return this.barSpace;
    }

    public void zoomInBy2() {
        long l = this.hScroll.getValue();
        if ((l *= 2L) > Integer.MAX_VALUE) {
            return;
        }
        int n = (int)((float)this.hScroll.getValue() * this.eventHolder.zoom * 2.0f / this.eventHolder.zoom);
        n = (int)((float)n + (float)(this.eventHolder.width / 4) * this.eventHolder.zoom * 2.0f / this.eventHolder.zoom);
        float f = this.eventHolder.zoom * 2.0f;
        this.setZoom(f, n);
    }

    public void zoomOutBy2() {
        int n = (int)((float)this.hScroll.getValue() * this.eventHolder.zoom / 2.0f / this.eventHolder.zoom);
        n = (int)((float)n - (float)(this.eventHolder.width / 8) * this.eventHolder.zoom * 2.0f / this.eventHolder.zoom);
        float f = this.eventHolder.zoom / 2.0f;
        if ((double)this.eventHolder.zoom / 2.0 < 1.0) {
            f = 1.0f;
            n = 0;
        }
        this.setZoom(f, n);
    }

    public void setZoom(float f) {
        this.setZoom(f, (int)((float)this.hScroll.getValue() * f / this.eventHolder.zoom), -1, -1);
    }

    public void setZoom(float f, int n) {
        this.setZoom(f, n, -1, -1);
    }

    public void setZoom() {
        this.canvas.setRepainting(true);
        this.canvas.requestFocus();
        this.setDimensions(this.barHeight);
        this.zoom = this.eventHolder.zoom;
        this.hScroll.setMaximum((int)((float)this.eventHolder.width * this.eventHolder.zoom));
        this.hScroll.setValue(this.eventHolder.hScroll);
        this.canvas.setOldWidth(this.eventHolder.width);
        this.canvas.revalidate();
        this.canvas.setRepainting(false);
        this.canvas.setOldHScroll(0);
        this.rule.revalidate();
        this.rule.repaint();
    }

    public void setZoom(float f, int n, int n2, int n3) {
        if (f <= 1.01f) {
            f = 1.0f;
        }
        ThreadViewEvent threadViewEvent = new ThreadViewEvent(this.canvas, "Zoom to " + f);
        threadViewEvent.zoom = this.zoom = f;
        threadViewEvent.hScroll = n;
        threadViewEvent.x = this.eventHolder.x;
        if (n2 != -1) {
            this.setDimensions(n2);
        }
        this.canvas.revalidate();
        this.canvas.getRenderer().computeDrawing(threadViewEvent);
    }

    public void setDimensions(int n) {
        this.barHeight = n;
        if (this.barSpace > this.barHeight) {
            this.barSpace = Math.max(this.barHeight - 1, 1);
        }
        this.canvas.revalidate();
    }

    public void fitBarsToWindow() {
        JComponent jComponent = this.canvas.getThreadDraw();
        if (jComponent == null) {
            return;
        }
        this.barHeight = this.canvas.getScaleFactor() > 1.0f ? (jComponent.getHeight() - this.canvas.getNumThreads() * this.barSpace) / this.canvas.getNumThreads() : (jComponent.getHeight() - this.hScroll.getPreferredSize().height - this.canvas.getNumThreads() * this.barSpace) / this.canvas.getNumThreads();
        if (this.barSpace > this.barHeight) {
            this.barSpace = Math.max(this.barHeight - 1, 1);
            this.barHeight = (jComponent.getHeight() - this.hScroll.getPreferredSize().height - this.canvas.getNumThreads() * this.barSpace) / this.canvas.getNumThreads();
        }
        this.setDimensions(this.barHeight);
    }

    public void setEventHolder(ThreadViewEvent threadViewEvent) {
        this.eventHolder = threadViewEvent;
    }

    public void rubberbandZoom(int n, int n2, int n3, int n4) {
        ThreadDraw threadDraw = (ThreadDraw)this.canvas.getThreadDraw();
        boolean bl = false;
        boolean bl2 = false;
        int n5 = Integer.MAX_VALUE;
        boolean bl3 = false;
        float f = this.canvas.getScaleFactor() / ((float)(n2 - n) / (float)threadDraw.getWidth());
        f = Math.min(16384.0f, f);
        int n6 = this.canvas.getBarHeight() + this.canvas.getBarSpace();
        float f2 = Math.max((float)(n4 - n3) / (float)n6, 1.0f);
        int n7 = (int)((float)(threadDraw.getHeight() - this.canvas.getHScroll().getPreferredSize().height) / f2) - this.canvas.getBarSpace();
        int n8 = (this.canvas.getVScroll().getValue() + n3) * (n7 + this.canvas.getBarSpace()) / n6;
        if (this.rubberBandMode == 2) {
            this.setZoom(f, (int)((float)(this.canvas.getHScroll().getValue() + n) * f / this.canvas.getScaleFactor()), n7, n8);
        } else {
            this.setZoom(f, (int)((float)(this.canvas.getHScroll().getValue() + n) * f / this.canvas.getScaleFactor()), this.canvas.getBarHeight(), this.canvas.getVScroll().getValue());
        }
    }

    public void setZooming(int n) {
        this.rubberBandMode = n;
    }
}

