/*
 * Copyright 08/03/01 Sun Microsystems, Inc. All Rights Reserved
 *
 */

#ifndef _LIBCOLLECTOR_H
#define	_LIBCOLLECTOR_H

#pragma ident "@(#)libcollector.h 1.6 01/08/03"

/*
 * This file contains function prototypes for the user-callable API
 * routines in libcollector.
 */

#ifdef	__cplusplus
extern "C" {
#endif

/* routine to record a sample in the experiment */
void	collector_sample(char *name);
#pragma weak collector_sample
#define collector_sample(x) \
	( collector_sample ? collector_sample(x),0 : 0 )

/* routine to suspend data collection during an experiment */
void	collector_pause(void);
#pragma weak collector_pause
#define collector_pause() \
	( collector_pause ? collector_pause(),0 : 0 )

/* routine to resume data collection during an experiment */
void	collector_resume(void);
#pragma weak collector_resume
#define collector_resume() \
	( collector_resume ? collector_resume(),0 : 0 )

/* routine to close the experiment, and stop all data collection */
void	collector_terminate_expt(void);
#pragma weak collector_terminate_expt
#define collector_terminate_expt() \
	( collector_terminate_expt ? collector_terminate_expt(),0 : 0 )

typedef struct {
	unsigned int	offset;
	unsigned int	lineno;
} Lineno;

/* routines to let libcollector know about a dynamically loaded function */
void	collector_func_load(char *name, char *alias, char  *sourcename,
		void *vaddr, int size, int lntsize, Lineno *lntable);
#pragma weak collector_func_load
#define collector_func_load(x0,x1,x2,x3,x4,x5,x6) \
	( collector_func_load ? collector_func_load(x0,x1,x2,x3,x4,x5,x6),0 : 0 )

void	collector_func_unload(void *vaddr);
#pragma weak collector_func_unload
#define collector_func_unload(x) \
	( collector_func_unload ? collector_func_unload(x),0 : 0 )

#ifdef	__cplusplus
}
#endif

#endif	/* _LIBCOLLECTOR_H */
