/*
	Copyright 01/27/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _STRING__ISO_SUNWCC_H
#define _STRING__ISO_SUNWCC_H

#pragma ident "@(#)string_iso_SUNWCC.h	1.3  03/04/03 C++5.0"   /* SVr4.0 2.34.1.2 */

#ifndef	NULL
  #if defined(_LP64)
    #define	NULL	0L
  #else
    #define	NULL	0
  #endif
#endif

namespace std {

#if defined(_LP64) || defined(_I32LPx)
    typedef unsigned long size_t;
#else
    typedef unsigned int  size_t;
#endif

extern "C" {
  void *memcpy(void *, const void *, size_t);
  void *memmove(void *, const void *, size_t);
  char *strcpy(char *, const char *);
  char *strncpy(char *, const char *, size_t);
  char *strcat(char *, const char *);
  char *strncat(char *, const char *, size_t);
  int memcmp(const void *, const void *, size_t);
  int strcmp(const char *, const char *);
  int strcoll(const char *, const char *);
  int strncmp(const char *, const char *, size_t);
  size_t strxfrm(char *, const char *, size_t);
  size_t strcspn(const char *, const char *);
  size_t strspn(const char *, const char *);
  char *strtok(char *, const char *);
  void *memset(void *, int, size_t);
  char *strerror(int);
  size_t strlen(const char *);
  const char* strchr( const char*, int );
  const char* strpbrk(const char *, const char *);
  const char* strrchr( const char*, int );
  const char* strstr( const char*, const char *);
  const void* memchr(const void *, int, size_t);
} /* end of extern "C" */

/* const version of C functions */
extern "C++" {
  inline char* strchr( char* _c, int _i ) {
    return (char*)strchr( (const char*)_c, _i );
  }
  inline char* strpbrk( char* _c, const char* _d ) {
    return (char*)strpbrk( (const char*)_c, _d );
  }
  inline char* strrchr( char* _c, int _i ) {
    return (char*)strrchr( (const char*)_c, _i );
  }
  inline char* strstr( char* _c, const char* _d ) {
    return (char*)strstr( (const char*)_c, _d );
  }

  // must cooperate with <memory.h> on declarations of memchr
  #ifndef _MEMCHR_INLINE
  #define _MEMCHR_INLINE
  inline void* memchr( void* _c, int _i, size_t _d ) {
    return (void*)memchr( (const void*)_c, _i, _d );
  }
  #endif
} /* end of extern "C++" */

} /* end of namespace std */

#endif /* _STRING__ISO_SUNWCC_H */
