/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HeartBeatServerHandler {
    private static String localClassName = "HeartBeatServerHandler";
    private MBeanServer mbs;
    private static String mbsId;
    private ServerNotificationDispatcher snd;
    private static long counter;
    private static String uniqueId;
    private Hashtable clients = new Hashtable();

    static {
        counter = 0L;
    }

    public HeartBeatServerHandler(MBeanServer mBeanServer, ServerNotificationDispatcher serverNotificationDispatcher) {
        if (this.isTraceOn()) {
            this.trace("Constructor", "Create HeartBeatServerHandler.");
        }
        this.mbs = mBeanServer;
        this.snd = serverNotificationDispatcher;
        try {
            mbsId = (String)mBeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception exception) {
            mbsId = "unknown";
        }
    }

    public void cleanup(String string) {
        HBClientInfo hBClientInfo;
        Serializable serializable = this.clients;
        synchronized (serializable) {
            hBClientInfo = (HBClientInfo)this.clients.remove(string);
        }
        if (hBClientInfo != null && (serializable = hBClientInfo.getNotifSessionId()) != null) {
            this.snd.remoteTerminate((Long)serializable);
        }
    }

    public void cleanupClientResources() {
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                HBClientInfo hBClientInfo = (HBClientInfo)enumeration.nextElement();
                hBClientInfo.stopWaitPing(-1);
            }
        }
    }

    private void debug(String string, Exception exception) {
        Trace.send(2, 8192, localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 8192, localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, 8192, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 8192, string, string2, string3);
    }

    private static String getSessionId() {
        if (counter == Long.MAX_VALUE) {
            counter = 0L;
        }
        String string = String.valueOf(counter) + "_" + mbsId;
        ++counter;
        return string;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 8192);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 8192);
    }

    public String pingHeartBeatServer(String string, int n, int n2, Long l) {
        HBClientInfo hBClientInfo;
        if (string == null) {
            string = HeartBeatServerHandler.getSessionId();
        } else if (!string.endsWith(mbsId)) {
            return null;
        }
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            hBClientInfo = (HBClientInfo)this.clients.get(string);
        }
        if (hBClientInfo == null) {
            if (n <= 0) {
                return string;
            }
            hBClientInfo = new HBClientInfo(string, n, n2, l);
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.put(string, hBClientInfo);
            }
            hBClientInfo.startWaitPing();
            return string;
        }
        if (n <= 0) {
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.remove(string);
            }
            hBClientInfo.stopWaitPing(-1);
            return string;
        }
        hBClientInfo.setPeriod(n);
        hBClientInfo.setNRetries(n2);
        hBClientInfo.setNotifSessionId(l);
        hBClientInfo.startWaitPing();
        return string;
    }

    private void trace(String string, Exception exception) {
        Trace.send(1, 8192, localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 8192, localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, 8192, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 8192, string, string2, string3);
    }

    private class HBClientInfo {
        private String hbSessionId;
        private int period;
        private int nretries;
        private Long notifSessionId;
        private long timeout;
        private long newThreadEndTime;
        private WaitPing threadWaitPing;

        public HBClientInfo(String string, int n, int n2, Long l) {
            this.hbSessionId = string;
            this.period = n;
            this.nretries = n2;
            this.notifSessionId = l;
        }

        public void cleanupHBClientInfo() {
            HeartBeatServerHandler.this.cleanup(this.hbSessionId);
        }

        public int getNRetries() {
            return this.nretries;
        }

        public Long getNotifSessionId() {
            return this.notifSessionId;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setNRetries(int n) {
            this.nretries = n;
        }

        public void setNotifSessionId(Long l) {
            this.notifSessionId = l;
        }

        public void setPeriod(int n) {
            this.period = n;
        }

        public synchronized void startWaitPing() {
            this.timeout = this.nretries == 0 ? (long)((double)this.period + 1.2 * (double)this.period) : (long)((double)this.period + 1.2 * (double)(this.period * this.nretries));
            this.newThreadEndTime = System.currentTimeMillis() + this.timeout;
            if (this.threadWaitPing == null || !this.threadWaitPing.isAlive()) {
                this.threadWaitPing = new WaitPing();
                this.threadWaitPing.start();
            }
        }

        public synchronized void stopWaitPing(int n) {
            if (this.threadWaitPing != null) {
                this.threadWaitPing.terminate(n);
                this.threadWaitPing = null;
            }
        }

        private class WaitPing
        extends Thread {
            private long actualThreadEndTime = 0L;
            private boolean toBeTerminated = false;
            private final int[] lock = new int[0];

            WaitPing() {
            }

            public void run() {
                while (!this.toBeTerminated && HBClientInfo.this.timeout > 0L) {
                    try {
                        int[] nArray = this.lock;
                        synchronized (nArray) {
                            this.lock.wait(HBClientInfo.this.timeout);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.toBeTerminated) break;
                    }
                    this.actualThreadEndTime = System.currentTimeMillis();
                    if (this.actualThreadEndTime <= HBClientInfo.this.newThreadEndTime || this.toBeTerminated) continue;
                    this.toBeTerminated = true;
                    if (HeartBeatServerHandler.this.isTraceOn()) {
                        HeartBeatServerHandler.this.trace("WaitPing", "run", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " died.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                }
            }

            public void terminate(int n) {
                this.toBeTerminated = true;
                if (n == -1) {
                    if (HeartBeatServerHandler.this.isTraceOn()) {
                        HeartBeatServerHandler.this.trace("WaitPing", "terminate", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " disconnected.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                    int[] nArray = this.lock;
                    synchronized (nArray) {
                        this.lock.notify();
                    }
                } else if (HeartBeatServerHandler.this.isTraceOn()) {
                    HeartBeatServerHandler.this.trace("WaitPing", "terminate", "Ping stopped for client with SessionId = " + HBClientInfo.this.hbSessionId);
                }
            }
        }
    }
}

