/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpMibTable;
import com.sun.jdmk.snmp.agent.SnmpTableCallbackHandler;
import com.sun.jdmk.snmp.agent.SnmpTableEntryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;

public abstract class SnmpTableSupport
implements SnmpTableEntryFactory,
SnmpTableCallbackHandler,
Serializable {
    protected List entries;
    protected SnmpMibTable meta;
    protected SnmpMib theMib;
    private boolean registrationRequired = false;

    protected SnmpTableSupport(SnmpMib snmpMib) {
        this.theMib = snmpMib;
        this.meta = this.getRegisteredTableMeta(snmpMib);
        this.bindWithTableMeta();
        this.entries = this.allocateTable();
    }

    protected void addEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        ObjectName objectName = null;
        if (this.isRegistrationRequired()) {
            objectName = this.buildNameFromIndex(snmpIndex);
        }
        this.meta.addEntry(snmpOid, objectName, object);
    }

    protected void addEntry(SnmpIndex snmpIndex, ObjectName objectName, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        this.meta.addEntry(snmpOid, objectName, object);
    }

    public void addEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.add(n, object);
            }
        }
        catch (Exception exception) {
            throw new SnmpStatusException(2);
        }
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.meta.addNotificationListener(notificationListener, notificationFilter, object);
    }

    protected List allocateTable() {
        return new ArrayList();
    }

    protected void bindWithTableMeta() {
        if (this.meta == null) {
            return;
        }
        this.registrationRequired = this.meta.isRegistrationRequired();
        this.meta.registerEntryFactory(this);
    }

    public abstract ObjectName buildNameFromIndex(SnmpIndex var1) throws SnmpStatusException;

    public abstract SnmpOid buildOidFromIndex(SnmpIndex var1) throws SnmpStatusException;

    public SnmpIndex buildSnmpIndex(SnmpOid snmpOid) throws SnmpStatusException {
        return this.buildSnmpIndex(snmpOid.longValue(false), 0);
    }

    protected abstract SnmpIndex buildSnmpIndex(long[] var1, int var2) throws SnmpStatusException;

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3, SnmpMibTable var4) throws SnmpStatusException;

    protected Object[] getBasicEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] objectArray = new Object[this.entries.size()];
        this.entries.toArray(objectArray);
        return objectArray;
    }

    public Object getEntry(int n) {
        if (this.entries == null) {
            return null;
        }
        return this.entries.get(n);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.meta.getNotificationInfo();
    }

    protected abstract SnmpMibTable getRegisteredTableMeta(SnmpMib var1);

    public int getSize() {
        return this.meta.getSize();
    }

    public boolean isCreationEnabled() {
        return this.meta.isCreationEnabled();
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    protected void removeEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        this.meta.removeEntry(snmpOid, object);
    }

    public void removeEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.remove(n);
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.meta.removeNotificationListener(notificationListener);
    }

    public void setCreationEnabled(boolean bl) {
        this.meta.setCreationEnabled(bl);
    }
}

