/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.NotificationBackConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;

abstract class GenericHttpNotificationForwarder
extends GenericHttpConnectorClient
implements NotificationBackConnector {
    private transient boolean connected = false;

    public GenericHttpNotificationForwarder(GenericHttpConnectorAddress genericHttpConnectorAddress) {
        this.httpConnAddr = genericHttpConnectorAddress;
        this.factory = this.getSocketFactory();
    }

    public String connect() {
        if (this.isTraceOn()) {
            this.trace("connect", "connect");
        }
        this.connected = true;
        return null;
    }

    private void debug(String string, String string2) {
        Trace.send(2, 3856, "GenericHttpNotificationForwarder", string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 3856, string, string2, string3);
    }

    public void disconnect() {
        if (this.isTraceOn()) {
            this.trace("disconnect", "disconnect");
        }
        if (this.connected) {
            this.httpConnAddr = null;
            this.connected = false;
        }
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 3856);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 3856);
    }

    private Object readObjectValue(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        String string = (String)objectInputStream.readObject();
        if (this.isDebugOn()) {
            this.debug("readObjectValue", "Received object of type " + string);
        }
        return objectInputStream.readObject();
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("remoteRequest", "remoteRequest");
        }
        if (!this.connected) {
            throw new CommunicationException("NotificationForwarder not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("remoteRequest");
        arrayList.add(new Integer(n));
        arrayList.add(objectArray);
        try {
            byte[] byArray = this.sendHttp(arrayList);
            if (byArray.length == 0) {
                throw new IllegalAccessException("Entity Body in HTTP Response is empty");
            }
            Object object = this.readObjectValue(byArray);
            if (object instanceof Exception) {
                throw (Exception)object;
            }
            return (Object[])object;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("remoteRequest", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("remoteRequest", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private byte[] sendHttp(ArrayList arrayList) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        block14: {
            InputStream inputStream;
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            Socket socket = null;
            byteArrayOutputStream = null;
            try {
                int n;
                socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                object2 = socket.getOutputStream();
                if (byArray.length != 0) {
                    ((OutputStream)object2).write(byArray);
                }
                ((OutputStream)object2).flush();
                inputStream = socket.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write((byte)n);
                }
                Object var9_15 = null;
                if (socket == null) break block14;
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                if (socket != null) {
                    try {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                        }
                        Object var11_12 = null;
                        socket = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_13 = null;
                        socket = null;
                        throw throwable2;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                }
                inputStream = null;
                socket = null;
            }
            catch (Throwable object2) {
                inputStream = null;
                socket = null;
                throw object2;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void trace(String string, String string2) {
        Trace.send(1, 3856, "GenericHttpNotificationForwarder", string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 3856, string, string2, string3);
    }
}

