/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpQManager;
import java.net.DatagramPacket;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;

class SnmpResponseHandler {
    SnmpAdaptorServer adaptor = null;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpQManager snmpQManager) {
        this.adaptor = snmpAdaptorServer;
        this.snmpq = snmpQManager;
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 1024, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 1024, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 1024);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 1024);
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block15: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (this.isTraceOn()) {
                this.trace("processDatagram", "Received from " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.decodeMessage(byArray, n);
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                SnmpPduFactory snmpPduFactory = this.adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                } else {
                    SnmpPduPacket snmpPduPacket = snmpPduFactory.decodePdu(snmpMessage);
                    if (snmpPduPacket == null) {
                        if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpPduPacket instanceof SnmpPduRequest) {
                        SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                        SnmpInformRequest snmpInformRequest = this.snmpq.removeRequest(snmpPduRequest.requestId);
                        if (snmpInformRequest != null) {
                            snmpInformRequest.invokeOnResponse(snmpPduRequest);
                        } else if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Unable to find corresponding for InformRequestId = " + snmpPduRequest.requestId);
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. The packet does not contain an inform response");
                    }
                    snmpPduPacket = null;
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block15;
                this.debug("processDatagram", "Exception while processsing");
                this.debug("processDatagram", exception);
            }
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 1024, string, string2, string3);
    }
}

