/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.discovery.ActualDiscovery;
import com.sun.jdmk.discovery.DiscoveryClientMBean;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiscoveryClient
implements Serializable,
DiscoveryClientMBean,
MBeanRegistration {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    private int infoType = 4096;
    private String localClassName = "com.sun.jdmk.discovery.DiscoveryClient";
    private static final String sccs_id = "@(#)DiscoveryClient.java 4.30 01/09/11 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private int ttl = 1;
    private boolean pointToPointResponse = true;
    private int timeOut = 1000;
    private static int defaultTimeOut = 1000;
    private transient ActualDiscovery discovery = null;
    private static final String GROUP = "group";
    private static final String PORT = "port";
    protected volatile transient int state = 1;
    InetAddress usrInet = null;

    public DiscoveryClient() {
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
    }

    public DiscoveryClient(String string, int n) {
        this.multicastGroup = string;
        this.multicastPort = n;
    }

    public DiscoveryClient(String string, int n, InetAddress inetAddress) {
        this.multicastGroup = string;
        this.multicastPort = n;
        this.usrInet = inetAddress;
        if (this.isTraceOn()) {
            this.trace("constructor ", "set interface to " + inetAddress);
        }
    }

    private void debug(String string, Exception exception) {
        this.debug(this.localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, this.infoType, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    public Vector findCommunicators() throws CommunicationException {
        return this.findCommunicators(true, null);
    }

    public Vector findCommunicators(String string) throws CommunicationException {
        return this.findCommunicators(true, string);
    }

    private Vector findCommunicators(boolean bl, String string) throws CommunicationException {
        if (this.state != 0) {
            throw new CommunicationException("Not connected to " + this.multicastGroup + ":" + this.multicastPort);
        }
        try {
            return this.discovery.findCommunicators(bl, string);
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("findCommunicators ", "Get IOException exception " + iOException.getMessage());
            }
            throw new CommunicationException("Unable to join group on " + this.multicastGroup + ":" + this.multicastPort);
        }
    }

    public Vector findMBeanServers() throws CommunicationException {
        return this.findCommunicators(false, null);
    }

    public Vector findMBeanServers(String string) throws CommunicationException {
        return this.findCommunicators(false, string);
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public boolean getPointToPointResponse() {
        return this.pointToPointResponse;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
        }
        return string;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean isActive() {
        return this.state == 0;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    public void postDeregister() {
        System.runFinalization();
    }

    public void postRegister(Boolean bl) {
        if (bl == Boolean.FALSE) {
            return;
        }
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister ", "stopping ");
        }
        if (this.state == 0) {
            this.stop();
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister ", "object name   = " + objectName);
        }
        return objectName;
    }

    public void setMulticastGroup(String string) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = string;
    }

    public void setMulticastPort(int n) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = n;
    }

    public void setPointToPointResponse(boolean bl) {
        this.pointToPointResponse = bl;
        if (this.state == 0) {
            this.discovery.setPointToPointResponse(bl);
        }
    }

    public void setTimeOut(int n) throws IOException {
        this.timeOut = n <= 0 ? defaultTimeOut : n;
        if (this.state == 0) {
            this.discovery.setTimeOut(n);
        }
    }

    public void setTimeToLive(int n) throws IOException, IllegalArgumentException {
        if (n <= 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.ttl = n;
        if (this.state == 0) {
            this.discovery.setTimeToLive(n);
        }
    }

    public void start() throws IOException {
        if (this.state == 1) {
            try {
                if (this.isTraceOn()) {
                    this.trace("start ", "Create a new multicast socket");
                    this.trace("start ", "Set group to '" + this.multicastGroup + "'");
                    this.trace("start ", "Set port  to '" + this.multicastPort + "'");
                }
                this.discovery = new ActualDiscovery(this.multicastGroup, this.multicastPort);
                if (this.usrInet != null) {
                    this.discovery.setInterface(this.usrInet);
                    if (this.isTraceOn()) {
                        this.trace("start ", "Set to the interface " + this.usrInet);
                    }
                }
            }
            catch (SocketException socketException) {
                if (this.isTraceOn()) {
                    this.trace("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    this.trace("start", socketException);
                }
                throw new IOException(socketException.getMessage());
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace("start ", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    this.trace("start", iOException);
                }
                throw iOException;
            }
            try {
                this.discovery.connectToGroup();
                this.discovery.setTimeOut(this.timeOut);
                this.discovery.setTimeToLive(this.ttl);
                this.discovery.setPointToPointResponse(this.pointToPointResponse);
            }
            catch (SocketException socketException) {
                if (this.isTraceOn()) {
                    this.trace("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    this.trace("start", socketException);
                }
                throw new IOException(socketException.getMessage());
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    this.trace("start", iOException);
                }
                throw iOException;
            }
            this.state = 0;
        } else if (this.isTraceOn()) {
            this.trace("start ", "Client is not OFFLINE");
        }
    }

    public void stop() {
        if (this.state == 0) {
            block6: {
                if (this.isTraceOn()) {
                    this.trace("stop", "Call leave group");
                }
                try {
                    this.discovery.disconnectFromGroup();
                    this.discovery = null;
                }
                catch (IOException iOException) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("stop ", iOException);
                }
            }
            System.runFinalization();
            this.state = 1;
        } else if (this.isTraceOn()) {
            this.trace("stop", "Client is not ONLINE");
        }
    }

    private void trace(String string, Exception exception) {
        this.trace(this.localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, this.infoType, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }
}

