/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.Trace;
import com.sun.jdmk.discovery.ActualMonitor;
import com.sun.jdmk.discovery.DiscoveryMonitorMBean;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Date;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class DiscoveryMonitor
extends NotificationBroadcasterSupport
implements Serializable,
DiscoveryMonitorMBean,
MBeanRegistration {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    private int infoType = 4096;
    private String localClassName;
    private String dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
    private ObjectName monitorObjectName = null;
    private MBeanServer cmf = null;
    private static final String sccs_id = "@(#)DiscoveryMonitor.java 4.21 01/09/11 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private transient ActualMonitor monitor = null;
    private transient Thread monitorThread = null;
    private volatile transient int state = 1;
    private transient Vector listeners = new Vector();
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private InetAddress usrInet = null;

    public DiscoveryMonitor() {
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + this.multicastGroup + "'");
            this.trace("constructor ", "Set port  to '" + this.multicastPort + "'");
        }
    }

    public DiscoveryMonitor(String string, int n) {
        this.multicastGroup = string;
        this.multicastPort = n;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + string + "'");
            this.trace("constructor ", "Set port  to '" + n + "'");
        }
    }

    public DiscoveryMonitor(String string, int n, InetAddress inetAddress) {
        this.multicastGroup = string;
        this.multicastPort = n;
        this.usrInet = inetAddress;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + string + "'");
            this.trace("constructor ", "Set port  to '" + n + "'");
            this.trace("constructor ", "Set interface  to '" + inetAddress + "'");
        }
    }

    synchronized void changeState(int n) {
        if (this.state == n) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.notifyAll();
    }

    private void debug(String string, Exception exception) {
        this.debug(this.localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, this.infoType, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
            case 3: {
                string = "STARTING";
                break;
            }
        }
        return string;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    public void postDeregister() {
        System.runFinalization();
    }

    public void postRegister(Boolean bl) {
        if (bl == Boolean.FALSE) {
            return;
        }
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        String string;
        String string2;
        if (this.isTraceOn()) {
            this.trace("preRegister ", "object name   = " + objectName);
        }
        if ((string2 = objectName.getKeyProperty(GROUP)) != null) {
            this.multicastGroup = string2;
        }
        if (this.isTraceOn()) {
            this.trace("preRegister ", "Set group to '" + this.multicastGroup + "'");
        }
        if ((string = objectName.getKeyProperty(PORT)) != null) {
            this.multicastPort = Integer.parseInt(string);
        }
        if (this.isTraceOn()) {
            this.trace("preRegister ", "Set Port  to '" + this.multicastPort + "'");
        }
        this.monitorObjectName = objectName;
        return objectName;
    }

    public void setMulticastGroup(String string) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = string;
    }

    public void setMulticastPort(int n) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = n;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            try {
                this.changeState(3);
                this.monitor = new ActualMonitor(this.multicastGroup, this.multicastPort, this);
                if (this.usrInet != null) {
                    this.monitor.setInterface(this.usrInet);
                    if (this.isTraceOn()) {
                        this.trace("start", "set to the interface " + this.usrInet);
                    }
                }
                this.monitorThread = this.cmf == null ? new Thread(this.monitor) : new Thread(this.monitor);
                this.monitorThread.setName("Multicast monitor");
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("start", iOException);
                }
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                if (this.isDebugOn()) {
                    this.debug("start ", nullPointerException);
                }
                throw new IOException(((Throwable)nullPointerException).getMessage());
            }
            this.monitorThread.start();
        } else if (this.isTraceOn()) {
            this.trace("start ", "not OFFLINE ");
        }
    }

    public void stop() {
        if (this.state == 0) {
            block11: {
                this.changeState(2);
                this.monitor.stopMonitor();
                Object object = this.monitor.interrupted;
                synchronized (object) {
                    if (!this.monitor.interrupted.booleanValue()) {
                        this.monitorThread.interrupt();
                    }
                }
                try {
                    object = new MulticastSocket(this.multicastPort);
                    if (this.usrInet != null) {
                        ((MulticastSocket)object).setInterface(this.usrInet);
                        if (this.isTraceOn()) {
                            this.trace("stop ", "use the interface " + this.usrInet);
                        }
                    }
                    InetAddress inetAddress = InetAddress.getByName(this.multicastGroup);
                    ((MulticastSocket)object).joinGroup(inetAddress);
                    ((DatagramSocket)object).send(new DatagramPacket(new byte[1], 1, inetAddress, this.multicastPort));
                    ((MulticastSocket)object).leaveGroup(inetAddress);
                }
                catch (Exception exception) {
                    if (!this.isTraceOn()) break block11;
                    this.trace("stop ", "Unexpected exception occured trying to send empty message " + exception.getMessage());
                }
            }
            this.monitor = null;
        } else if (this.isTraceOn()) {
            this.trace("stop ", "not ONLINE");
        }
    }

    private void trace(String string, Exception exception) {
        this.trace(this.localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, this.infoType, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    public boolean waitState(int n, long l) {
        if (this.isTraceOn()) {
            this.trace("waitState", String.valueOf(n) + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        if (l < 0L) {
            return this.state == n;
        }
        boolean bl = this.state == n;
        long l2 = -1L;
        Date date = new Date(new Date().getTime() + l);
        while (!bl) {
            if (l != 0L && (l2 = date.getTime() - new Date().getTime()) <= 0L) {
                bl = true;
                break;
            }
            try {
                DiscoveryMonitor discoveryMonitor = this;
                synchronized (discoveryMonitor) {
                    if (l == 0L) {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        bl = this.state == n;
                        while (!bl) {
                            bl = this.state == n;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting " + l2 + " current state = " + this.state);
                        }
                        this.wait(l2);
                    }
                }
                bl = this.state == n;
            }
            catch (InterruptedException interruptedException) {
                boolean bl2 = bl = this.state == n;
            }
        }
        if (this.isTraceOn()) {
            this.trace("waitState", "End, TO=" + l2);
        }
        return this.state == n;
    }
}

