/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.admin.platformAdmin;

import com.sun.symon.apps.admin.CaActionContext;
import com.sun.symon.apps.admin.CaActionInfo;
import com.sun.symon.apps.admin.CaAdmin;
import com.sun.symon.apps.admin.CaErrorDialog;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CaPlatformACL
extends JDialog
implements ListSelectionListener,
ActionListener {
    private JPanel southPanel;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JLabel statusLabel;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JLabel addLabel;
    private JLabel blankLabel;
    private JLabel slotLabel;
    private JList addList;
    private JPanel centerPanel;
    private JList slotList;
    private JScrollBar bar1;
    private JButton addButton;
    private JButton removeButton;
    private Vector aclList;
    private Vector availableList;
    private CaActionContext context;

    public CaPlatformACL(Frame frame, boolean bl, CaActionContext caActionContext) {
        super(frame, bl);
        this.context = caActionContext;
        this.initComponents();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JButton)actionEvent.getSource()).getActionCommand();
        if ("add".equals(string)) {
            int[] nArray = this.addList.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                this.aclList.addElement(this.availableList.elementAt(nArray[n]));
                this.availableList.removeElementAt(nArray[n]);
                ++n;
            }
        } else if ("remove".equals(string)) {
            int[] nArray = this.slotList.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                this.availableList.addElement(this.aclList.elementAt(nArray[n]));
                this.aclList.removeElementAt(nArray[n]);
                ++n;
            }
        }
        this.addList.setListData(this.availableList);
        this.slotList.setListData(this.aclList);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void initComponents() {
        this.setTitle(CaAdmin.getI18nString((String)"aclTitle"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CaPlatformACL.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.southPanel = new JPanel();
        this.southPanel.setBorder(new EmptyBorder(new Insets(10, 1, 10, 1)));
        this.southPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton = new JButton();
        this.okButton.setText(CaAdmin.getI18nString((String)"okLabel"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CaPlatformACL.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText(CaAdmin.getI18nString((String)"cancelLabel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CaPlatformACL.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.helpButton = new JButton();
        this.helpButton.setText(CaAdmin.getI18nString((String)"helpLabel"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CaPlatformACL.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add((Component)this.buttonPanel, "Center");
        this.statusLabel = new JLabel();
        this.southPanel.add((Component)this.statusLabel, "South");
        this.jSeparator1 = new JSeparator();
        this.southPanel.add((Component)this.jSeparator1, "North");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        this.mainPanel.setLayout(new GridBagLayout());
        this.addLabel = new JLabel();
        this.addLabel.setText(CaAdmin.getI18nString((String)"addToACL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.addLabel, gridBagConstraints);
        this.blankLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.blankLabel, gridBagConstraints);
        this.slotLabel = new JLabel();
        this.slotLabel.setText(CaAdmin.getI18nString((String)"slotsInACL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.slotLabel, gridBagConstraints);
        this.addList = new JList();
        this.addList.setSelectionMode(0);
        this.addList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.addList);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)jScrollPane, gridBagConstraints);
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(new EmptyBorder(new Insets(20, 20, 20, 20)));
        this.centerPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        this.addButton.setText(CaAdmin.getI18nString((String)"add"));
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("add");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 15;
        this.centerPanel.add((Component)this.addButton, gridBagConstraints2);
        this.removeButton = new JButton();
        this.removeButton.setText(CaAdmin.getI18nString((String)"remove"));
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        this.centerPanel.add((Component)this.removeButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.centerPanel, gridBagConstraints);
        this.slotList = new JList();
        this.slotList.setSelectionMode(0);
        this.slotList.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.slotList);
        jScrollPane2.setPreferredSize(new Dimension(100, 100));
        jScrollPane2.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)jScrollPane2, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.updateButtons();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        CaActionInfo[] caActionInfoArray = this.context.getActionInfo();
        this.cancelButton.setEnabled(false);
        this.setStatus(CaAdmin.getI18nString((String)"saveProgress"));
        try {
            String[] stringArray = new String[]{caActionInfoArray[0].getActionUrl()};
            StObject[][] stObjectArray = new StObject[1][1];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.aclList.size()) {
                stringBuffer = stringBuffer.append(" " + this.aclList.elementAt(n).toString());
                ++n;
            }
            stObjectArray[0][0] = new StString("setDomainACL,rep:" + stringBuffer.toString());
            stObjectArray = this.context.getRequestHandle().setURLValue(stringArray, stObjectArray);
            this.doClose();
        }
        catch (SMAPIException sMAPIException) {
            if (sMAPIException.getReasonCode() == 1) {
                this.setStatus(CaAdmin.getI18nString((String)"securityException"));
                this.cancelButton.setEnabled(true);
            } else {
                new CaErrorDialog(new Frame(), true, null, sMAPIException.getMessage()).show();
            }
        }
        catch (Exception exception) {
            new CaErrorDialog(new Frame(), true, null, exception.getMessage()).show();
        }
    }

    public final void scStatus(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("Operation Failed : System Controller is down.");
        vector2.addElement("Operation Failed : System Controller Agent is not responding.");
        vector2.addElement("Operation Failed : Agent Not Responding");
        int n = 0;
        while (n < vector2.size()) {
            if (vector.contains(vector2.elementAt(n))) {
                this.setStatus(CaAdmin.getI18nString((String)"scAgentNotResponding"));
                this.okButton.setEnabled(false);
            }
            ++n;
        }
    }

    public final void setSlotsInACL(Vector vector) {
        this.aclList = vector;
        this.slotList.setListData(vector);
    }

    public final void setSlotsNotInACL(Vector vector) {
        this.availableList = vector;
        this.addList.setListData(vector);
    }

    public void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    private void updateButtons() {
        if (this.addList.isSelectionEmpty()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (this.slotList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.addList && !this.slotList.isSelectionEmpty()) {
            this.slotList.clearSelection();
        } else if (listSelectionEvent.getSource() == this.slotList && !this.addList.isSelectionEmpty()) {
            this.addList.clearSelection();
        }
        this.updateButtons();
    }
}

