# Copyright 09/13/02 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)serengeti-platadmin-models-d.x	1.35 02/09/13 Sun Microsystems"

type = reference

#
#This node is used to inform console about the change in 
#community strings. This is done from one of the trap
#handlers.
#

communityChanged = { [ use STRING MANAGED-PROPERTY ]
    mediumDesc        = communityCahnged
    consoleHint:hidden = true
}

#
#This node maintains the list of tables which needs to be 
#refreshed before refreshing the node sunSmTreePropRefreshNode.
#

tableListTorefresh = { [ use STRING MANAGED-PROPERTY ]
    mediumDesc        = tableListTorefresh
    consoleHint:hidden = true
}

#
#This node builds the sunSmTreeProp for all the related
#tables. This node is refreshed after the list of table in
#tableListTorefresh node goes empty. It builds all the sunSmTreeProp
#and then build the tree file also.
#

sunSmTreePropRefreshNode = { [ use STRING MANAGED-PROPERTY ]
    mediumDesc        = sunSmTreePropRefreshNode
    consoleHint:hidden = true
}

#
#The root node for PV/LV.
#

system = { [ use MANAGED-OBJECT ]
    mediumDesc = Chassis for PV/LV
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:system

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
        mediumDesc        = sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
        mediumDesc        = sunSmNodeName
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
	consoleHint:hidden = true
    }
    machine = { [ use STRING MANAGED-PROPERTY ]
        mediumDesc        = machine
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.machine
	consoleHint:hidden = true
    }
    platform = { [ use STRING MANAGED-PROPERTY ]
        mediumDesc        = platform
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.platform
    }
    total_config_changes = { [ use INT MANAGED-PROPERTY ]
	consoleHint:hidden = true
        mediumDesc        = total_config_changes
    }
}

#
#This node maintains whether the SC is networked or not.
#

scnetworked = { [ use INT MANAGED-PROPERTY ]
    mediumDesc        = scnetworked
    consoleHint:hidden = true
}

#
#This node will maintain the state of the SC. The sate may
#be following...
#-- SC is down, value = 0
#-- SC is up but SC SNMP Agent is down, value = 1
#-- SC is up and SC SNMP Agent is up too. value = 2
#

scagentstatus = { [ use INT MANAGED-PROPERTY ]
    mediumDesc        = scagentstatus
    consoleHint:hidden = true
}

#
#The IP Address of the SC. This will always contain
#the IP address in dot notation.
#

remoteIPAddress = { [ use STRING MANAGED-PROPERTY ]
    mediumDesc        = remoteIPAddress
    consoleHint:hidden = true
}

#
#This node maintains the read and write community for all 5
#different views.
#

communitystrings = { [ use MANAGED-OBJECT ]
	mediumDesc        = communitystrings
	consoleHint:hidden = true
    platformreadcommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = platformreadcommunity
	consoleHint:hidden = true
    }
    platformwritecommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = platformwritecommunity
	consoleHint:hidden = true
    }
    domainAwritecommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = domainAwritecommunity
	consoleHint:hidden = true
    }
    domainBwritecommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = domainBwritecommunity
	consoleHint:hidden = true
    }
    domainCwritecommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = domainCwritecommunity
	consoleHint:hidden = true
    }
    domainDwritecommunity = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = domainDwritecommunity
	consoleHint:hidden = true
    }
}

#
#Node for discovery object table
#

discovery =  { [ use MANAGED-OBJECT ]
	mediumDesc = Discovery Information
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery
        consoleHint:hidden = true
	magic_number = { [ use STRING MANAGED-PROPERTY ]
		meduimDesc = Magic Number
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.magic_number
	}
	discoveryObjectTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc = Discovery Object Table
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable

		discoveryObjectTableEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
			mediumDesc = Discovery Object Table Entry
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry
	        	index = entry

	        	entry = { [ use INT MANAGED-PROPERTY ]
				consoleHint:hidden = true
        		}
                        discovery_object_uniqueID = { [ use STRING MANAGED-PROPERTY ]
                                mediumDesc = Discovery Object Unique ID
                                consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_uniqueID
			}
                        discovery_object_topology_parent = { [ use STRING MANAGED-PROPERTY ] 
                                mediumDesc = Discovery Object Topology Parent
                                consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_topology_parent 
                        } 
                        discovery_object_type = { [ use STRING MANAGED-PROPERTY ]  
                                mediumDesc = Discovery Object Type
                                consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_type 
                        } 
			discovery_object_ip_addr = { [ use IPADDRESS MANAGED-PROPERTY ]
				mediumDesc = Discovery IP Address
				consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_ip_addr
			}
			discovery_object_port = { [ use INT MANAGED-PROPERTY ]
				mediumDesc = Discovery Agent Port
				consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_port
			}
			discovery_object_family = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = Discovery Object Family
				consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_family
			}
			discovery_object_label = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = Discovery Object Label
				consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_label
			}
			discovery_object_description = { [ use STRING MANAGED-PROPERTY ]
				mediumDesc = Discovery Object Description
				consoleHint:mediumDesc = base.modules.serengeti-platadmin:discovery.discoveryObjectTable.discoveryObjectTableEntry.discovery_object_description
			}
		}
	}
}

#
#This is the dummy node for discovery to work. Please dont remove
#this node. If the discovery object table is the last node in the
#agent then discovery fails to walk the table because the next on
#the last oid return error code noSuchName. In snmplib being used
#by discovery takes this error code as error and returns error.
#

dummyNode = { [ use INT MANAGED-PROPERTY ]
    mediumDesc        = mediumDesc
    consoleHint:hidden = true
}

#
#Following are the five different views maintained for supporting 
#serengeti security. For description about the fields in the tables
#in all the views, please look into the SC mib. Everywhere the node
#CmdNode is used for management operations. Console will use this 
#node to set predefined information for management purposes. The node
#CmdStatusNode is used to inform the console back about the status os
#the management operations triggered by seting CmdNode.
#Everywhere, sunSmTreeProp node is used to provide PV/LV informations.
#

#
#Platform View
#

platform = { [ use MANAGED-OBJECT ]
    mediumDesc        =  platform
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform

    chassis = { [ use MANAGED-OBJECT ]
	mediumDesc        =  chassis
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis
	chassisTable = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  chassisTable
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable 
	    chassisEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  chassisEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry
		index = chassisIndex
		
	  
		chassisIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisIndex
                    consoleHint:hidden = true
		}
		chassisDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDescr
		}
		chassisTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisTreeNodeInfo
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisTreeNodeInfo
		    consoleHint:hidden = true
		}
		chassisFruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisFruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisFruIndex
		}
		chassisSCName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisSCName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisSCName
		}
		chassisLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisLocation
		}
		chassisContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisContact
		}
		chassisLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
		    mediumDesc        =  chassisLogHost
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisLogHost
		}
		chassisTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
		    mediumDesc        =  chassisTrapHosts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisTrapHosts
		}
		chassisSlots = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisSlots
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisSlots
		}
		chassisCpuSlots = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisCpuSlots
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisCpuSlots
		}
		chassisIoSlots = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisIoSlots
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisIoSlots
		}
		chassisUpTime = { [ use TIMETICKS MANAGED-PROPERTY ]
		    mediumDesc        =  chassisUpTime
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisUpTime
		}
		chassisModel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisModel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisModel
		}
		chassisDomains = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDomains
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDomains
		}
		chassisPartitionMode = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisPartitionMode
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisPartitionMode
		}
		chassisDomainAEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDomainAEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDomainAEtherAddr
		}
		chassisDomainBEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDomainBEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDomainBEtherAddr
		}
		chassisDomainCEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDomainCEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDomainCEtherAddr
		}
		chassisDomainDEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisDomainDEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisDomainDEtherAddr
		}
		chassisMasterSCEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisMasterSCEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisMasterSCEtherAddr
		}
		chassisSlaveSCEtherAddr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  chassisSlaveSCEtherAddr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisSlaveSCEtherAddr
		}
		chassisSystemSerialNumber = { [ use STRING  MANAGED-PROPERTY ]
		    mediumDesc        =  chassisSystemSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.chassis.chassisTable.chassisEntry.chassisSystemSerialNumber
		}
                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = sunSmTreeProp
                    consoleHint:hidden = true
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = Node Name
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
                    #consoleHint:hidden = true
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}
		machine = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        = machine
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.machine
		}
		platform = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        = platform
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.platform
		}
    
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin chassis
	    }
	}
   }
    slots = { [ use MANAGED-OBJECT ]
	mediumDesc        =  slots
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots
       
        originalTables = { [ use MANAGED-OBJECT ]
            mediumDesc        =  originalTables
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables
	    consoleHint:hidden = true
	    slotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  slotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotTestStatus
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotPowerStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotStatus
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.slotTable.slotEntry.slotName
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
	
		}
	    }
	    cpuBoardTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBoardTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry
		    index = cpuBoardChassisIndex cpuBoardIndex 
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardChassisIndex
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex
		    }
		    cpuBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardFruIndex
		    }
		    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalCPU
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalCPU
		    }
		    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalDramMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalDramMEM
		    }
		    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalEcacheMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
		    }
		    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalWCI
		    }
		    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTemp
		    }
		}
	    }
	    ioBoardTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBoardTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry
		    index = ioBoardChassisIndex ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardChassisIndex
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex
		    }
		    ioBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardFruIndex
		    }
		    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType
		    }
		    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalWCI
		    }
		    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalParoliCpciDca
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalParoliCpciDca
		    }
		    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTemp
		    }
		}
	    }
	    l2BoardTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  l2BoardTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable 
		l2BoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  l2BoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry
		    index = l2BoardIndex
		    
	      
		    l2BoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  l2BoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardIndex
		    }
		    l2BoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2BoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    l2BoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  l2BoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardFruIndex
		    }
		    l2BoardDomains = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2BoardDomains
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardDomains
		    }
		    l2BoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2BoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardTemp
		    }

		}
	    }
	    fanTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  fanTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable 
		fanEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  fanEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry
		    index = fanIndex
		    
	      
		    fanIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  fanIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry.fanIndex
		    }
		    fanTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry.fanTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    fanFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  fanFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry.fanFruIndex
		    }
		    fanSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  fanSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry.fanSpeed
		    }
		    fanType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.fanTable.fanEntry.fanType
		    }
		}
	    }
	    psTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  psTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable 
		psEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  psEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry
		    index = psIndex
		    
	      
		    psIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  psIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psIndex
		    }
		    psTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  psTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    psFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  psFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psFruIndex
		    }
		    psReadings = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  psReadings
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psReadings
		    }
		    psWattageUsed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  psWattageUsed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psWattageUsed
		    }
		    psLowHighInput = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  psLowHighInput
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psLowHighInput
		    }
		    psPrimTemperature = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  psPrimTemperature
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psPrimTemperature
		    }
		    psType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  psPrimTemperature
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.psTable.psEntry.psType
		    }
		}
	    }
	    scTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  scTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable 
		scEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  scEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry
		    index = scChassisIndex scIndex
		    
	      
		    scChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scChassisIndex
		    }
		    scIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scIndex
		    }
		    scMasterSlave = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scMasterSlave
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scMasterSlave
		    }
		    scTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    scFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scFruIndex
		    }
		    scVersion = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scVersion
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scVersion
		    }
		    scTimeZone = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scTimeZone
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scTimeZone
		    }
		    scDate = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scDate
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scDate
		    }
		    scNetConf = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scNetConf
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scNetConf
		    }
		    scHostname = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scHostname
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scHostname
		    }
		    scIP = { [ use IPADDRESS MANAGED-PROPERTY ]
			mediumDesc        =  scIP
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scIP
		    }
		    scNetmask = { [ use IPADDRESS MANAGED-PROPERTY ]
			mediumDesc        =  scNetmask
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scNetmask
		    }
		    scDefaultRouters = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scDefaultRouters
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scDefaultRouters
		    }
		    scDNSDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scDNSDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scDNSDomain
		    }
		    scDNSResolvers = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  scDNSResolvers
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scDNSResolvers
		    }
		    scNumConnections = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  scNumConnections
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scNumConnections
		    }
                    scState = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  scState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.originalTables.scTable.scEntry.scState
                    }
		}
	    }

        }
       
	emptySlots = { [use MANAGED-OBJECT ]
	    mediumDesc        =  emptySlots
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots
	    emptySlotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  emptySlotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotName
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotPowerStatus
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotTestStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_empty
		}
	    }
	}
	cpuBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  cpuBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards
	    cpuBrdTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBrdTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry
		    index = cpuBoardChassisIndex  cpuBoardIndex
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName
		    }
		    cpuBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardPowerStatus
		    }
		    cpuBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardBoardType
		    }
		    cpuBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardState
		    }
		    cpuBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTestStatus
		    }
		    cpuBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.slotStatus
		    }
                    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardFruIndex
                    }
                    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalCPU
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalCPU
                    }
                    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalDramMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalDramMEM
                    }
                    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalEcacheMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
                    }
                    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalWCI
                    }
                    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTemp
                    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_cpu
		}
	    }
	}
	ioBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  ioBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards
	    ioBrdTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBrdTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry
		    index = ioBoardChassisIndex  ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex
                        consoleHint:hidden = true
		    }
		    ioBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName
		    }
		    ioBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardPowerStatus
		    }
		    ioBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardBoardType
		    }
		    ioBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardState
		    }
		    ioBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTestStatus
		    }
		    ioBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.slotStatus
		    }
                    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardFruIndex
                    }
                    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardType
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardType
                    }
                    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalWCI
                    }
                    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalParoliCpciDca
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalParoliCpciDca
                    }
                    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTemp
                    }


		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_io
		}
	    }
	}
	l2Repeaters = { [use MANAGED-OBJECT ]
	    mediumDesc        =  l2Repeaters
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters
	    l2RepeaterTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  l2RepeaterTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable 
		l2RepeaterEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  l2RepeaterEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry
		    index = l2RepeaterChassisIndex  l2RepeaterIndex
		    
	      
		    l2RepeaterChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterChassisIndex
                        consoleHint:hidden = true
		    }
		    l2RepeaterIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterIndex
                        consoleHint:hidden = true
		    }
		    l2RepeaterName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterName
		    }
		    l2RepeaterPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterPowerStatus
		    }
		    l2RepeaterBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterBoardType
		    }
		    l2RepeaterState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterState
		    }
		    l2RepeaterTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterTestStatus
		    }
		    l2RepeaterDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  l2RepeaterDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.slotStatus
		    }
                    l2RepeaterFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  l2RepeaterFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterFruIndex
                    }
                    l2RepeaterDomains = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  l2RepeaterDomains
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterDomains
                    }
                    l2RepeaterTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  l2RepeaterTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterTemp
                    }

		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin l2
		}
	    }
	}
	fanTrays = { [use MANAGED-OBJECT ]
	    mediumDesc        =  fanTrays
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays
	    fanTrayTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  fanTrayTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable 
		fanEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  fanEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry
		    index = fanChassisIndex  fanIndex
		    
	      
		    fanChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  fanChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanChassisIndex
                        consoleHint:hidden = true
		    }
		    fanIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  fanIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanIndex
                        consoleHint:hidden = true
		    }
		    fanName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanName
		    }
		    fanPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanPowerStatus
		    }
		    fanBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanBoardType
		    }
		    fanState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanState
		    }
		    fanTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanTestStatus
		    }
		    fanDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  fanDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.slotStatus
		    }
                    fanFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  fanFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanFruIndex
                    }
                    fanSpeed = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  fanSpeed
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.fanTrays.fanTrayTable.fanEntry.fanSpeed
                    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin fan
		}
	    }
	}
	powerSupply = { [use MANAGED-OBJECT ]
	    mediumDesc        =  powerSupply
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply
	    powerSupplyTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  powerSupplyTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable 
		powerSupplyEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  powerSupplyEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry
		    index = powerSupplyChassisIndex  powerSupplyIndex
		    
	      
		    powerSupplyChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyChassisIndex
                        consoleHint:hidden = true
		    }
		    powerSupplyIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyIndex
                        consoleHint:hidden = true
		    }
		    powerSupplyName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyName
		    }
		    powerSupplyPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyPowerStatus
		    }
		    powerSupplyBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyBoardType
		    }
		    powerSupplyState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyState
		    }
		    powerSupplyTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyTestStatus
		    }
		    powerSupplyDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  powerSupplyDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.slotStatus
		    }
                    powerSupplyFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  powerSupplyFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyFruIndex
                    }
                    powerSupplyReadings = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  powerSupplyReadings
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyReadings
                    }
                    powerSupplyWattageUsed = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  powerSupplyWattageUsed
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyWattageUsed
                    }
                    powerSupplyLowHighInput = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  powerSupplyLowHighInput
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyLowHighInput
                    }
                    powerSupplyPrimTemperature = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  powerSupplyPrimTemperature
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyPrimTemperature
                    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin power
		}
	    }
	}
	systemController = { [use MANAGED-OBJECT ]
	    mediumDesc        =  systemController
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController
	    systemControllerTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  systemControllerTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable 
		systemControllerEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  systemControllerEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry
		    index = systemControllerChassisIndex  systemControllerIndex
		    
	      
		    systemControllerChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerChassisIndex
                        consoleHint:hidden = true
		    }
		    systemControllerIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerIndex
                        consoleHint:hidden = true
		    }
		    systemControllerName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerName
		    }
		    systemControllerPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerPowerStatus
		    }
		    systemControllerBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerBoardType
		    }
		    systemControllerState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerState
		    }
		    systemControllerTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerTestStatus
		    }
		    systemControllerDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  systemControllerDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.slotStatus
		    }
                    systemControllerMasterSlave = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerMasterSlave
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerMasterSlave
                    }
                    systemControllerFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerFruIndex
                    }
                    systemControllerVersion = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerVersion
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerVersion
                    }
                    systemControllerTimeZone = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerTimeZone
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerTimeZone
                    }
                    systemControllerDate = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerDate
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerDate
                    }
                    systemControllerNetConf = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerNetConf
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerNetConf
                    }
                    systemControllerHostname = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerHostname
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerHostname
                    }
                    systemControllerIP = { [ use IPADDRESS MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerIP
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerIP
                    }
                    systemControllerNetmask = { [ use IPADDRESS MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerNetmask
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerNetmask
                    }
                    systemControllerDefaultRouters = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerDefaultRouters
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerDefaultRouters
                    }
                    systemControllerDNSDomain = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerDNSDomain
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerDNSDomain
                    }
                    systemControllerDNSResolvers = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerDNSResolvers
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerDNSResolvers
                    }
                    systemControllerNumConnections = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  systemControllerNumConnections
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerNumConnections
                    }
                    #systemControllerState = { [ use INT MANAGED-PROPERTY ]
                    #    mediumDesc        =  systemControllerState
                    #    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerState
                    #}
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin sc
		}
	    }
	}
	unknownBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  unknownBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards
	    unknownBrdTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  unknownBrdTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable 
		unknownBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  unknownBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry
		    index = unknownBoardChassisIndex  unknownBoardIndex
		    
	      
		    unknownBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardName
		    }
		    unknownBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardPowerStatus
		    }
		    unknownBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardBoardType
		    }
		    unknownBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardState
		    }
		    unknownBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardTestStatus
		    }
		    unknownBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.slotStatus
		    }

		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_unknown
		}
	    }
	}
    }
    fru = { [ use MANAGED-OBJECT ]
	mediumDesc        =  fru
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru
	consoleHint:hidden = true
	fruTable = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  fruTable
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable 
	    fruEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  fruEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry
		index = fruIndex
		
	  
		fruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruIndex
		}
		fruDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruDescr
		}
		fruType = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruType
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruType
		}
		fruManufactureDate = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureDate
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruManufactureDate
		}
		fruManufactureLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruManufactureLocation
		}
		fruPartNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruPartNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruPartNumber
		}
		fruSerialNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruSerialNumber
		}
		fruVendorName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruVendorName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruVendorName
		}
		fruInitHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruInitHwDashLevel
		}
		fruInitHwRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruInitHwRevLevel
		}
		fruSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruSpeed
		}
		fruSize = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSize
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruSize
		}
		fruBoardSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruBoardSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruBoardSpeed
		}
		fruBootbusTiming = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruBootbusTiming
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruBootbusTiming
		}
		fruNoUpdates = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruNoUpdates
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruNoUpdates
		}
		fruLastPowerOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruLastPowerOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruLastPowerOn
		}
		fruTotalErrors = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalErrors
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruTotalErrors
		}
		fruTotalInserts = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalInserts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruTotalInserts
		}
		fruTotalPowerOns = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalPowerOns
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruTotalPowerOns
		}
		fruTotalTimeOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalTimeOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruTotalTimeOn
		}
		fruHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruHwDashLevel
		}
		fruRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.fru.fruTable.fruEntry.fruRevLevel
		}
    
	    }
	}
    }

    components = { [ use MANAGED-OBJECT ]
        mediumDesc        =  components
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components


        cpuMod = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  cpuMod
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod
	    cpuModTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuModTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable 
		cpuModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry
		    index = cpuModBoardIndex cpuModIndex
		    
	      
		    cpuModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex
		    }
		    cpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex
		    }
		    cpuModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModDescr
		    }
		    cpuModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModTemp
		    }
		    cpuModStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  cpuModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModStatus
		    }
		    cpuModModel = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModModel
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModModel
		    }
		    cpuModSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModSpeed
		    }
		    cpuModIcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModIcacheSize
		    }
		    cpuModDcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModDcacheSize
		    }
		    cpuModEcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModEcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModEcacheSize
		    }
		    cpuModWcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModWcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModWcacheSize
		    }
		    cpuModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  cpuModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModLastChange
		    }
		    cpuModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  cpuModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModErrors
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		}
	    }
        }




        dimm = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  dimm
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm
	    dimmTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  dimmTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable 
		dimmEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  dimmEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry
		    index = dimmCpuBoardIndex dimmCpuModIndex dimmIndex
		    
	      
		    dimmCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex
		    }
		    dimmCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex
		    }
		    dimmIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry.dimmIndex
		    }
		    dimmTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  dimmTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    dimmFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.dimm.dimmTable.dimmEntry.dimmFruIndex
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_dimm
		}
	    }
        }



        ecache  = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  ecache
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache
	    ecacheTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ecacheTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable 
		ecacheEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ecacheEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry
		    index = ecacheCpuBoardIndex ecacheCpuModIndex ecacheIndex
		    
	      
		    ecacheCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex
		    }
		    ecacheCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex
		    }
		    ecacheIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry.ecacheIndex
		    }
		    ecacheTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ecacheTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ecacheFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.ecache.ecacheTable.ecacheEntry.ecacheFruIndex
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_ecache
		}
	    }
        }

        wci = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wci
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci
	    wciModTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciModTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable 
		wciModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry
		    index = wciModBoardIndex wciModIndex
		    
	      
		    wciModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModBoardIndex
		    }
		    wciModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModIndex
		    }
		    wciModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModDescr
		    }
		    wciModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciModStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModStatus
		    }
		    wciModMode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModMode
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModMode
		    }
		    wciModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTemp
		    }
		    wciModTotalDIMM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalDIMM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTotalDIMM
		    }
		    wciModTotalMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTotalMEM
		    }
		    wciModTotalParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTotalParoliDCA
		    }
		    wciModTotalPort = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalPort
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModTotalPort
		    }
		    wciModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  wciModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModLastChange
		    }
		    wciModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wci.wciModTable.wciModEntry.wciModErrors
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		}
	    }
        }




        wciPort = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wciPort
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort
	    wciPortTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciPortTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable 
		wciPortEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciPortEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry
		    index = wciPortBoardIndex wciPortModIndex wciPortIndex
		    
	      
		    wciPortBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex
		    }
		    wciPortModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortModIndex
		    }
		    wciPortIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex
		    }
		    wciPortTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciPortFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortFruIndex
		    }
		    wciPortStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortStatus
		    }
		    wciPortParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortParoliDCA
		    }
		    wciPortRemoteLoc = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortRemoteLoc
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.components.wciPort.wciPortTable.wciPortEntry.wciPortRemoteLoc
		    }
		    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = sunSmTreeProp
			consoleHint:hidden = true
		    }
		    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
			type        = active
			mediumDesc  = Node Name
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
			#consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_wciPort
		}
	    }
        }

    }


    domains = { [use MANAGED-OBJECT ]
        mediumDesc        =  domains
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains

        domainTable = { [ use MANAGED-OBJECT-TABLE ]
            mediumDesc = Domain Table
            consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable
            domainEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                mediumDesc = Domain Table Entry
                consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry
                index = domainIndex

                domainIndex = { [ use INT MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainIndex
                    consoleHint:hidden = true
                }
                domainDomain = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainDomain
                }
                domainDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainDescr
                }
#                domainPublicCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainPublicCommunity
#                    consoleHint:hidden = true
#                }
#                domainPrivateCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainPrivateCommunity
#                    consoleHint:hidden = true
#                }
                domainLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainLogHost
                }
                domainTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainTrapHosts
                }
                domainACLDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainACLDescr
                }
                domainStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainStatus
                }
                domainNodeName = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainNodeName
                }
                domainSsmMode = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainSsmMode
                }
                domainSsmMaster = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainSsmMaster
                }
                domainSsmSlaveNodes = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainSsmSlaveNodes
                }
                domainKeySwitch = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainKeySwitch
                }
		domainContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  domainContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.domainContact
		}
                snmpAgentPort = { [ use INT MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = snmpAgentPort
                    consoleHint:hidden = true
                }
                slotsNotInACL = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = slotsNotInACL
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.domains.domainTable.domainEntry.slotsNotInACL
                }
                sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = sunSmTreeProp
                    consoleHint:hidden = true
                }
                sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = Node Name
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:system.sunSmNodeName
                    consoleHint:hidden = true
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    access             = rw
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin platform_domain
            }
        }
    }
}

#
#DomainA View
#

domainA = { [ use MANAGED-OBJECT ]
    mediumDesc        =  domainA
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domainA

    slots = { [ use MANAGED-OBJECT ]
	mediumDesc        =  slots
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots
       
        originalTables = { [ use MANAGED-OBJECT ]
            mediumDesc        =  originalTables
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables
	    consoleHint:hidden = true
	    slotTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  slotTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotChassisIndex
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotIndex
		    }
		    slotTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTestStatus
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotPowerStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotStatus
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotName
		    }
	
		}
	    }
	    cpuBoardTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBoardTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry
		    index = cpuBoardChassisIndex cpuBoardIndex 
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardChassisIndex
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex
		    }
		    cpuBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardFruIndex
		    }
		    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalCPU
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalCPU
		    }
		    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalDramMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalDramMEM
		    }
		    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalEcacheMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
		    }
		    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalWCI
		    }
		    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTemp
		    }


		}
	    }
	    ioBoardTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBoardTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry
		    index = ioBoardChassisIndex ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardChassisIndex
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex
		    }
		    ioBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardFruIndex
		    }
		    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType
		    }
		    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalWCI
		    }
		    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalParoliCpciDca
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalParoliCpciDca
		    }
		    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTemp
		    }


		}
	    }

        }
	emptySlots = { [use MANAGED-OBJECT ]
	    mediumDesc        =  emptySlots
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots
	    emptySlotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  emptySlotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotName
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotPowerStatus
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotTestStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_empty
		}
	    }
	}
       
	cpuBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  cpuBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards
	    cpuBrdTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBrdTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry
		    index = cpuBoardChassisIndex  cpuBoardIndex
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName
		    }
		    cpuBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardPowerStatus
		    }
		    cpuBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardBoardType
		    }
		    cpuBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardState
		    }
		    cpuBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTestStatus
		    }
		    cpuBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.slotStatus
		    }
                    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardFruIndex
                    }
                    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalCPU
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalCPU
                    }
                    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalDramMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalDramMEM
                    }
                    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalEcacheMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
                    }
                    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalWCI
                    }
                    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTemp
                    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_cpu
		}
	    }
	}
	ioBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  ioBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards
	    ioBrdTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBrdTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry
		    index = ioBoardChassisIndex  ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex
                        consoleHint:hidden = true
		    }
		    ioBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName
		    }
		    ioBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardPowerStatus
		    }
		    ioBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardBoardType
		    }
		    ioBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardState
		    }
		    ioBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTestStatus
		    }
		    ioBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.slotStatus
		    }
                    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardFruIndex
                    }
                    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardType
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardType
                    }
                    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalWCI
                    }
                    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalParoliCpciDca
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalParoliCpciDca
                    }
                    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTemp
                    }


		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_io
		}
	    }
	}
	unknownBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  unknownBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards
	    unknownBrdTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  unknownBrdTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable 
		unknownBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  unknownBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry
		    index = unknownBoardChassisIndex  unknownBoardIndex
		    
	      
		    unknownBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardName
		    }
		    unknownBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardPowerStatus
		    }
		    unknownBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardBoardType
		    }
		    unknownBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardState
		    }
		    unknownBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardTestStatus
		    }
		    unknownBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.slotStatus
		    }

		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.domainAdmin.CaPlatformAdmin domainA_unknown
		}
	    }
	}
    }
    fru = { [ use MANAGED-OBJECT ]
	mediumDesc        =  fru
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru
	consoleHint:hidden = true
	fruTableA = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  fruTableA
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable 
	    fruEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  fruEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry
		index = fruIndex
		
	  
		fruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruIndex
		}
		fruDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruDescr
		}
		fruType = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruType
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruType
		}
		fruManufactureDate = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureDate
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureDate
		}
		fruManufactureLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureLocation
		}
		fruPartNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruPartNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruPartNumber
		}
		fruSerialNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSerialNumber
		}
		fruVendorName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruVendorName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruVendorName
		}
		fruInitHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwDashLevel
		}
		fruInitHwRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwRevLevel
		}
		fruSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSpeed
		}
		fruSize = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSize
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSize
		}
		fruBoardSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruBoardSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBoardSpeed
		}
		fruBootbusTiming = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruBootbusTiming
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBootbusTiming
		}
		fruNoUpdates = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruNoUpdates
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruNoUpdates
		}
		fruLastPowerOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruLastPowerOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruLastPowerOn
		}
		fruTotalErrors = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalErrors
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalErrors
		}
		fruTotalInserts = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalInserts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalInserts
		}
		fruTotalPowerOns = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalPowerOns
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalPowerOns
		}
		fruTotalTimeOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalTimeOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalTimeOn
		}
		fruHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruHwDashLevel
		}
		fruRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruRevLevel
		}
    
	    }
	}
    }

    components = { [ use MANAGED-OBJECT ]
        mediumDesc        =  components
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components


        cpuMod = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  cpuMod
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod
	    cpuModTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuModTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable 
		cpuModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry
		    index = cpuModBoardIndex cpuModIndex
		    
	      
		    cpuModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex
		    }
		    cpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex
		    }
		    cpuModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDescr
		    }
		    cpuModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTemp
		    }
		    cpuModStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  cpuModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModStatus
		    }
		    cpuModModel = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModModel
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModModel
		    }
		    cpuModSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModSpeed
		    }
		    cpuModIcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIcacheSize
		    }
		    cpuModDcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDcacheSize
		    }
		    cpuModEcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModEcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModEcacheSize
		    }
		    cpuModWcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModWcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModWcacheSize
		    }
		    cpuModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  cpuModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModLastChange
		    }
		    cpuModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  cpuModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModErrors
		    }

		}
	    }
        }




        dimm = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  dimm
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm
	    dimmTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  dimmTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable 
		dimmEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  dimmEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry
		    index = dimmCpuBoardIndex dimmCpuModIndex dimmIndex
		    
	      
		    dimmCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex
		    }
		    dimmCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex
		    }
		    dimmIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmIndex
		    }
		    dimmTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  dimmTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    dimmFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_dimm
		}
	    }
        }



        ecache  = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  ecache
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache
	    ecacheTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ecacheTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable 
		ecacheEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ecacheEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry
		    index = ecacheCpuBoardIndex ecacheCpuModIndex ecacheIndex
		    
	      
		    ecacheCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex
		    }
		    ecacheCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex
		    }
		    ecacheIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheIndex
		    }
		    ecacheTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ecacheTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ecacheFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_ecache
		}
	    }
        }

        wci = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wci
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci
	    wciModTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciModTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable 
		wciModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry
		    index = wciModBoardIndex wciModIndex
		    
	      
		    wciModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModBoardIndex
		    }
		    wciModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModIndex
		    }
		    wciModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModDescr
		    }
		    wciModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciModStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModStatus
		    }
		    wciModMode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModMode
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModMode
		    }
		    wciModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTemp
		    }
		    wciModTotalDIMM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalDIMM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalDIMM
		    }
		    wciModTotalMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalMEM
		    }
		    wciModTotalParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalParoliDCA
		    }
		    wciModTotalPort = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalPort
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalPort
		    }
		    wciModLastChange = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModLastChange
		    }
		    wciModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModErrors
		    }

		}
	    }
        }




        wciPort = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wciPort
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort
	    wciPortTableA = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciPortTableA
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable 
		wciPortEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciPortEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry
		    index = wciPortBoardIndex wciPortModIndex wciPortIndex
		    
	      
		    wciPortBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex
		    }
		    wciPortModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortModIndex
		    }
		    wciPortIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex
		    }
		    wciPortTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciPortFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortFruIndex
		    }
		    wciPortStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortStatus
		    }
		    wciPortParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortParoliDCA
		    }
		    wciPortRemoteLoc = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortRemoteLoc
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortRemoteLoc
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA_wciPort
		}
	    }
        }

    }


    domains = { [use MANAGED-OBJECT ]
        mediumDesc        =  domains
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains

        domainTableA = { [ use MANAGED-OBJECT-TABLE ]
            mediumDesc = Domain Table
            consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable
            domainEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                mediumDesc = Domain Table Entry
                consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry
                index = domainIndex

                domainIndex = { [ use INT MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainIndex
                    consoleHint:hidden = true
                }
                domainDomain = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDomain
                }
                domainDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDescr
                }
#                domainPublicCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPublicCommunity
#                    consoleHint:hidden = true
#                }
#                domainPrivateCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPrivateCommunity
#                    consoleHint:hidden = true
#                }
                domainLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainLogHost
                }
                domainTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainTrapHosts
                }
                domainACLDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainACLDescr
                }
                domainStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainStatus
                }
                domainNodeName = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainNodeName
                }
                domainSsmMode = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMode
                }
                domainSsmMaster = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMaster
                }
                domainSsmSlaveNodes = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmSlaveNodes
                }
                domainKeySwitch = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainKeySwitch
                }
		domainContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  domainContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainContact
		}
                snmpAgentPort = { [ use INT MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = snmpAgentPort
                    consoleHint:hidden = true
                }
                slotsNotInACL = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = slotsNotInACL
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.slotsNotInACL
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    access             = rw
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainA
            }
        }
    }
}

#
#DomainB View
#

domainB = { [ use MANAGED-OBJECT ]
    mediumDesc        =  domainB
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domainB

    slots = { [ use MANAGED-OBJECT ]
	mediumDesc        =  slots
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots
       
        originalTables = { [ use MANAGED-OBJECT ]
            mediumDesc        =  originalTables
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables
	    consoleHint:hidden = true
	    slotTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  slotTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotChassisIndex
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotIndex
		    }
		    slotTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTestStatus
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotPowerStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotStatus
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotName
		    }
	
		}
	    }
	    cpuBoardTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBoardTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry
		    index = cpuBoardChassisIndex cpuBoardIndex 
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardChassisIndex
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex
		    }
		    cpuBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardFruIndex
		    }
		    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalCPU
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalCPU
		    }
		    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalDramMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalDramMEM
		    }
		    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalEcacheMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
		    }
		    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalWCI
		    }
		    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTemp
		    }


		}
	    }
	    ioBoardTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBoardTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry
		    index = ioBoardChassisIndex ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardChassisIndex
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex
		    }
		    ioBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardFruIndex
		    }
		    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType
		    }
		    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalWCI
		    }
		    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalParoliCpciDca
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalParoliCpciDca
		    }
		    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTemp
		    }


		}
	    }

        }
	emptySlots = { [use MANAGED-OBJECT ]
	    mediumDesc        =  emptySlots
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots
	    emptySlotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  emptySlotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotName
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotPowerStatus
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotTestStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_empty
		}
	    }
	}
       
	cpuBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  cpuBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards
	    cpuBrdTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBrdTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry
		    index = cpuBoardChassisIndex  cpuBoardIndex
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName
		    }
		    cpuBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardPowerStatus
		    }
		    cpuBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardBoardType
		    }
		    cpuBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardState
		    }
		    cpuBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTestStatus
		    }
		    cpuBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.slotStatus
		    }
                    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardFruIndex
                    }
                    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalCPU
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalCPU
                    }
                    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalDramMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalDramMEM
                    }
                    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalEcacheMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
                    }
                    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalWCI
                    }
                    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTemp
                    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_cpu
		}
	    }
	}
	ioBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  ioBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards
	    ioBrdTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBrdTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry
		    index = ioBoardChassisIndex  ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex
                        consoleHint:hidden = true
		    }
		    ioBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName
		    }
		    ioBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardPowerStatus
		    }
		    ioBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardBoardType
		    }
		    ioBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardState
		    }
		    ioBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTestStatus
		    }
		    ioBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.slotStatus
		    }
                    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardFruIndex
                    }
                    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardType
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardType
                    }
                    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalWCI
                    }
                    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalParoliCpciDca
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalParoliCpciDca
                    }
                    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTemp
                    }


		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_io
		}
	    }
	}
	unknownBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  unknownBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards
	    unknownBrdTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  unknownBrdTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable 
		unknownBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  unknownBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry
		    index = unknownBoardChassisIndex  unknownBoardIndex
		    
	      
		    unknownBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardName
		    }
		    unknownBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardPowerStatus
		    }
		    unknownBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardBoardType
		    }
		    unknownBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardState
		    }
		    unknownBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardTestStatus
		    }
		    unknownBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.slotStatus
		    }

		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.domainAdmin.CaPlatformAdmin domainB_unknown
		}
	    }
	}
    }
    fru = { [ use MANAGED-OBJECT ]
	mediumDesc        =  fru
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru
	consoleHint:hidden = true
	fruTableB = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  fruTableB
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable 
	    fruEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  fruEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry
		index = fruIndex
		
	  
		fruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruIndex
		}
		fruDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruDescr
		}
		fruType = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruType
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruType
		}
		fruManufactureDate = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureDate
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureDate
		}
		fruManufactureLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureLocation
		}
		fruPartNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruPartNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruPartNumber
		}
		fruSerialNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSerialNumber
		}
		fruVendorName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruVendorName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruVendorName
		}
		fruInitHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwDashLevel
		}
		fruInitHwRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwRevLevel
		}
		fruSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSpeed
		}
		fruSize = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSize
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSize
		}
		fruBoardSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruBoardSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBoardSpeed
		}
		fruBootbusTiming = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruBootbusTiming
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBootbusTiming
		}
		fruNoUpdates = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruNoUpdates
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruNoUpdates
		}
		fruLastPowerOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruLastPowerOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruLastPowerOn
		}
		fruTotalErrors = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalErrors
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalErrors
		}
		fruTotalInserts = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalInserts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalInserts
		}
		fruTotalPowerOns = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalPowerOns
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalPowerOns
		}
		fruTotalTimeOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalTimeOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalTimeOn
		}
		fruHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruHwDashLevel
		}
		fruRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruRevLevel
		}
    
	    }
	}
    }

    components = { [ use MANAGED-OBJECT ]
        mediumDesc        =  components
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components


        cpuMod = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  cpuMod
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod
	    cpuModTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuModTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable 
		cpuModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry
		    index = cpuModBoardIndex cpuModIndex
		    
	      
		    cpuModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex
		    }
		    cpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex
		    }
		    cpuModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDescr
		    }
		    cpuModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTemp
		    }
		    cpuModStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  cpuModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModStatus
		    }
		    cpuModModel = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModModel
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModModel
		    }
		    cpuModSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModSpeed
		    }
		    cpuModIcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIcacheSize
		    }
		    cpuModDcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDcacheSize
		    }
		    cpuModEcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModEcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModEcacheSize
		    }
		    cpuModWcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModWcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModWcacheSize
		    }
		    cpuModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  cpuModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModLastChange
		    }
		    cpuModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  cpuModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModErrors
		    }

		}
	    }
        }




        dimm = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  dimm
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm
	    dimmTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  dimmTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable 
		dimmEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  dimmEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry
		    index = dimmCpuBoardIndex dimmCpuModIndex dimmIndex
		    
	      
		    dimmCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex
		    }
		    dimmCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex
		    }
		    dimmIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmIndex
		    }
		    dimmTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  dimmTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    dimmFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_dimm
		}
	    }
        }



        ecache  = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  ecache
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache
	    ecacheTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ecacheTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable 
		ecacheEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ecacheEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry
		    index = ecacheCpuBoardIndex ecacheCpuModIndex ecacheIndex
		    
	      
		    ecacheCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex
		    }
		    ecacheCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex
		    }
		    ecacheIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheIndex
		    }
		    ecacheTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ecacheTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ecacheFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_ecache
		}
	    }
        }

        wci = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wci
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci
	    wciModTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciModTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable 
		wciModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry
		    index = wciModBoardIndex wciModIndex
		    
	      
		    wciModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModBoardIndex
		    }
		    wciModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModIndex
		    }
		    wciModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModDescr
		    }
		    wciModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciModStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModStatus
		    }
		    wciModMode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModMode
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModMode
		    }
		    wciModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTemp
		    }
		    wciModTotalDIMM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalDIMM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalDIMM
		    }
		    wciModTotalMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalMEM
		    }
		    wciModTotalParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalParoliDCA
		    }
		    wciModTotalPort = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalPort
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalPort
		    }
		    wciModLastChange = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModLastChange
		    }
		    wciModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModErrors
		    }

		}
	    }
        }




        wciPort = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wciPort
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort
	    wciPortTableB = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciPortTableB
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable 
		wciPortEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciPortEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry
		    index = wciPortBoardIndex wciPortModIndex wciPortIndex
		    
	      
		    wciPortBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex
		    }
		    wciPortModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortModIndex
		    }
		    wciPortIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex
		    }
		    wciPortTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciPortFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortFruIndex
		    }
		    wciPortStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortStatus
		    }
		    wciPortParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortParoliDCA
		    }
		    wciPortRemoteLoc = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortRemoteLoc
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortRemoteLoc
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB_wciPort
		}
	    }
        }

    }


    domains = { [use MANAGED-OBJECT ]
        mediumDesc        =  domains
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains

        domainTableB = { [ use MANAGED-OBJECT-TABLE ]
            mediumDesc = Domain Table
            consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable
            domainEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                mediumDesc = Domain Table Entry
                consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry
                index = domainIndex

                domainIndex = { [ use INT MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainIndex
                    consoleHint:hidden = true
                }
                domainDomain = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDomain
                }
                domainDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDescr
                }
#                domainPublicCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPublicCommunity
#                    consoleHint:hidden = true
#                }
#                domainPrivateCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPrivateCommunity
#                    consoleHint:hidden = true
#                }
                domainLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainLogHost
                }
                domainTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainTrapHosts
                }
                domainACLDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainACLDescr
                }
                domainStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainStatus
                }
                domainNodeName = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainNodeName
                }
                domainSsmMode = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMode
                }
                domainSsmMaster = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMaster
                }
                domainSsmSlaveNodes = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmSlaveNodes
                }
                domainKeySwitch = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainKeySwitch
                }
		domainContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  domainContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainContact
		}
                snmpAgentPort = { [ use INT MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = snmpAgentPort
                    consoleHint:hidden = true
                }
                slotsNotInACL = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = slotsNotInACL
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.slotsNotInACL
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    access             = rw
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainB
            }
        }
    }
}

#
#DomainC View
#

domainC = { [ use MANAGED-OBJECT ]
    mediumDesc        =  domainC
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domainC

    slots = { [ use MANAGED-OBJECT ]
	mediumDesc        =  slots
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots
       
        originalTables = { [ use MANAGED-OBJECT ]
            mediumDesc        =  originalTables
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables
	    consoleHint:hidden = true
	    slotTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  slotTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotChassisIndex
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotIndex
		    }
		    slotTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTestStatus
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotPowerStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotStatus
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotName
		    }
	
		}
	    }
	    cpuBoardTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBoardTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry
		    index = cpuBoardChassisIndex cpuBoardIndex 
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardChassisIndex
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex
		    }
		    cpuBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardFruIndex
		    }
		    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalCPU
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalCPU
		    }
		    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalDramMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalDramMEM
		    }
		    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalEcacheMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
		    }
		    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalWCI
		    }
		    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTemp
		    }


		}
	    }
	    ioBoardTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBoardTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry
		    index = ioBoardChassisIndex ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardChassisIndex
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex
		    }
		    ioBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardFruIndex
		    }
		    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType
		    }
		    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalWCI
		    }
		    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalParoliCpciDca
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalParoliCpciDca
		    }
		    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTemp
		    }


		}
	    }

        }
	emptySlots = { [use MANAGED-OBJECT ]
	    mediumDesc        =  emptySlots
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots
	    emptySlotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  emptySlotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotName
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotPowerStatus
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotTestStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_empty
		}
	    }
	}
       
	cpuBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  cpuBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards
	    cpuBrdTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBrdTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry
		    index = cpuBoardChassisIndex  cpuBoardIndex
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName
		    }
		    cpuBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardPowerStatus
		    }
		    cpuBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardBoardType
		    }
		    cpuBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardState
		    }
		    cpuBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTestStatus
		    }
		    cpuBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.slotStatus
		    }
                    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardFruIndex
                    }
                    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalCPU
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalCPU
                    }
                    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalDramMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalDramMEM
                    }
                    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalEcacheMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
                    }
                    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalWCI
                    }
                    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTemp
                    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_cpu
		}
	    }
	}
	ioBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  ioBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards
	    ioBrdTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBrdTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry
		    index = ioBoardChassisIndex  ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex
                        consoleHint:hidden = true
		    }
		    ioBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName
		    }
		    ioBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardPowerStatus
		    }
		    ioBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardBoardType
		    }
		    ioBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardState
		    }
		    ioBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTestStatus
		    }
		    ioBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.slotStatus
		    }
                    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardFruIndex
                    }
                    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardType
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardType
                    }
                    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalWCI
                    }
                    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalParoliCpciDca
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalParoliCpciDca
                    }
                    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTemp
                    }


		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_io
		}
	    }
	}
	unknownBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  unknownBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards
	    unknownBrdTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  unknownBrdTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable 
		unknownBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  unknownBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry
		    index = unknownBoardChassisIndex  unknownBoardIndex
		    
	      
		    unknownBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardName
		    }
		    unknownBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardPowerStatus
		    }
		    unknownBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardBoardType
		    }
		    unknownBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardState
		    }
		    unknownBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardTestStatus
		    }
		    unknownBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.domainAdmin.CaPlatformAdmin domainC_unknown
		}
	    }
	}
    }
    fru = { [ use MANAGED-OBJECT ]
	mediumDesc        =  fru
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru
	consoleHint:hidden = true
	fruTableC = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  fruTableC
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable 
	    fruEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  fruEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry
		index = fruIndex
		
	  
		fruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruIndex
		}
		fruDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruDescr
		}
		fruType = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruType
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruType
		}
		fruManufactureDate = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureDate
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureDate
		}
		fruManufactureLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureLocation
		}
		fruPartNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruPartNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruPartNumber
		}
		fruSerialNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSerialNumber
		}
		fruVendorName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruVendorName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruVendorName
		}
		fruInitHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwDashLevel
		}
		fruInitHwRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwRevLevel
		}
		fruSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSpeed
		}
		fruSize = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSize
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSize
		}
		fruBoardSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruBoardSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBoardSpeed
		}
		fruBootbusTiming = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruBootbusTiming
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBootbusTiming
		}
		fruNoUpdates = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruNoUpdates
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruNoUpdates
		}
		fruLastPowerOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruLastPowerOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruLastPowerOn
		}
		fruTotalErrors = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalErrors
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalErrors
		}
		fruTotalInserts = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalInserts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalInserts
		}
		fruTotalPowerOns = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalPowerOns
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalPowerOns
		}
		fruTotalTimeOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalTimeOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalTimeOn
		}
		fruHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruHwDashLevel
		}
		fruRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruRevLevel
		}
    
	    }
	}
    }

    components = { [ use MANAGED-OBJECT ]
        mediumDesc        =  components
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components


        cpuMod = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  cpuMod
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod
	    cpuModTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuModTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable 
		cpuModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry
		    index = cpuModBoardIndex cpuModIndex
		    
	      
		    cpuModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex
		    }
		    cpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex
		    }
		    cpuModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDescr
		    }
		    cpuModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTemp
		    }
		    cpuModStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  cpuModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModStatus
		    }
		    cpuModModel = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModModel
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModModel
		    }
		    cpuModSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModSpeed
		    }
		    cpuModIcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIcacheSize
		    }
		    cpuModDcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDcacheSize
		    }
		    cpuModEcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModEcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModEcacheSize
		    }
		    cpuModWcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModWcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModWcacheSize
		    }
		    cpuModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  cpuModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModLastChange
		    }
		    cpuModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  cpuModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModErrors
		    }

		}
	    }
        }




        dimm = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  dimm
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm
	    dimmTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  dimmTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable 
		dimmEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  dimmEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry
		    index = dimmCpuBoardIndex dimmCpuModIndex dimmIndex
		    
	      
		    dimmCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex
		    }
		    dimmCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex
		    }
		    dimmIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmIndex
		    }
		    dimmTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  dimmTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    dimmFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_dimm
		}
	    }
        }



        ecache  = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  ecache
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache
	    ecacheTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ecacheTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable 
		ecacheEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ecacheEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry
		    index = ecacheCpuBoardIndex ecacheCpuModIndex ecacheIndex
		    
	      
		    ecacheCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex
		    }
		    ecacheCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex
		    }
		    ecacheIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheIndex
		    }
		    ecacheTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ecacheTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ecacheFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_ecache
		}
	    }
        }

        wci = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wci
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci
	    wciModTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciModTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable 
		wciModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry
		    index = wciModBoardIndex wciModIndex
		    
	      
		    wciModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModBoardIndex
		    }
		    wciModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModIndex
		    }
		    wciModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModDescr
		    }
		    wciModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciModStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModStatus
		    }
		    wciModMode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModMode
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModMode
		    }
		    wciModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTemp
		    }
		    wciModTotalDIMM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalDIMM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalDIMM
		    }
		    wciModTotalMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalMEM
		    }
		    wciModTotalParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalParoliDCA
		    }
		    wciModTotalPort = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalPort
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalPort
		    }
		    wciModLastChange = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModLastChange
		    }
		    wciModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModErrors
		    }

		}
	    }
        }




        wciPort = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wciPort
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort
	    wciPortTableC = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciPortTableC
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable 
		wciPortEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciPortEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry
		    index = wciPortBoardIndex wciPortModIndex wciPortIndex
		    
	      
		    wciPortBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex
		    }
		    wciPortModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortModIndex
		    }
		    wciPortIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex
		    }
		    wciPortTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciPortFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortFruIndex
		    }
		    wciPortStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortStatus
		    }
		    wciPortParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortParoliDCA
		    }
		    wciPortRemoteLoc = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortRemoteLoc
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortRemoteLoc
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC_wciPort
		}
	    }
        }

    }


    domains = { [use MANAGED-OBJECT ]
        mediumDesc        =  domains
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains

        domainTableC = { [ use MANAGED-OBJECT-TABLE ]
            mediumDesc = Domain Table
            consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable
            domainEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                mediumDesc = Domain Table Entry
                consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry
                index = domainIndex

                domainIndex = { [ use INT MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainIndex
                    consoleHint:hidden = true
                }
                domainDomain = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDomain
                }
                domainDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDescr
                }
#                domainPublicCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPublicCommunity
#                    consoleHint:hidden = true
#                }
#                domainPrivateCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPrivateCommunity
#                    consoleHint:hidden = true
#                }
                domainLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainLogHost
                }
                domainTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainTrapHosts
                }
                domainACLDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainACLDescr
                }
                domainStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainStatus
                }
                domainNodeName = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainNodeName
                }
                domainSsmMode = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMode
                }
                domainSsmMaster = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMaster
                }
                domainSsmSlaveNodes = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmSlaveNodes
                }
                domainKeySwitch = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainKeySwitch
                }
		domainContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  domainContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainContact
		}
                snmpAgentPort = { [ use INT MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = snmpAgentPort
                    consoleHint:hidden = true
                }
                slotsNotInACL = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = slotsNotInACL
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.slotsNotInACL
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    access             = rw
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainC
            }
        }
    }
}

#
#DomainD View
#

domainD = { [ use MANAGED-OBJECT ]
    mediumDesc        =  domainD
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domainD

    slots = { [ use MANAGED-OBJECT ]
	mediumDesc        =  slots
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots
       
        originalTables = { [ use MANAGED-OBJECT ]
            mediumDesc        =  originalTables
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables
	    consoleHint:hidden = true
	    slotTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  slotTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotChassisIndex
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotIndex
		    }
		    slotTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotTestStatus
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotPowerStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotStatus
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.slotTable.slotEntry.slotName
		    }
	
		}
	    }
	    cpuBoardTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBoardTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry
		    index = cpuBoardChassisIndex cpuBoardIndex 
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardChassisIndex
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex
		    }
		    cpuBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardFruIndex
		    }
		    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalCPU
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalCPU
		    }
		    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalDramMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalDramMEM
		    }
		    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalEcacheMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
		    }
		    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTotalWCI
		    }
		    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTemp
		    }


		}
	    }
	    ioBoardTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBoardTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry
		    index = ioBoardChassisIndex ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardChassisIndex
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex
		    }
		    ioBoardTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardFruIndex
		    }
		    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType
		    }
		    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalWCI
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalWCI
		    }
		    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTotalParoliCpciDca
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTotalParoliCpciDca
		    }
		    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTemp
		    }


		}
	    }

        }
	emptySlots = { [use MANAGED-OBJECT ]
	    mediumDesc        =  emptySlots
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots
	    emptySlotTable = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  emptySlotTable
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable 
		slotEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  slotEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry
		    index = slotChassisIndex  slotIndex
		    
	      
		    slotChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotChassisIndex
                        consoleHint:hidden = true
		    }
		    slotIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  slotIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotIndex
                        consoleHint:hidden = true
		    }
		    slotName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotName
		    }
		    slotPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotPowerStatus
		    }
		    slotBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotBoardType
		    }
		    slotState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotState
		    }
		    slotTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotTestStatus
		    }
		    slotDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  slotDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:platform.slots.emptySlots.emptySlotTable.slotEntry.slotStatus
		    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_empty
		}
	    }
	}
       
	cpuBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  cpuBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards
	    cpuBrdTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuBrdTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable 
		cpuBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry
		    index = cpuBoardChassisIndex  cpuBoardIndex
		    
	      
		    cpuBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex
                        consoleHint:hidden = true
		    }
		    cpuBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName
		    }
		    cpuBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardPowerStatus
		    }
		    cpuBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardBoardType
		    }
		    cpuBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardState
		    }
		    cpuBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTestStatus
		    }
		    cpuBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.slotStatus
		    }
                    cpuBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardFruIndex
                    }
                    cpuBoardTotalCPU = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalCPU
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalCPU
                    }
                    cpuBoardTotalDramMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalDramMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalDramMEM
                    }
                    cpuBoardTotalEcacheMEM = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalEcacheMEM
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalEcacheMEM
                    }
                    cpuBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTotalWCI
                    }
                    cpuBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  cpuBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardTemp
                    }
		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_cpu
		}
	    }
	}
	ioBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  ioBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards
	    ioBrdTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ioBrdTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable 
		ioBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ioBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry
		    index = ioBoardChassisIndex  ioBoardIndex
		    
	      
		    ioBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    ioBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex
                        consoleHint:hidden = true
		    }
		    ioBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName
		    }
		    ioBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardPowerStatus
		    }
		    ioBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardBoardType
		    }
		    ioBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardState
		    }
		    ioBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTestStatus
		    }
		    ioBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ioBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.slotStatus
		    }
                    ioBoardFruIndex = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardFruIndex
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardFruIndex
                    }
                    ioBoardType = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardType
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardType
                    }
                    ioBoardTotalWCI = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalWCI
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalWCI
                    }
                    ioBoardTotalParoliCpciDca = { [ use INT MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTotalParoliCpciDca
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTotalParoliCpciDca
                    }
                    ioBoardTemp = { [ use STRING MANAGED-PROPERTY ]
                        mediumDesc        =  ioBoardTemp
                        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardTemp
                    }


		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }
	
		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_io
		}
	    }
	}
	unknownBoards = { [use MANAGED-OBJECT ]
	    mediumDesc        =  unknownBoards
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards
	    unknownBrdTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  unknownBrdTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable 
		unknownBoardEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  unknownBoardEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry
		    index = unknownBoardChassisIndex  unknownBoardIndex
		    
	      
		    unknownBoardChassisIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardChassisIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardChassisIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardIndex
                        consoleHint:hidden = true
		    }
		    unknownBoardName = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardName
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardName
		    }
		    unknownBoardPowerStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardPowerStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardPowerStatus
		    }
		    unknownBoardBoardType = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardBoardType
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardBoardType
		    }
		    unknownBoardState = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardState
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardState
		    }
		    unknownBoardTestStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardTestStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardTestStatus
		    }
		    unknownBoardDomain = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  unknownBoardDomain
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.unknownBoardDomain
		    }
		    slotStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  slotStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.slots.unknownBoards.unknownBrdTable.unknownBoardEntry.slotStatus
		    }

		    CmdNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdNode
			consoleHint:hidden = true
		    }
		    CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  CmdStatusNode
			consoleHint:hidden = true
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.domainAdmin.CaPlatformAdmin domainD_unknown
		}
	    }
	}
    }

    fru = { [ use MANAGED-OBJECT ]
	mediumDesc        =  fru
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru
	consoleHint:hidden = true
	fruTableD = { [ use MANAGED-OBJECT-TABLE ]
	    mediumDesc        =  fruTableD
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable 
	    fruEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		mediumDesc        =  fruEntry
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry
		index = fruIndex
		
	  
		fruIndex = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruIndex
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruIndex
		}
		fruDescr = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruDescr
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruDescr
		}
		fruType = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruType
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruType
		}
		fruManufactureDate = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureDate
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureDate
		}
		fruManufactureLocation = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruManufactureLocation
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruManufactureLocation
		}
		fruPartNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruPartNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruPartNumber
		}
		fruSerialNumber = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruSerialNumber
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSerialNumber
		}
		fruVendorName = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruVendorName
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruVendorName
		}
		fruInitHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwDashLevel
		}
		fruInitHwRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruInitHwRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruInitHwRevLevel
		}
		fruSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSpeed
		}
		fruSize = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruSize
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruSize
		}
		fruBoardSpeed = { [ use INT MANAGED-PROPERTY ]
		    mediumDesc        =  fruBoardSpeed
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBoardSpeed
		}
		fruBootbusTiming = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruBootbusTiming
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruBootbusTiming
		}
		fruNoUpdates = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruNoUpdates
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruNoUpdates
		}
		fruLastPowerOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruLastPowerOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruLastPowerOn
		}
		fruTotalErrors = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalErrors
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalErrors
		}
		fruTotalInserts = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalInserts
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalInserts
		}
		fruTotalPowerOns = { [ use COUNTER MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalPowerOns
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalPowerOns
		}
		fruTotalTimeOn = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruTotalTimeOn
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruTotalTimeOn
		}
		fruHwDashLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruHwDashLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruHwDashLevel
		}
		fruRevLevel = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  fruRevLevel
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.fru.fruTable.fruEntry.fruRevLevel
		}
    
	    }
	}
    }
    components = { [ use MANAGED-OBJECT ]
        mediumDesc        =  components
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components


        cpuMod = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  cpuMod
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod
	    cpuModTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  cpuModTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable 
		cpuModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  cpuModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry
		    index = cpuModBoardIndex cpuModIndex
		    
	      
		    cpuModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex
		    }
		    cpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex
		    }
		    cpuModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDescr
		    }
		    cpuModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    cpuModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModTemp
		    }
		    cpuModStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
			mediumDesc        =  cpuModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModStatus
		    }
		    cpuModModel = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  cpuModModel
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModModel
		    }
		    cpuModSpeed = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModSpeed
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModSpeed
		    }
		    cpuModIcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModIcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModIcacheSize
		    }
		    cpuModDcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModDcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModDcacheSize
		    }
		    cpuModEcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModEcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModEcacheSize
		    }
		    cpuModWcacheSize = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  cpuModWcacheSize
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModWcacheSize
		    }
		    cpuModLastChange = { [ use TIMETICKS MANAGED-PROPERTY ]
			mediumDesc        =  cpuModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModLastChange
		    }
		    cpuModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  cpuModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.cpuMod.cpuModTable.cpuModEntry.cpuModErrors
		    }

		}
	    }
        }




        dimm = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  dimm
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm
	    dimmTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  dimmTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable 
		dimmEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  dimmEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry
		    index = dimmCpuBoardIndex dimmCpuModIndex dimmIndex
		    
	      
		    dimmCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex
		    }
		    dimmCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex
		    }
		    dimmIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmIndex
		    }
		    dimmTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  dimmTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    dimmFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  dimmFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.dimm.dimmTable.dimmEntry.dimmFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_dimm
		}
	    }
        }



        ecache  = { [ use MANAGED-OBJECT ] 
	    mediumDesc        =  ecache
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache
	    ecacheTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  ecacheTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable 
		ecacheEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  ecacheEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry
		    index = ecacheCpuBoardIndex ecacheCpuModIndex ecacheIndex
		    
	      
		    ecacheCpuBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex
		    }
		    ecacheCpuModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheCpuModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex
		    }
		    ecacheIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheIndex
		    }
		    ecacheTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  ecacheTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    ecacheFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  ecacheFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.ecache.ecacheTable.ecacheEntry.ecacheFruIndex
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_ecache
		}
	    }
        }

        wci = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wci
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci
	    wciModTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciModTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable 
		wciModEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciModEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry
		    index = wciModBoardIndex wciModIndex
		    
	      
		    wciModBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModBoardIndex
		    }
		    wciModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModIndex
		    }
		    wciModDescr = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModDescr
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModDescr
		    }
		    wciModTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciModStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModStatus
		    }
		    wciModMode = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModMode
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModMode
		    }
		    wciModTemp = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciModTemp
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTemp
		    }
		    wciModTotalDIMM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalDIMM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalDIMM
		    }
		    wciModTotalMEM = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalMEM
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalMEM
		    }
		    wciModTotalParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalParoliDCA
		    }
		    wciModTotalPort = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciModTotalPort
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModTotalPort
		    }
		    wciModLastChange = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModLastChange
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModLastChange
		    }
		    wciModErrors = { [ use COUNTER MANAGED-PROPERTY ]
			mediumDesc        =  wciModErrors
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wci.wciModTable.wciModEntry.wciModErrors
		    }

		}
	    }
        }




        wciPort = { [ use MANAGED-OBJECT ]
	    mediumDesc        =  wciPort
	    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort
	    wciPortTableD = { [ use MANAGED-OBJECT-TABLE ]
		mediumDesc        =  wciPortTableD
		consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable 
		wciPortEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		    mediumDesc        =  wciPortEntry
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry
		    index = wciPortBoardIndex wciPortModIndex wciPortIndex
		    
	      
		    wciPortBoardIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortBoardIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex
		    }
		    wciPortModIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortModIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortModIndex
		    }
		    wciPortIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex
		    }
		    wciPortTreeNodeInfo = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortTreeNodeInfo
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo
                        consoleHint:hidden = true
		    }
		    wciPortFruIndex = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortFruIndex
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortFruIndex
		    }
		    wciPortStatus = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortStatus
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortStatus
		    }
		    wciPortParoliDCA = { [ use INT MANAGED-PROPERTY ]
			mediumDesc        =  wciPortParoliDCA
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortParoliDCA
		    }
		    wciPortRemoteLoc = { [ use STRING MANAGED-PROPERTY ]
			mediumDesc        =  wciPortRemoteLoc
			consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.components.wciPort.wciPortTable.wciPortEntry.wciPortRemoteLoc
		    }

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD_wciPort
		}
	    }
        }

    }


    domains = { [use MANAGED-OBJECT ]
        mediumDesc        =  domains
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains

        domainTableD = { [ use MANAGED-OBJECT-TABLE ]
            mediumDesc = Domain Table
            consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable
            domainEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
                mediumDesc = Domain Table Entry
                consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry
                index = domainIndex

                domainIndex = { [ use INT MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainIndex
                    consoleHint:hidden = true
                }
                domainDomain = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDomain
                }
                domainDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainDescr
                }
#                domainPublicCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPublicCommunity
#                    consoleHint:hidden = true
#                }
#                domainPrivateCommunity = { [ use STRINGRULE MANAGED-PROPERTY ]
#                    mediumDesc  = Domain Index
#                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainPrivateCommunity
#                    consoleHint:hidden = true
#                }
                domainLogHost = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainLogHost
                }
                domainTrapHosts = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainTrapHosts
                }
                domainACLDescr = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainACLDescr
                }
                domainStatus = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainStatus
                }
                domainNodeName = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainNodeName
                }
                domainSsmMode = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMode
                }
                domainSsmMaster = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmMaster
                }
                domainSsmSlaveNodes = { [ use STRING MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainSsmSlaveNodes
                }
                domainKeySwitch = { [ use STRINGRULE MANAGED-PROPERTY ]
                    mediumDesc  = Domain Index
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainKeySwitch
                }
		domainContact = { [ use STRING MANAGED-PROPERTY ]
		    mediumDesc        =  domainContact
		    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.domainContact
		}
                snmpAgentPort = { [ use INT MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = snmpAgentPort
                    consoleHint:hidden = true
                }
                slotsNotInACL = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    mediumDesc  = slotsNotInACL
                    consoleHint:mediumDesc = base.modules.serengeti-platadmin:domain.domains.domainTable.domainEntry.slotsNotInACL
                }
		CmdNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
		    mediumDesc        =  CmdNode
		    consoleHint:hidden = true
		}
		CmdStatusNode = { [ use STRING MANAGED-PROPERTY ]
                    type        = active
                    access             = rw
		    mediumDesc        =  CmdStatusNode
		    consoleHint:hidden = true
		}

		# change argument if models file is changed.
		consoleHint:tableMenuGenerator = com.sun.symon.apps.admin.platformAdmin.CaPlatformAdmin domainD
            }
        }
    }
}

#
#Rule Nodes
#

rules = { [ use MANAGED-OBJECT ]
    mediumDesc = rules
    consoleHint:mediumDesc = base.modules.serengeti-platadmin:rules

    rspa1001 = { [ use STRINGRULE MANAGED-PROPERTY ]
	mediumDesc        =  rspa1001
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:rules.rspa1001
    }

    rspa1004 = { [ use STRINGRULE MANAGED-PROPERTY ]
	mediumDesc        =  rspa1004
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:rules.rspa1004
    }

    rspa1005 = { [ use STRINGRULE MANAGED-PROPERTY ]
	mediumDesc        =  rspa1005
	consoleHint:mediumDesc = base.modules.serengeti-platadmin:rules.rspa1005
    }
    rspa1007 = { [ use INTRULE MANAGED-PROPERTY ]
        mediumDesc        =  rspa1007
        consoleHint:mediumDesc = base.modules.serengeti-platadmin:rules.rspa1007
    }

}

[load serengeti-platadmin-ruletext-d.x ]
[load serengeti-platadmin-ruleinit-d.x ]

