/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Enumerated;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlPage;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

class HtmlObjectPage
extends HtmlPage
implements Serializable {
    private MBeanAttributeInfo[] attinfo = null;
    private String[] propertyName = null;
    private String[] propertyView = null;
    private ObjectName manipulatedObjName = null;
    private MBeanInfo manipulatedObj = null;
    private String meta = null;
    private int autoRefresh = 0;
    private final int minAutoRefresh = 5;
    private HtmlAdaptorServer server = null;

    public HtmlObjectPage(MBeanServer mBeanServer, boolean bl, boolean bl2, HtmlAdaptorServer htmlAdaptorServer) {
        super(mBeanServer, bl, bl2);
        this.server = htmlAdaptorServer;
    }

    private boolean analyseObj(String string) {
        if (this.isTraceOn()) {
            this.trace("analyseObj", "Collect MBean information for = " + string);
        }
        String string2 = this.translateNameToHtmlFormat(string);
        try {
            this.manipulatedObjName = this.getObjectNameByObjNameStr(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (this.isDebugOn()) {
                this.debug("analyseObj", "Exception = " + malformedObjectNameException);
            }
            this.buildError("The format of the string [" + string2 + "] does not correspond to a valid ObjectName <P>" + malformedObjectNameException.toString() + "<P>", "474 Malformed ObjectName");
            return false;
        }
        if (this.manipulatedObjName != null) {
            try {
                this.manipulatedObj = this.mbs.getMBeanInfo(this.manipulatedObjName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("analyseObj", "Exception = " + instanceNotFoundException);
                }
                this.buildError("Unable to get MBeanInfo for [" + string2 + "]", "459 Instance Not Found");
                return false;
            }
            catch (IntrospectionException introspectionException) {
                if (this.isDebugOn()) {
                    this.debug("analyseObj", "Exception = " + introspectionException);
                }
                this.buildError("Unable to get MBeanInfo for [" + string2 + "]", "476 Introspection");
                return false;
            }
            catch (ReflectionException reflectionException) {
                if (this.isDebugOn()) {
                    this.debug("analyseObj", "Exception = " + reflectionException);
                }
                this.buildError("Unable to get MBeanInfo for [" + string2 + "]", "470 Reflection");
                return false;
            }
        }
        if (this.manipulatedObj == null) {
            this.buildError("Unable to get MBeanInfo for [" + this.manipulatedObjName + "]", "459 Instance Not Found");
            return false;
        }
        this.attinfo = this.manipulatedObj.getAttributes();
        this.propertyName = new String[this.attinfo.length];
        this.propertyView = new String[this.attinfo.length];
        int n = this.propertyName.length - 1;
        while (n >= 0) {
            this.propertyName[n] = this.attinfo[n].getName();
            --n;
        }
        this.quicksort(this.propertyName, 0, this.propertyName.length - 1);
        int n2 = this.propertyName.length - 1;
        while (n2 >= 0) {
            this.propertyView[n2] = this.getStringValue(this.manipulatedObjName, this.attinfo[n2]);
            if (this.isTraceOn()) {
                this.trace("analyseObj", "MBean attribute: " + this.propertyName[n2] + "=" + this.propertyView[n2]);
            }
            --n2;
        }
        return true;
    }

    private String buildArrayRef(String string, String string2, String string3) {
        return new String("<TD> <A HREF=\"/ViewProperty/" + string + this.toUrlName(string2) + "\">" + string3 + "</A> </TD>");
    }

    private void buildAttributes(String string) {
        String string2;
        if (this.isTraceOn()) {
            this.trace("buildAttributes", "Build attribute part for = " + string);
        }
        if ((string2 = this.manipulatedObj.getDescription()) != null && string2.length() > 0) {
            this.add2Page("<HR><H3>MBean description:</H3><P>" + string2 + "<P>");
        }
        this.add2Page("<HR><H3> List of MBean attributes:</H3>");
        if (this.isTraceOn()) {
            this.trace("buildAttributes", "Found " + this.attinfo.length + " attributes(s)");
        }
        if (this.attinfo.length == 0) {
            return;
        }
        this.add2Page("<FORM ACTION=/SetForm" + this.toUrlName(string) + " METHOD=GET>");
        boolean bl = false;
        this.add2Page("<TABLE ALIGN=center BORDER=1 WIDTH=100% CELLPADDING=3>");
        this.add2Page("<TR>");
        this.add2Page("<TH WIDTH=23%> Name </TH><TH WIDTH=35%> Type </TH><TH WIDTH=7%> Access </TH><TH WIDTH=35%> Value </TH>");
        this.add2Page("</TR>");
        int n = 0;
        while (n < this.propertyName.length) {
            if (this.propertyName[n] != null) {
                String string3 = this.usualType(this.attinfo[n].getType());
                this.add2Page("<TR>");
                String string4 = this.attinfo[n].getDescription();
                if (string4 != null && string4.length() > 0) {
                    this.add2Page("<TD><A HREF=\"javascript:alert('" + string4 + "');\"><B>" + this.propertyName[n] + "</B></A></TD>");
                } else {
                    this.add2Page("<TD><B>" + this.propertyName[n] + "</B></TD>");
                }
                this.add2Page("<TD ALIGN=RIGHT>" + string3 + "</TD>");
                if (this.attinfo[n].isReadable() && !this.attinfo[n].isWritable()) {
                    this.add2Page("<TD ALIGN=center> RO </TD>");
                    if (this.propertyView[n].startsWith("Enumerated")) {
                        this.add2Page("<TD>" + this.propertyView[n].substring(10) + "</TD>");
                    } else if (this.propertyView[n].startsWith("<FONT color=red>UNAVAILABLE</FONT>")) {
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else if (string3.equals("javax.management.ObjectName")) {
                        this.propertyView[n] = "<A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[n]) + "\">" + this.propertyView[n] + "</A>";
                    } else if (this.isArrayType(string3)) {
                        this.add2Page(this.buildArrayRef(this.propertyName[n], string, "view the values of " + this.propertyName[n]));
                    } else if (!this.checkType(string3)) {
                        this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(this.propertyView[n]) + "]</TD>");
                    } else {
                        this.add2Page("<TD>" + this.translateNameToHtmlFormat(this.propertyView[n]) + "</TD>");
                    }
                } else if (!this.attinfo[n].isReadable() && this.attinfo[n].isWritable()) {
                    bl = true;
                    this.add2Page("<TD ALIGN=center> WO </TD>");
                    if (this.propertyView[n].startsWith("<SELECT NAME=\"(Enumerated)")) {
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else if (!this.checkType(string3)) {
                        this.add2Page("<TD><I>Type Not Supported</I></TD>");
                    } else if (string3.endsWith("Boolean") || string3.endsWith("boolean")) {
                        this.add2Page("<TD>" + this.boolToHtml(this.propertyName[n], string3, this.propertyView[n], false) + "</TD>");
                    } else if (this.isArrayType(string3)) {
                        if (!this.checkType(string3)) {
                            this.propertyView[n] = new String("Write only for " + this.propertyName[n] + "[] Not supported ");
                        }
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else {
                        this.add2Page("<TD><INPUT TYPE=\"text\" NAME=\"" + this.propertyName[n] + "+" + string3 + "\" SIZE=34%></TD>");
                    }
                } else if (this.attinfo[n].isReadable() && this.attinfo[n].isWritable()) {
                    bl = true;
                    this.add2Page("<TD ALIGN=center> RW </TD>");
                    if (this.propertyView[n].startsWith("<SELECT NAME=\"(Enumerated)")) {
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else if (this.propertyView[n].startsWith("<FONT color=red>UNAVAILABLE</FONT>")) {
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else if (!this.checkType(string3)) {
                        this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(this.propertyView[n]) + "]</TD>");
                    } else if (this.propertyView[n].startsWith("<SELECT NAME=\"(Enumerated)")) {
                        this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                    } else if (string3.endsWith("Boolean") || string3.endsWith("boolean")) {
                        this.add2Page("<TD>" + this.boolToHtml(this.propertyName[n], string3, this.propertyView[n], true) + "</TD>");
                    } else if (this.isArrayType(string3)) {
                        this.add2Page(this.buildArrayRef(this.propertyName[n], string, "view the values of " + this.propertyName[n]));
                    } else {
                        this.htmlPage.append("<TD><INPUT TYPE=\"text\" NAME=\"" + this.propertyName[n] + "+" + string3 + "\" ");
                        this.htmlPage.append("VALUE=\"" + this.translateNameToHtmlFormat(this.propertyView[n]) + "\" ");
                        this.htmlPage.append("SIZE=34%");
                        this.add2Page(">");
                        if (string3.equals("javax.management.ObjectName")) {
                            if (this.propertyView[n].equals(" ") || this.propertyView[n].equals("")) {
                                this.htmlPage.append("<A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[n]) + "\"></A>");
                            } else {
                                this.htmlPage.append("<A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[n]) + "\">view</A>");
                            }
                        }
                        this.add2Page("</TD>");
                    }
                } else {
                    this.add2Page("<TD> ?? </TD>");
                    this.add2Page("<TD>" + this.propertyView[n] + "</TD>");
                }
                this.add2Page("</TR>");
            }
            ++n;
        }
        this.add2Page("</TABLE>");
        this.add2Page("<P>");
        this.add2Page("<TABLE WIDTH=100%><TR>");
        if (bl) {
            this.add2Page("<TD ALIGN=LEFT><INPUT TYPE=submit VALUE=\"Apply\"></TD>");
        } else {
            this.add2Page("<TD ALIGN=LEFT></TD>");
        }
        this.add2Page("</TR></TABLE></FORM>");
    }

    public void buildMeta(String string) {
        String string2 = string.substring(0, string.indexOf("?"));
        try {
            this.autoRefresh = Integer.parseInt(string.substring(string.indexOf("period=") + 7));
        }
        catch (NumberFormatException numberFormatException) {
            this.autoRefresh = 5;
        }
        if (this.autoRefresh == 0) {
            this.meta = " ";
        } else {
            if (this.autoRefresh < 5) {
                this.autoRefresh = 5;
            }
            this.meta = "<META HTTP-EQUIV=REFRESH CONTENT=\"";
            this.meta = String.valueOf(this.meta) + this.autoRefresh + "; URL=" + "/AutoRefresh" + string + "\">";
        }
    }

    private String buildOperationWithParam(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray) {
        if (this.isTraceOn()) {
            this.trace("buildOperationWithParam", "Build operation for = " + string2);
        }
        boolean bl = true;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            string3 = mBeanParameterInfoArray[n2].getType();
            if (!this.checkType(string3) || this.isArrayType(string3)) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (!bl) {
            stringBuffer.append("  <I>(Operation Not Supported)</I><P>");
        }
        if (bl) {
            stringBuffer.append("<FORM ACTION=/InvokeAction" + this.toUrlName(this.manipulatedObjName.toString()) + "/action=" + string2);
            stringBuffer.append(" METHOD=GET>\r\n");
        }
        stringBuffer.append("<TABLE>\r\n");
        stringBuffer.append("<TR><TD>" + string + "</TD>" + "\r\n");
        if (!bl) {
            stringBuffer.append("<TD>" + string2 + "</TD>" + "\r\n");
        } else {
            stringBuffer.append("<TD><INPUT TYPE=SUBMIT NAME=\"action\" VALUE=\"" + string2 + "\"></TD>" + "\r\n");
        }
        int n3 = 0;
        while (n3 < n) {
            String string5;
            string3 = mBeanParameterInfoArray[n3].getType();
            string4 = mBeanParameterInfoArray[n3].getName().length() > 0 ? mBeanParameterInfoArray[n3].getName() : new String("param" + n3);
            if (n3 != 0) {
                stringBuffer.append("<TD></TD>");
            }
            if ((string5 = mBeanParameterInfoArray[n3].getDescription()) != null && string5.length() > 0) {
                stringBuffer.append("<TD>(" + string3 + ")<A HREF=\"javascript:alert('" + string5 + "');\">" + string4 + "</A></TD>" + "\r\n");
            } else {
                stringBuffer.append("<TD>(" + string3 + ")" + string4 + "</TD>" + "\r\n");
            }
            if (!bl) {
                stringBuffer.append("<TD></TD>\r\n");
            } else if (string3.endsWith("Boolean") || string3.endsWith("boolean")) {
                stringBuffer.append("<TD>" + this.boolToHtml(string4, string3, "true", true) + "</TD>" + "\r\n");
            } else {
                stringBuffer.append("<TD><INPUT TYPE=\"text\" NAME=\"" + string4 + "+" + string3 + "\" ");
                stringBuffer.append("SIZE=50%");
                stringBuffer.append("></TD>\r\n");
            }
            stringBuffer.append("</TR><TR><TD></TD>\r\n");
            ++n3;
        }
        stringBuffer.append("</TR></TABLE>\r\n");
        if (bl) {
            stringBuffer.append("</FORM>\r\n");
        }
        return stringBuffer.toString();
    }

    private void buildOperations() {
        if (this.isTraceOn()) {
            this.trace("buildOperations", "Build operations part");
        }
        String string = null;
        String string2 = null;
        MBeanOperationInfo[] mBeanOperationInfoArray = this.manipulatedObj.getOperations();
        if (mBeanOperationInfoArray.length > 0) {
            if (this.isTraceOn()) {
                this.trace("buildOperations", "Found " + mBeanOperationInfoArray.length + " operation(s)");
            }
            this.add2Page("<HR>");
            this.add2Page("<P><H3> List of MBean operations:</H3>\r\n");
            int n = mBeanOperationInfoArray.length - 1;
            while (n >= 0) {
                string2 = mBeanOperationInfoArray[n].getDescription();
                string = this.buildOperationWithParam(mBeanOperationInfoArray[n].getReturnType(), mBeanOperationInfoArray[n].getName(), mBeanOperationInfoArray[n].getSignature());
                if (string != null) {
                    if (string2 != null && string2.length() > 0) {
                        this.add2Page("<HR><A HREF=\"javascript:alert('" + string2 + "');\"><B>Description of " + mBeanOperationInfoArray[n].getName() + "</B></A>");
                    } else {
                        this.add2Page("<HR><B>" + mBeanOperationInfoArray[n].getName() + "</B>");
                    }
                    this.add2Page(string);
                }
                --n;
            }
        }
    }

    public void buildPage(String string) {
        if (this.isTraceOn()) {
            this.trace("buildPage", "Handle request = " + string);
        }
        String string2 = string;
        int n = string.indexOf("?");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        if (!this.analyseObj(string2 = this.fromUrlName(string2))) {
            return;
        }
        if (!this.startPage(string2)) {
            return;
        }
        this.buildAttributes(string2);
        this.buildOperations();
        this.endPage();
    }

    private void debug(String string, String string2) {
        super.debug("HtmlObjectPage", string, string2);
    }

    public void endPage() {
        if (this.isTraceOn()) {
            this.trace("endPage", "End the object(MBean) page.");
        }
        this.add2Page(this.stopBody());
    }

    protected String enumToHtml(Enumerated enumerated, MBeanAttributeInfo mBeanAttributeInfo) {
        boolean bl;
        boolean bl2;
        String string;
        String string2;
        block15: {
            if (mBeanAttributeInfo == null) {
                if (this.isDebugOn()) {
                    this.debug("enumToHtml", "Got null MBeanAttributeInfo parameter. Returning empty string");
                }
                return "";
            }
            string2 = mBeanAttributeInfo.getName();
            string = mBeanAttributeInfo.getType();
            bl2 = mBeanAttributeInfo.isReadable();
            bl = mBeanAttributeInfo.isWritable();
            if (enumerated == null) {
                if (this.isDebugOn()) {
                    this.debug("enumToHtml", "Got null Enumerated object for [" + string2 + "]. attrInfo says [READ=" + bl2 + ",WRITE=" + bl + "]");
                }
                bl2 = false;
                if (bl) {
                    try {
                        enumerated = (Enumerated)Class.forName(string).newInstance();
                    }
                    catch (Exception exception) {
                        bl = false;
                        if (!this.isDebugOn()) break block15;
                        this.debug("enumToHtml", "Could not create instance of [" + string + "] : " + exception);
                    }
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        String string3 = new String();
        if (bl) {
            stringBuffer.append("<SELECT NAME=\"");
            stringBuffer.append("(Enumerated)" + string2 + "+" + string + "\" >");
            if (!bl2) {
                stringBuffer.append("<OPTION SELECTED>---");
            }
            Enumeration enumeration = enumerated.valueStrings();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                stringBuffer.append("<OPTION");
                if (bl2 && enumerated.toString() != null && enumerated.toString().equals(string3)) {
                    stringBuffer.append(" SELECTED ");
                }
                stringBuffer.append(">" + string3);
            }
            stringBuffer.append("</SELECT>");
        } else if (bl2) {
            stringBuffer.append("Enumerated" + enumerated.toString());
        } else if (this.isDebugOn()) {
            this.debug("enumToHtml", "Attribute is unreadable and unwritable. Returning empty string");
        }
        return stringBuffer.toString();
    }

    private Object getArray(String string, ArrayList arrayList) {
        Object[] objectArray = null;
        int n = arrayList.size();
        if (string.endsWith("String")) {
            objectArray = arrayList.toArray(new String[n]);
        } else if (string.endsWith("Byte")) {
            objectArray = arrayList.toArray(new Byte[n]);
        } else if (string.endsWith("byte")) {
            objectArray = new byte[n];
            int n2 = n - 1;
            while (n2 >= 0) {
                ((byte[])objectArray)[n2] = (Byte)arrayList.get(n2);
                --n2;
            }
        } else if (string.endsWith("Long")) {
            objectArray = arrayList.toArray(new Long[n]);
        } else if (string.endsWith("long")) {
            objectArray = new long[n];
            int n3 = n - 1;
            while (n3 >= 0) {
                ((long[])objectArray)[n3] = (Long)arrayList.get(n3);
                --n3;
            }
        } else if (string.endsWith("Integer")) {
            objectArray = arrayList.toArray(new Integer[n]);
        } else if (string.endsWith("int")) {
            objectArray = new int[n];
            int n4 = n - 1;
            while (n4 >= 0) {
                ((int[])objectArray)[n4] = (Integer)arrayList.get(n4);
                --n4;
            }
        } else if (string.endsWith("Date")) {
            objectArray = arrayList.toArray(new Date[n]);
        } else if (string.endsWith("Boolean")) {
            objectArray = arrayList.toArray(new Boolean[n]);
        } else if (string.endsWith("boolean")) {
            objectArray = new boolean[n];
            int n5 = n - 1;
            while (n5 >= 0) {
                ((boolean[])objectArray)[n5] = (Boolean)arrayList.get(n5);
                --n5;
            }
        } else if (string.equals("javax.management.ObjectName")) {
            objectArray = arrayList.toArray(new ObjectName[n]);
        } else if (string.equals("Character")) {
            objectArray = arrayList.toArray(new Character[n]);
        } else if (string.equals("char")) {
            objectArray = new char[n];
            int n6 = n - 1;
            while (n6 >= 0) {
                ((char[])objectArray)[n6] = ((Character)arrayList.get(n6)).charValue();
                --n6;
            }
        } else if (string.equals("Double")) {
            objectArray = arrayList.toArray(new Double[n]);
        } else if (string.equals("double")) {
            objectArray = new double[n];
            int n7 = n - 1;
            while (n7 >= 0) {
                ((double[])objectArray)[n7] = (Double)arrayList.get(n7);
                --n7;
            }
        } else if (string.equals("Float")) {
            objectArray = arrayList.toArray(new Float[n]);
        } else if (string.equals("float")) {
            objectArray = new float[n];
            int n8 = n - 1;
            while (n8 >= 0) {
                ((float[])objectArray)[n8] = ((Float)arrayList.get(n8)).floatValue();
                --n8;
            }
        } else {
            return null;
        }
        return objectArray;
    }

    public String getMeta() {
        return this.meta;
    }

    private String getStringValue(ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
        Object object;
        block14: {
            object = null;
            boolean bl = mBeanAttributeInfo.isReadable();
            boolean bl2 = mBeanAttributeInfo.isWritable();
            try {
                if (this.isTraceOn()) {
                    this.trace("getStringValue", "Build displayable value for attribute [" + mBeanAttributeInfo.getName() + "] of object [" + objectName.toString() + "]");
                }
                if (bl) {
                    object = this.mbs.getAttribute(objectName, mBeanAttributeInfo.getName());
                }
            }
            catch (Exception exception) {
                Exception exception2 = null;
                if (exception instanceof RuntimeMBeanException) {
                    exception2 = ((RuntimeMBeanException)exception).getTargetException();
                } else if (exception instanceof MBeanException) {
                    exception2 = ((MBeanException)exception).getTargetException();
                }
                if (this.isDebugOn()) {
                    this.debug("getStringValue", "Cannot get value: " + exception + " [wrapped exception: " + exception2 + "]");
                }
                if (exception2 == null) {
                    return "<FONT color=red>UNAVAILABLE</FONT>: [" + exception.toString() + "]";
                }
                return "<FONT color=red>UNAVAILABLE</FONT>: " + exception.getClass().getName() + " wraps [" + exception2.toString() + "]";
            }
            if (object instanceof Date) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
                dateFormat.setTimeZone(TimeZone.getDefault());
                return dateFormat.format((Date)object);
            }
            try {
                Class<?> clazz = object != null ? object.getClass() : Class.forName(mBeanAttributeInfo.getType());
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 != null && Class.forName("com.sun.jdmk.Enumerated").isAssignableFrom(clazz2)) {
                    return this.enumToHtml((Enumerated)object, mBeanAttributeInfo);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.isDebugOn()) break block14;
                this.debug("getStringValue", "Cannot find class " + mBeanAttributeInfo.getType() + ":" + classNotFoundException);
            }
        }
        if (object == null) {
            return new String("");
        }
        return object.toString();
    }

    protected void inverseS(String[] stringArray, int n, int n2) {
        MBeanAttributeInfo mBeanAttributeInfo = this.attinfo[n];
        this.attinfo[n] = this.attinfo[n2];
        this.attinfo[n2] = mBeanAttributeInfo;
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }

    /*
     * Unable to fully structure code
     */
    public boolean setObjectValue(String var1_1, String var2_2) {
        if (this.isTraceOn()) {
            this.trace("setObjectValue", "[name=" + var1_1 + ", request=" + var2_2 + "]");
        }
        var3_3 = new StringBuffer();
        var4_4 = false;
        var1_1 = this.fromUrlName(var1_1);
        var5_5 = this.translateNameToHtmlFormat(var1_1);
        if (!var2_2.startsWith("?")) {
            this.buildError("Incorrect request form, must start with ?", "400 Bad Request");
            return false;
        }
        var2_2 = var2_2.substring(1);
        var8_6 = null;
        var9_7 = new AttributeList();
        var10_8 = var2_2;
        var11_9 = false;
        var12_10 = null;
        var13_11 = null;
        var15_12 = null;
        try {
            this.manipulatedObjName = this.getObjectNameByObjNameStr(var1_1);
            if (true) ** GOTO lbl134
        }
        catch (MalformedObjectNameException var16_13) {
            if (this.isDebugOn()) {
                this.debug("setObjectValue", "Exception = " + var16_13);
            }
            this.buildError("The format of the string [" + var5_5 + "] does not correspond to a valid ObjectName <P>" + var16_13.toString() + "<P>", "474 Malformed ObjectName");
            return false;
        }
        do {
            block49: {
                block48: {
                    block50: {
                        if ((var6_15 = var2_2.indexOf(38)) < 0) {
                            var10_8 = var2_2;
                            var11_9 = true;
                        } else {
                            var10_8 = var2_2.substring(0, var6_15);
                            var2_2 = var2_2.substring(var6_15 + 1);
                        }
                        var6_15 = var10_8.indexOf(61);
                        if (var6_15 < 0) {
                            var11_9 = true;
                            this.buildError("Syntax error in request [" + var10_8 + "]", "400 Bad Request");
                            return false;
                        }
                        var12_10 = var10_8.substring(0, var6_15);
                        var14_17 = var10_8.substring(var6_15 + 1);
                        if (var14_17 == null || var12_10 == null || var14_17.length() == 0 || var12_10.length() == 0) break block49;
                        while (var12_10.startsWith("%")) {
                            var12_10 = var12_10.substring(3);
                        }
                        var14_17 = this.decodeUrl(var14_17);
                        if (this.isTraceOn()) {
                            this.trace("setObjectValue", "Parsing property name [" + var12_10 + "]");
                        }
                        if ((var6_15 = var12_10.indexOf("%2B", 0)) < 0) {
                            var6_15 = var12_10.indexOf("%2b", 0);
                        }
                        if (var6_15 >= 0) {
                            var13_11 = var12_10.substring(var6_15 + 3);
                            var12_10 = var12_10.substring(0, var6_15);
                        } else {
                            var13_11 = new String("String");
                        }
                        var15_12 = new String("");
                        if (var12_10.indexOf("%5B") > 0) {
                            var15_12 = var12_10.substring(var12_10.indexOf("%5B") + 3, var12_10.indexOf("%5D"));
                            var12_10 = var12_10.substring(0, var12_10.indexOf("%5B"));
                        } else if (var12_10.indexOf("%5b") > 0) {
                            var15_12 = var12_10.substring(var12_10.indexOf("%5b") + 3, var12_10.indexOf("%5d"));
                            var12_10 = var12_10.substring(0, var12_10.indexOf("%5b"));
                        }
                        if (this.isTraceOn()) {
                            this.trace("setObjectValue", "Get Name = [" + var12_10 + "] " + (var15_12.length() > 0 ? "[" + var15_12 + "] " : " ") + "Type = [" + var13_11 + "]" + " Value = [" + var14_17 + "]");
                        }
                        var16_14 = null;
                        if (!var12_10.startsWith("Enumerated%29")) break block50;
                        var12_10 = var12_10.substring(13);
                        if (var14_17.equals("---")) break block48;
                        try {
                            var17_18 = this.mbs.getMBeanInfo(this.manipulatedObjName).getAttributes();
                            var18_25 = 0;
                            var19_27 = 0;
                            if (true) ** GOTO lbl75
                            do {
                                ++var18_25;
lbl75:
                                // 2 sources

                                if (var18_25 >= ((MBeanAttributeInfo[])var17_18).length) break;
                                v0 = var17_18[var18_25].getName().equals(var12_10);
                                var19_27 = (int)v0;
                            } while (!v0);
                            if (var19_27 == 1) {
                                var20_28 = var17_18[var18_25].isReadable() != false ? this.mbs.getAttribute(this.manipulatedObjName, var12_10).getClass() : Class.forName(var13_11);
                                if (this.isTraceOn()) {
                                    this.trace("setObjectValue", "Got Class for Enumerated attribute[" + var12_10 + "] is [" + var20_28.getName() + "]");
                                }
                            } else {
                                throw new AttributeNotFoundException("Could not find attribute [" + var12_10 + "] in MBean [" + this.manipulatedObjName + "]");
                            }
                            var21_31 = var20_28.getSuperclass();
                            if (var21_31 != null && Class.forName("com.sun.jdmk.Enumerated").isAssignableFrom(var21_31)) {
                                var22_32 = var20_28.getDeclaredConstructors();
                                var23_33 = 0;
                                while (var23_33 < var22_32.length) {
                                    var24_34 = var22_32[var23_33].getParameterTypes();
                                    if (var24_34.length == 1 && var24_34[0].getName().endsWith("String")) {
                                        if (this.isTraceOn()) {
                                            this.trace("setObjectValue", "Found constructor for Enumerated = " + var20_28.getName());
                                        }
                                        var25_35 = new Object[]{new String(var14_17)};
                                        var16_14 = var22_32[var23_33].newInstance(var25_35);
                                    }
                                    ++var23_33;
                                }
                                break block48;
                            }
                            this.buildError("Cannot get constructor of " + var13_11 + " for setting " + var12_10 + ": Invalid Enumerated.", "464 Invalid Property Value");
                            return false;
                        }
                        catch (Exception var17_19) {
                            if (this.isDebugOn()) {
                                this.debug("setObjectValue", "Exception = " + var17_19);
                            }
                            this.buildError("Cannot get constructor of " + var13_11 + " for setting " + var12_10 + " of MBean " + this.manipulatedObjName.toString() + "<P>The following exception has been produced:<BR>" + var17_19.toString() + "<P>", "464 Invalid Property Value");
                            return false;
                        }
                    }
                    var16_14 = this.stringToObject(var13_11, var14_17);
                }
                if (var16_14 == null) continue;
                if (var15_12.length() > 0) {
                    if (var8_6 == null) {
                        var8_6 = new ArrayList<Object>();
                    }
                    try {
                        var7_16 = Integer.parseInt(var15_12);
                    }
                    catch (NumberFormatException var17_20) {
                        if (this.isDebugOn()) {
                            this.debug("setObjectValue", "Exception = " + var17_20);
                        }
                        this.buildError("Invalid Index value [" + var15_12 + "] for property [" + var12_10 + "]<P>", "400 Bad Request");
                        return false;
                    }
                    var8_6.add(var7_16, var16_14);
                    if (!this.isTraceOn()) continue;
                    this.trace("setObjectValue", "Add element " + var7_16 + " to arrayList " + var12_10 + " type = " + var16_14.getClass().getName());
                    continue;
                }
                var17_18 = new Attribute(var12_10, var16_14);
                var9_7.add((Attribute)var17_18);
                var7_16 = -1;
                if (!this.isTraceOn()) continue;
                this.trace("setObjectValue", "added [name=" + var17_18.getName() + ",value=" + var17_18.getValue() + ",type=" + var13_11 + "] to list of attributes to set");
                continue;
            }
            if (!this.isTraceOn()) continue;
            this.trace("setObjectValue", "Got null value or property");
lbl134:
            // 8 sources

        } while (!var11_9);
        if (var8_6 != null) {
            var9_7.add(new Attribute(var12_10, this.getArray(var13_11, var8_6)));
        }
        var16_14 = null;
        try {
            var16_14 = this.mbs.setAttributes(this.manipulatedObjName, var9_7);
            if (this.isTraceOn()) {
                this.trace("setObjectValue", "Invoked setAttributes() on " + this.manipulatedObjName + ". Checking result.");
            }
        }
        catch (InstanceNotFoundException var17_21) {
            if (this.isDebugOn()) {
                this.debug("setObjectValue", "Exception = " + var17_21);
            }
            this.buildError("Setting of attributes has produced an exception <P>" + var17_21.toString() + "<P>", "459 Instance Not Found");
            return false;
        }
        catch (ReflectionException var17_22) {
            if (this.isDebugOn()) {
                this.debug("setObjectValue", "Exception = " + var17_22);
            }
            this.buildError("Setting of attributes has produced an exception <P>" + var17_22.toString() + "<P>", "470 Reflection");
            return false;
        }
        catch (JMRuntimeException var17_23) {
            if (this.isDebugOn()) {
                this.debug("setObjectValue", "Exception = " + var17_23);
            }
            this.buildError("The MBeanServer throws a JMRuntimeException when setting attributes for [" + var5_5 + "] :<BR>" + var17_23, "472 MBean Failure");
            return false;
        }
        if (var9_7.size() != var16_14.size()) {
            if (this.isTraceOn()) {
                this.trace("setObjectValue", "Initial Number of attribute to set = " + var9_7.size() + " and effectively set = " + var16_14.size());
            }
            var17_24 = var9_7.size() - var16_14.size();
            var18_26 = String.valueOf(var17_24) + "/" + var9_7.size() + " attribute(s) were not set:<BR><UL>";
            var19_27 = var9_7.size() - 1;
            while (var19_27 >= 0) {
                var20_30 = var16_14.size() - 1;
                while (var20_30 >= 0) {
                    if (((Attribute)var9_7.get(var19_27)).getName().equals(((Attribute)var16_14.get(var20_30)).getName())) break;
                    --var20_30;
                }
                if (var20_30 == -1) {
                    var18_26 = String.valueOf(var18_26) + "<LI>" + ((Attribute)var9_7.get(var19_27)).getName();
                }
                --var19_27;
            }
            var18_26 = String.valueOf(var18_26) + "</UL><HR>";
            this.buildError(var18_26, "477 All Attributes Not Set");
            return false;
        }
        return true;
    }

    public boolean startPage(String string) {
        if (this.isTraceOn()) {
            this.trace("startPage", "Start the object(MBean) page for = " + string);
        }
        String string2 = this.translateNameToHtmlFormat(string);
        if (this.meta != null) {
            this.htmlPage.append(this.buildHeadMeta("MBean View of " + string2, this.meta));
        } else {
            this.htmlPage.append(this.buildHead("MBean View of " + string2));
        }
        this.htmlPage.append(this.startBody(null));
        this.add2Page("<TABLE WIDTH=100%>");
        this.add2Page("<TR>");
        this.add2Page("<TD ALIGN=left><H2>MBean View</H2></TD>");
        this.add2Page("<TD ALIGN=right VALIGN=top>[JDMK4.1/Java2]</TD>");
        this.add2Page("</TR></TABLE>");
        this.add2Page("<UL type=disc><LI><B>MBean Name:</B> " + string2);
        this.add2Page("<LI><B>MBean Java Class:</B> " + this.manipulatedObj.getClassName());
        this.add2Page("</UL>");
        this.add2Page("<TABLE WIDTH=100%><TR>");
        this.add2Page("<TD ALIGN=LEFT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.add2Page("<TD ALIGN=CENTER>");
        this.add2Page("<FORM ACTION=/AutoRefresh" + this.toUrlName(string) + " METHOD=GET>");
        this.add2Page("Reload Period in seconds:<BR><INPUT type=text name=period value=" + this.autoRefresh + " SIZE=2>" + "<INPUT TYPE=submit VALUE=\"Reload\"></FORM></TD>");
        this.add2Page("<TD ALIGN=RIGHT><BR><FORM ACTION=\"/Admin/Objects%%&keysName=" + URLEncoder.encode(this.manipulatedObjName.getKeyPropertyListString()) + "&domainName=" + URLEncoder.encode(this.manipulatedObjName.getDomain()) + "&className=" + URLEncoder.encode(this.manipulatedObj.getClassName()) + "&action=" + "Unregister" + "&\" METHOD=GET>");
        this.add2Page("<FONT SIZE=-1><INPUT type=submit VALUE=\"Unregister\" ></FONT></FORM></TD>");
        this.add2Page("</TR></TABLE>");
        return true;
    }

    private Object stringToObject(String string, String string2) {
        Object object;
        block26: {
            object = null;
            try {
                if (string.endsWith("String")) {
                    object = new String(string2);
                    break block26;
                }
                if (string.endsWith("Byte") || string.endsWith("byte")) {
                    object = new Byte(string2);
                    break block26;
                }
                if (string.endsWith("Long") || string.endsWith("long")) {
                    object = new Long(string2);
                    break block26;
                }
                if (string.endsWith("Integer") || string.endsWith("int")) {
                    object = new Integer(string2);
                    break block26;
                }
                if (string.endsWith("Date")) {
                    try {
                        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
                        dateFormat.setTimeZone(TimeZone.getDefault());
                        object = dateFormat.parse(string2);
                        break block26;
                    }
                    catch (ParseException parseException) {
                        this.buildError("Cannot convert String \"" + string2 + "\" to " + string + ".<P>", "400 Bad Request");
                        return null;
                    }
                }
                if (string.endsWith("Boolean") || string.endsWith("boolean")) {
                    object = new Boolean(string2);
                    break block26;
                }
                if (string.endsWith("Number")) {
                    try {
                        object = new Integer(string2);
                        break block26;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            object = new Long(string2);
                            break block26;
                        }
                        catch (NumberFormatException numberFormatException2) {
                            try {
                                object = new Float(string2);
                                break block26;
                            }
                            catch (NumberFormatException numberFormatException3) {
                                try {
                                    object = new Double(string2);
                                    break block26;
                                }
                                catch (NumberFormatException numberFormatException4) {
                                    this.buildError("Cannot convert String \"" + string2 + "\" to " + string + ".<P>", "400 Bad Request");
                                    return null;
                                }
                            }
                        }
                    }
                }
                if (string.equals("javax.management.ObjectName")) {
                    try {
                        object = new ObjectName(string2);
                        break block26;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        this.buildError("Cannot convert String \"" + string2 + "\" to " + string + ".<P>", "474 Malformed ObjectName");
                        return null;
                    }
                }
                if (string.endsWith("Character") || string.endsWith("char")) {
                    object = new Character(string2.charAt(0));
                    break block26;
                }
                if (string.endsWith("Double") || string.endsWith("double")) {
                    object = new Double(string2);
                    break block26;
                }
                if (string.endsWith("Float") || string.endsWith("float")) {
                    object = new Float(string2);
                    break block26;
                }
                if (string.endsWith("Short") || string.endsWith("short")) {
                    object = new Short(string2);
                    break block26;
                }
                this.buildError("Cannot convert the String \"" + string2 + "\" to " + string, "464 Invalid Property Value");
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                this.buildError("Cannot convert the String \"" + string2 + "\" to " + string + ".<P>", "400 Bad Request");
                return null;
            }
        }
        return object;
    }

    private void trace(String string, String string2) {
        super.trace("HtmlObjectPage", string, string2);
    }
}

