/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpsSocket;

class HttpsNotificationReceiver
extends GenericHttpNotificationReceiver {
    private int timeout = 60000;

    public HttpsNotificationReceiver(GenericHttpConnectorClient genericHttpConnectorClient, ClientNotificationDispatcher clientNotificationDispatcher) {
        super(5, 0, genericHttpConnectorClient, clientNotificationDispatcher);
    }

    GenericHttpSocket createSocket() {
        HttpsSocket httpsSocket = new HttpsSocket();
        httpsSocket.setTimeout(this.getTimeout());
        return httpsSocket;
    }

    public String getProtocol() {
        return "https";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    protected String makeDebugTag() {
        return "HttpsNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void setTimeout(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = n;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(n);
        }
    }
}

