/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeAlarmClock;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number derivedGauge = new Integer(0);
    private transient long derivedGaugeTimestamp = new Date().getTime();
    private transient Number previousScanGauge = null;
    private transient int status = 2;
    private transient int type = 0;
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient GaugeAlarmClock alarmClock = null;

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public Number getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    boolean isFirstGreaterThanLast(Number number, Number number2) {
        boolean bl = false;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (number.longValue() < number2.longValue()) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(number.doubleValue() >= number2.doubleValue())) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return bl;
    }

    boolean isFirstStrictlyGreaterThanLast(Number number, Number number2) {
        boolean bl = false;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (number.longValue() <= number2.longValue()) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(number.doubleValue() > number2.doubleValue())) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
            }
        }
        return bl;
    }

    boolean isThresholdTypeValid() {
        boolean bl = false;
        switch (this.type) {
            case 0: {
                if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                bl = true;
                break;
            }
            case 1: {
                if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                bl = true;
                break;
            }
            case 2: {
                if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                bl = true;
                break;
            }
            case 4: {
                if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                bl = true;
                break;
            }
            case 5: {
                if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isThresholdTypeValid", "the threshold type is invalid");
            }
        }
        return bl;
    }

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    void notifyAlarmClock() {
        block30: {
            Object object = null;
            String string = null;
            try {
                if (!this.isActive()) break block30;
                if (this.getObservedObject() == null || this.getObservedAttribute() == null) {
                    this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                    this.alarmClock.start();
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(), this.getObservedAttribute());
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotified & 1) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.alreadyNotified |= 1;
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (object instanceof Integer) {
                    this.type = 0;
                } else if (object instanceof Byte) {
                    this.type = 1;
                } else if (object instanceof Short) {
                    this.type = 2;
                } else if (object instanceof Long) {
                    this.type = 3;
                } else if (object instanceof Float) {
                    this.type = 4;
                } else if (object instanceof Double) {
                    this.type = 5;
                } else {
                    if ((this.alreadyNotified & 4) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.alreadyNotified |= 4;
                    throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                }
                if (!this.isThresholdTypeValid()) {
                    if ((this.alreadyNotified & 0x10) != 0) {
                        this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.THRESHOLD_ERROR;
                    this.alreadyNotified |= 0x10;
                    throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                }
                this.alreadyNotified = 0;
                boolean bl = this.updateDerivedGauge(object);
                if (bl) {
                    this.updateNotifications();
                }
                this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp, monitorSettingException.getMessage(), this.derivedGauge, null);
                this.status = 2;
                this.previousScanGauge = null;
                this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
        }
    }

    void setDerivedGaugeWithDifference(Number number) {
        switch (this.type) {
            case 0: {
                this.derivedGauge = new Integer((Integer)number - (Integer)this.previousScanGauge);
                break;
            }
            case 1: {
                this.derivedGauge = new Byte((byte)((Byte)number - (Byte)this.previousScanGauge));
                break;
            }
            case 2: {
                this.derivedGauge = new Short((short)((Short)number - (Short)this.previousScanGauge));
                break;
            }
            case 3: {
                this.derivedGauge = new Long((Long)number - (Long)this.previousScanGauge);
                break;
            }
            case 4: {
                this.derivedGauge = new Float(((Float)number).floatValue() - ((Float)this.previousScanGauge).floatValue());
                break;
            }
            case 5: {
                this.derivedGauge = new Double((Double)number - (Double)this.previousScanGauge);
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    public void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        this.status = 2;
        this.previousScanGauge = null;
    }

    public void setNotifyHigh(boolean bl) {
        this.notifyHigh = bl;
    }

    public void setNotifyLow(boolean bl) {
        this.notifyLow = bl;
    }

    public void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number)) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        this.highThreshold = number;
        this.lowThreshold = number2;
        this.alreadyNotified &= 0xFFFFFFEF;
        this.status = 2;
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        if (!this.isActive()) {
            this.alarmClock = new GaugeAlarmClock(this, this.getGranularityPeriod());
            this.alarmClock.start();
            this.isActive = true;
            this.status = 2;
            this.previousScanGauge = null;
        } else if (this.isTraceOn()) {
            this.trace("start", "the gauge monitor is already activated");
        }
    }

    public synchronized void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the gauge monitor");
        }
        if (this.isActive()) {
            if (this.alarmClock != null) {
                this.alarmClock.interrupt();
                try {
                    this.alarmClock.join();
                }
                catch (InterruptedException interruptedException) {}
                this.alarmClock = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the counter monitor is already deactivated");
        }
    }

    private boolean updateDerivedGauge(Object object) {
        boolean bl;
        this.derivedGaugeTimestamp = new Date().getTime();
        if (this.differenceMode) {
            if (this.previousScanGauge != null) {
                this.setDerivedGaugeWithDifference((Number)object);
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanGauge = (Number)object;
        } else {
            this.derivedGauge = (Number)object;
            bl = true;
        }
        return bl;
    }

    private void updateNotifications() {
        Object var1_1 = null;
        if (this.status == 2) {
            if (this.isFirstGreaterThanLast(this.derivedGauge, this.highThreshold)) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.highThreshold);
                }
                this.status = 1;
            }
            if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge)) {
                if (this.notifyLow) {
                    this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.lowThreshold);
                }
                this.status = 0;
            }
        } else if (this.status == 0) {
            if (this.isFirstGreaterThanLast(this.derivedGauge, this.highThreshold)) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.highThreshold);
                }
                this.status = 1;
            }
        } else if (this.status == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge)) {
            if (this.notifyLow) {
                this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.lowThreshold);
            }
            this.status = 0;
        }
    }
}

