/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.manager.ReqRedirectSrv;
import javax.management.snmp.manager.SnmpHandler;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpVar;
import javax.management.snmp.manager.SnmpVarbindList;
import javax.management.snmp.manager.Timestamp;

final class MultiplexRequest
implements Serializable,
SnmpHandler,
SnmpDefinitions,
ReqRedirectSrv {
    private SnmpPeer thepeer;
    private SnmpSession asession;
    private int command;
    private SnmpRequest multiplexReq;
    private Vector vbmuxList = null;
    static final String nl = "\n";
    SnmpVarbindList multiplexVb;
    String dbgTag = "MultiplexRequest";

    public MultiplexRequest(SnmpPeer snmpPeer, SnmpSession snmpSession, int n) {
        this.thepeer = snmpPeer;
        this.asession = snmpSession;
        this.command = n;
        this.multiplexVb = new SnmpVarbindList("Multiplexed varbind list");
        this.vbmuxList = new Vector();
    }

    public synchronized void action() {
        block6: {
            if (this.vbmuxList.isEmpty()) {
                return;
            }
            if (this.vbmuxList.size() == 1) {
                VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)this.vbmuxList.firstElement();
                this.deleteFromMuxPool(vbMultiplexMap);
                SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
                snmpRequest.action();
                return;
            }
            try {
                if (this.multiplexReq == null) {
                    this.multiplexReq = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
                    this.multiplexReq.setOptions(6);
                    this.multiplexReq.setInternalRequest();
                }
                if (this.isTraceOn()) {
                    this.trace("action", "Multiplex request just before firing\n" + this.debugMultiplexing());
                }
                this.multiplexReq.start(this.multiplexVb, false, 0L);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block6;
                this.debug("action", exception);
            }
        }
    }

    public synchronized boolean addRequest(SnmpRequest snmpRequest) {
        if (this.multiplexVb.size() + snmpRequest.getVarbindList().size() > this.getPeer().getVarbindLimit()) {
            return false;
        }
        this.buildMultiplexVblist(snmpRequest);
        return true;
    }

    private void addToMuxPool(VbMultiplexMap vbMultiplexMap) {
        this.vbmuxList.addElement(vbMultiplexMap);
    }

    private synchronized void buildMultiplexVblist(SnmpRequest snmpRequest) {
        VbMultiplexMap vbMultiplexMap = new VbMultiplexMap(snmpRequest);
        vbMultiplexMap.compress(this.multiplexVb);
        snmpRequest.setProxyObject(this);
        this.addToMuxPool(vbMultiplexMap);
    }

    public synchronized void cancel(SnmpRequest snmpRequest) {
        this.deleteFromMuxPool(snmpRequest);
        SnmpVarbindList snmpVarbindList = snmpRequest.getVarbindList().cloneWithoutValue();
        snmpRequest.setVarbindList(snmpVarbindList);
    }

    private void clearMuxPool() {
        this.vbmuxList.removeAllElements();
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    public synchronized String debugMultiplexing() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("\nMultiplex Object Description BEGIN=> \n");
        stringBuffer.append(String.valueOf(this.toString()) + nl);
        stringBuffer.append("\nMultiplex Varbindlist-> \n");
        stringBuffer.append(this.multiplexVb.oidListToString());
        stringBuffer.append("\nIndividual Request Description .....\n");
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
            stringBuffer.append("\nRequestId = " + snmpRequest.getRequestId());
            stringBuffer.append(nl + snmpRequest.getVarbindList().oidListToString());
        }
        stringBuffer.append("\nMultiplex Object Description ENDS=> \n");
        return stringBuffer.toString();
    }

    private void deleteFromMuxPool(VbMultiplexMap vbMultiplexMap) {
        this.vbmuxList.removeElement(vbMultiplexMap);
        vbMultiplexMap.getRequest().setProxyObject(null);
    }

    private void deleteFromMuxPool(SnmpRequest snmpRequest) {
        this.vbmuxList.removeElement(snmpRequest);
        snmpRequest.setProxyObject(null);
    }

    public final int getCommand() {
        return this.command;
    }

    public Enumeration getElements() {
        return this.vbmuxList.elements();
    }

    public final SnmpPeer getPeer() {
        return this.thepeer;
    }

    public final SnmpSession getSnmpSession() {
        return this.asession;
    }

    synchronized void handleError(SnmpVarbindList snmpVarbindList, int n, int n2) {
        SnmpRequest snmpRequest;
        Object object;
        Enumeration enumeration = this.getElements();
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        while (enumeration.hasMoreElements()) {
            object = (VbMultiplexMap)enumeration.nextElement();
            snmpRequest = ((VbMultiplexMap)object).getRequest();
            if (!snmpRequest.inProgress()) continue;
            int n3 = ((VbMultiplexMap)object).findMatchIndex(n2);
            if (n3 < 0) {
                vector.addElement(snmpRequest);
                continue;
            }
            snmpRequest.setErrorStatusAndIndex(n, n3);
            snmpRequest.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            snmpRequest.invokeOnResponse(null);
        }
        if (vector.isEmpty()) {
            return;
        }
        this.clearMuxPool();
        object = vector.elements();
        while (object.hasMoreElements()) {
            snmpRequest = (SnmpRequest)object.nextElement();
            this.buildMultiplexVblist(snmpRequest);
        }
        this.action();
    }

    synchronized void handleSuccess(SnmpVarbindList snmpVarbindList) {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration = this.getElements();
        Timestamp timestamp = snmpVarbindList.getTimestamp();
        while (enumeration.hasMoreElements()) {
            object3 = (VbMultiplexMap)enumeration.nextElement();
            object2 = ((VbMultiplexMap)object3).getRequest();
            if (!((SnmpRequest)object2).inProgress()) continue;
            ((SnmpRequest)object2).setErrorStatusAndIndex(0, 0);
            if (this.command == 161) {
                ((VbMultiplexMap)object3).uncompressAndCopyVar(this.multiplexVb);
            } else {
                ((VbMultiplexMap)object3).uncompressAndCopyValue(this.multiplexVb);
            }
            ((SnmpRequest)object2).getVarbindList().setTimestamp(timestamp);
            ((SnmpRequest)object2).setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
        }
        if (this.isDebugOn()) {
            object3 = new StringBuffer(1024);
            ((StringBuffer)object3).append("Received successsful response to demultiplexed request...\n");
            ((StringBuffer)object3).append(snmpVarbindList.vbListToString());
            ((StringBuffer)object3).append("Individual requestBreakup follows :::\n");
            object2 = this.getElements();
            while (object2.hasMoreElements()) {
                object = (VbMultiplexMap)object2.nextElement();
                SnmpRequest snmpRequest = ((VbMultiplexMap)object).getRequest();
                if (!snmpRequest.inProgress()) continue;
                ((StringBuffer)object3).append("\nDemultiplexed Request = " + snmpRequest.getRequestId());
                ((StringBuffer)object3).append(nl + snmpRequest.getVarbindList().vbListToString() + nl);
            }
            this.debug("handleSuccess", "Demultiplexing Request as follows:\n" + ((StringBuffer)object3).toString());
        }
        object3 = this.getElements();
        while (object3.hasMoreElements()) {
            object2 = (VbMultiplexMap)object3.nextElement();
            object = ((VbMultiplexMap)object2).getRequest();
            ((SnmpRequest)object).invokeOnResponse(null);
        }
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public synchronized void processSnmpInternalError(SnmpRequest snmpRequest, String string) {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest2 = vbMultiplexMap.getRequest();
            if (!snmpRequest2.inProgress()) continue;
            snmpRequest2.setErrorStatusAndIndex(240, 0);
            snmpRequest2.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (this.isDebugOn()) {
                this.debug("processSnmpInternalError", "Internal error while processing multiplexed request");
            }
            snmpRequest2.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public synchronized void processSnmpPollData(SnmpRequest snmpRequest, int n, int n2, SnmpVarbindList snmpVarbindList) {
        switch (n) {
            case 0: {
                this.handleSuccess(snmpVarbindList);
                break;
            }
            case 1: {
                if (this.isDebugOn()) {
                    this.debug("processSnmpPollData", "Too-big error while multiplexing");
                }
            }
            default: {
                this.handleError(snmpVarbindList, n, n2);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest snmpRequest) {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest2 = vbMultiplexMap.getRequest();
            if (!snmpRequest2.inProgress()) continue;
            snmpRequest2.setErrorStatusAndIndex(224, 0);
            snmpRequest2.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (this.isDebugOn()) {
                this.debug("processSnmpPollTimeout", "Timeout occured while processing multiplexed request");
            }
            snmpRequest2.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = 0;
        Enumeration enumeration = this.getElements();
        stringBuffer.append(this.getPeer().toString());
        stringBuffer.append(" -> Requests being Multiplexed = ");
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
            stringBuffer.append(String.valueOf(snmpRequest.getRequestId()) + ", ");
            n += snmpRequest.getVarbindList().size();
        }
        stringBuffer.append("\nTotal vbcount of all requests = " + n);
        if (this.multiplexVb == null) {
            stringBuffer.append("   Multiplexed Varbind not initialized.");
        } else {
            stringBuffer.append("    Multiplexed Vbcount = " + this.multiplexVb.size());
        }
        stringBuffer.append("\nCorresponding Multiplex Request Status : \n");
        if (this.multiplexReq != null) {
            stringBuffer.append(this.multiplexReq.toString());
        } else {
            stringBuffer.append("Not created yet!! ");
        }
        return stringBuffer.toString();
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    final class VbMultiplexMap {
        SnmpRequest thereq;
        SnmpVarbindList vblst;
        int[] mapidx;
        int size = 0;

        public VbMultiplexMap(SnmpRequest snmpRequest) {
            this.thereq = snmpRequest;
            this.vblst = this.thereq.getVarbindList();
            this.size = this.vblst.size();
            this.mapidx = new int[this.size];
        }

        synchronized void compress(SnmpVarbindList snmpVarbindList) {
            int n = snmpVarbindList.size();
            if (n == 0) {
                snmpVarbindList.concat(this.vblst);
                this.mapidx = null;
                return;
            }
            int n2 = 0;
            while (n2 < this.size) {
                SnmpVar snmpVar = this.vblst.getSnmpVarAt(n2);
                int n3 = snmpVarbindList.indexOfOid(snmpVar, 0, n);
                if (n3 < 0) {
                    snmpVarbindList.addVariable(snmpVar);
                    this.mapidx[n2] = snmpVarbindList.size() * -1;
                } else {
                    this.mapidx[n2] = n3;
                }
                ++n2;
            }
        }

        public final synchronized boolean equals(Object object) {
            if (object instanceof SnmpRequest) {
                return this.thereq == object;
            }
            return super.equals(object);
        }

        synchronized int findMatchIndex(int n) {
            if (this.mapidx == null) {
                if (n < this.size) {
                    return n;
                }
                return -1;
            }
            int n2 = 0;
            while (n2 < this.mapidx.length) {
                int n3 = this.mapidx[n2];
                if (n3 == n || -n3 == n) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        synchronized SnmpRequest getRequest() {
            return this.thereq;
        }

        synchronized void uncompressAndCopyValue(SnmpVarbindList snmpVarbindList) {
            if (this.mapidx == null) {
                return;
            }
            int n = 0;
            while (n < this.mapidx.length) {
                int n2 = this.mapidx[n];
                if (n2 >= 0) {
                    SnmpVar snmpVar = snmpVarbindList.getSnmpVarAt(n2);
                    this.vblst.getSnmpVarAt(n).copyValue(snmpVar);
                }
                ++n;
            }
        }

        synchronized void uncompressAndCopyVar(SnmpVarbindList snmpVarbindList) {
            if (this.mapidx == null) {
                return;
            }
            int n = 0;
            while (n < this.mapidx.length) {
                int n2 = this.mapidx[n];
                if (n2 >= 0) {
                    SnmpVar snmpVar = snmpVarbindList.getSnmpVarAt(n2);
                    this.vblst.getSnmpVarAt(n).copyValueAndOid(snmpVar);
                }
                ++n;
            }
        }
    }
}

