/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.GroupGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CodeGenerator
extends Generator
implements Serializable {
    protected GroupGenerator groupGenerator;
    protected String domainSeparator = "_";

    public CodeGenerator(ResourceManager resourceManager, String string, String string2, String string3) {
        super(resourceManager, string, string2, string3);
        this.groupGenerator = new GroupGenerator(resourceManager, string, string2, string3);
    }

    public String appendName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return new String(String.valueOf(string) + this.domainSeparator + string2);
    }

    public void generateCode(ASTMib aSTMib) throws IOException {
        this.mib = aSTMib;
        MibGenerator mibGenerator = new MibGenerator(this.manager, this.packageName, this.prefix, this.targetDir, aSTMib);
        mibGenerator.setDomainSeparator(this.domainSeparator);
        aSTMib.buildOidTable();
        MibTree mibTree = aSTMib.getMibTree();
        this.groupGenerator.setMib(aSTMib);
        MibNode mibNode = mibTree.getRoot();
        this.generateCode(mibGenerator, mibNode);
        mibGenerator.endMib();
    }

    private void generateCode(MibGenerator mibGenerator, MibNode mibNode) throws IOException {
        this.generateNode(mibGenerator, mibNode, null, null);
    }

    private void generateNode(MibGenerator mibGenerator, MibNode mibNode, MibNode mibNode2, String string) throws IOException {
        Object object;
        if (mibNode.isGroup()) {
            try {
                mibNode.isValidGroup();
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                String string3 = this.getClassName(mibNode.getComputedOid());
                String string4 = MessageHandler.getMessage("generate.error.mib", string3, this.getClassName(string2));
                mibGenerator.endMib();
                throw iOException;
            }
            this.groupGenerator.generateCode(mibNode);
            mibGenerator.registerNode(mibNode, string);
            if (!mibNode.hasNestedGroups()) {
                return;
            }
            object = this.getSymbolName(mibNode);
            if (object != null) {
                string = this.appendName(string, (String)object);
            }
            mibNode2 = mibNode;
        }
        object = mibNode.getChildren();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            this.generateNode(mibGenerator, (MibNode)enumeration.nextElement(), mibNode2, string);
        }
    }

    public String getSymbolName(MibNode mibNode) {
        if (mibNode == null) {
            return null;
        }
        if (mibNode.getSymbolName() != null) {
            return mibNode.getSymbolName();
        }
        Hashtable hashtable = this.mib.oidTranslation;
        String string = (String)hashtable.get(mibNode.getComputedOid());
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        string2 = string2.replace('-', '_');
        string2 = string2.replace('.', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(' ', '_');
        return String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1, string2.length());
    }

    public String setDomainSeparator(String string) {
        if (string != null) {
            this.domainSeparator = string;
        }
        return this.domainSeparator;
    }
}

