/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MibStoreGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String fileName = "";
    protected StringBuffer metadata = new StringBuffer();
    protected boolean entrySet = false;
    private String varName = "varList";

    public MibStoreGenerator(ResourceManager resourceManager, String string, String string2, String string3, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3);
        this.mib = aSTMib;
        this.module = aSTMib.getModuleName();
        this.fileName = String.valueOf(string2) + this.translateMibName() + Def.OIDTABLESUFFIX;
        this.out = this.openFile(String.valueOf(this.fileName) + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
    }

    private String accessNodeSyntax(MibNode mibNode) {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        return aSTNamedType.getSnmpSyntax();
    }

    protected void addMibEntry(String string, String string2, String string3) throws IOException {
        if (this.entrySet) {
            this.metadata.append(",\n");
        }
        this.metadata.append(String.valueOf(Def.TAB2) + "new SnmpOidRecord(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\")");
        this.entrySet = true;
    }

    protected void closeMeta() throws IOException {
        this.metadata.append(String.valueOf(Def.TAB) + "};\n");
    }

    private void endCodeGeneration() throws IOException {
        if (this.entrySet) {
            this.closeMeta();
        } else {
            this.closeMeta();
        }
        this.write(this.metadata.toString());
        this.write(Def.RBRACE);
    }

    public void generateCode() throws IOException {
        this.initMeta();
        MibNode mibNode = this.mib.getMibTree().getRoot();
        this.generateCode(mibNode);
        this.endCodeGeneration();
    }

    private void generateCode(MibNode mibNode) throws IOException {
        Object object;
        Object object2;
        if (mibNode.isAssociated()) {
            Hashtable hashtable;
            object2 = mibNode.getComputedOid();
            object = SyntaxMapper.getMibStoreSyntax(SyntaxMapper.getTypeName(this.accessNodeSyntax(mibNode)));
            if (((String)object).equals(SyntaxMapper.MibStoreSequenceSymbol) && !(hashtable = mibNode.getChildren()).isEmpty()) {
                Enumeration enumeration = hashtable.elements();
                if (enumeration.hasMoreElements()) {
                    MibNode mibNode2 = (MibNode)enumeration.nextElement();
                    if (mibNode2.getChildren().isEmpty()) {
                        object = SyntaxMapper.MibStoreEntrySymbol;
                    }
                }
            }
            this.addMibEntry(mibNode.getRealSymbolName(), (String)object2, (String)object);
        }
        object2 = mibNode.getChildren();
        object = ((Hashtable)object2).elements();
        while (object.hasMoreElements()) {
            this.generateCode((MibNode)object.nextElement());
        }
    }

    protected void initMeta() throws IOException {
        this.metadata.append(String.valueOf(Def.TAB) + "static SnmpOidRecord " + this.varName + " [] = {\n");
    }

    private String translateMibName() throws IOException {
        String string = this.module.trim();
        string = string.replace('-', '_');
        string = string.replace('.', '_');
        string = string.replace(',', '_');
        string = string.replace(',', '_');
        string = string.replace(' ', '_');
        return string;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.miboidtable.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.miboidtable.comment.header2", this.fileName) + "\n" + " */\n");
        this.write(String.valueOf(Def.PUBLIC) + Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_OID_TABLE + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(String.valueOf(Def.TAB) + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "super(\"" + this.translateMibName() + "\")" + Def.SEMICOLON + Def.TAB2 + "loadMib(" + this.varName + ")" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_OID_RECORD + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_OID_TABLE_SUPPORT + Def.SEMICOLON);
        this.write("\n");
    }
}

