/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.Proxy;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.RemoteMBeanServer;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class GenericProxy
implements Proxy {
    private ObjectName myName = null;
    private ObjectInstance objectInstance = null;
    private RemoteMBeanServer remMBeanServer = null;
    private MBeanInfo mbeanInfo = null;
    private AttributeList currModifList = new AttributeList();
    private Vector attributeList = new Vector();
    private boolean group = false;
    private Hashtable attributes_value = null;

    public GenericProxy(ObjectInstance objectInstance) {
        this.objectInstance = objectInstance;
        this.myName = this.objectInstance.getObjectName();
    }

    public void bind(RemoteMBeanServer remoteMBeanServer) {
        if (this.remMBeanServer != null) {
            throw new CommunicationException("Generic Proxy not disconnected");
        }
        this.remMBeanServer = remoteMBeanServer;
        this.remMBeanServer.addProxy(this);
        try {
            this.getMBeanInfo();
        }
        catch (Exception exception) {}
    }

    public void deleteMBean() throws InstanceNotFoundException, MBeanRegistrationException {
        this.remMBeanServer.unregisterMBean(this.objectInstance.getObjectName());
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.group) {
            return this.attributes_value.get(string);
        }
        return this.remMBeanServer.getAttribute(this.myName, string);
    }

    public AttributeList getAttributes(String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        int n = stringArray.length;
        AttributeList attributeList = new AttributeList(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                attributeList.add(new Attribute(stringArray[n2], this.getAttribute(stringArray[n2])));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (MBeanException mBeanException) {}
            ++n2;
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() throws InstanceNotFoundException, ProxyMBeanInstantiationException, ReflectionException, IntrospectionException {
        this.mbeanInfo = this.remMBeanServer.getMBeanInfo(this.myName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.mbeanInfo.getAttributes();
        this.attributes_value = new Hashtable();
        int n = mBeanAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.attributeList.addElement(mBeanAttributeInfoArray[n2].getName());
            ++n2;
        }
        return this.mbeanInfo;
    }

    public ObjectInstance getMBeanObjectInstance() {
        return this.objectInstance;
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        return this.remMBeanServer;
    }

    private void handleAttributeList(AttributeList attributeList) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        Iterator iterator = ((AbstractList)attributeList).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.attributes_value.put(attribute.getName(), attribute.getValue());
        }
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.remMBeanServer.invoke(this.myName, string, objectArray, stringArray);
    }

    public boolean isBound() {
        return this.remMBeanServer != null;
    }

    public void setAttribute(Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.group) {
            int n = this.currModifList.indexOf(attribute);
            if (n == -1) {
                this.currModifList.add(attribute);
            } else {
                this.currModifList.set(n, attribute);
            }
        } else {
            this.remMBeanServer.setAttribute(this.myName, attribute);
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.group) {
            int n = attributeList.size();
            Iterator iterator = ((AbstractList)attributeList).iterator();
            while (iterator.hasNext()) {
                try {
                    this.setAttribute((Attribute)iterator.next());
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                }
                catch (MBeanException mBeanException) {
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {}
            }
            return null;
        }
        return this.remMBeanServer.setAttributes(this.myName, attributeList);
    }

    public void setRemoteMBeanServer(RemoteMBeanServer remoteMBeanServer) {
        this.remMBeanServer = remoteMBeanServer;
    }

    public void unbind() {
        if (this.remMBeanServer == null) {
            throw new CommunicationException("Generic MBean not connected");
        }
        this.remMBeanServer.removeProxy(this);
    }
}

