/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.cascading;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.Trace;
import com.sun.jdmk.cascading.CascadeGenericProxy;
import com.sun.jdmk.cascading.CascadingAgentMBean;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatNotification;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.RmiConnectorAddress;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ServiceNotFoundException;

public class CascadingAgent
implements Serializable,
NotificationListener,
MBeanRegistration,
CascadingAgentMBean,
NotificationFilter {
    private MBeanServer mserver = null;
    private ConnectorAddress address = new RmiConnectorAddress("localhost", 1099, "name=RmiConnectorServer");
    private String conClName = null;
    private transient boolean isActive = false;
    private transient boolean isStopping = false;
    private transient RemoteMBeanServer conClient = null;
    private transient Vector registeredRemoteObjs = new Vector();
    private transient QueryExp query = null;
    private transient ObjectName pattern = null;
    private String dbgTag = "CascadingAgent";

    public CascadingAgent() {
    }

    public CascadingAgent(ConnectorAddress connectorAddress) {
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string) {
        this.address = connectorAddress;
        this.conClName = string;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, String string, ObjectName objectName, QueryExp queryExp) {
        this.address = connectorAddress;
        this.conClName = string;
        this.pattern = objectName;
        this.query = queryExp;
    }

    public CascadingAgent(ConnectorAddress connectorAddress, ObjectName objectName, QueryExp queryExp) {
        this.address = connectorAddress;
        this.conClName = this.findConnectorClientClassName(connectorAddress);
        this.pattern = objectName;
        this.query = queryExp;
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 32, string, string2, string3);
    }

    private void debugex(String string, String string2, Throwable throwable) {
        Trace.send(2, 32, string, string2, throwable);
    }

    private void debugex(String string, Throwable throwable) {
        this.debugex(this.dbgTag, string, throwable);
    }

    private String findConnectorClientClassName(ConnectorAddress connectorAddress) {
        if (connectorAddress instanceof RmiConnectorAddress) {
            return "com.sun.jdmk.comm.RmiConnectorClient";
        }
        if (connectorAddress instanceof HttpConnectorAddress) {
            return "com.sun.jdmk.comm.HttpConnectorClient";
        }
        if (connectorAddress instanceof HttpsConnectorAddress) {
            return "com.sun.jdmk.comm.HttpsConnectorClient";
        }
        throw new IllegalArgumentException("The ConnectorAddress passed in parameter does not correspond to a JDMK ConnectorAddress implementation");
    }

    public ConnectorAddress getAddress() {
        return this.address;
    }

    public String getClientConnectorClassName() {
        if (this.conClName != null) {
            return this.conClName;
        }
        return "com.sun.jdmk.comm.RmiConnectorClient";
    }

    private Boolean getConnected() {
        boolean bl = this.conClient == null ? false : this.conClient.isConnected();
        return new Boolean(bl);
    }

    public Integer getNbOfRemoteMBeans() {
        return new Integer(this.registeredRemoteObjs.size());
    }

    public ObjectName getPattern() {
        return this.pattern;
    }

    public QueryExp getQuery() {
        return this.query;
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        return this.conClient;
    }

    public synchronized Set getRemoteMBeans() {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        ObjectInstance objectInstance = null;
        Enumeration enumeration = this.registeredRemoteObjs.elements();
        while (enumeration.hasMoreElements()) {
            block3: {
                try {
                    objectInstance = this.conClient.getObjectInstance((ObjectName)enumeration.nextElement());
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block3;
                    this.debug("getRemoteMBeans", "got exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    private void handleHeartbeatNotification(Notification notification) {
        if (!this.isStopping && notification.getType().equals("jdmk.connector.heartbeat.connection.lost")) {
            this.stop();
        }
    }

    private void handleLocalNotification(Notification notification) {
        block2: {
            ObjectName objectName;
            if (this.isStopping || !notification.getType().equals("JMX.mbean.unregistered") || !this.registeredRemoteObjs.contains(objectName = ((MBeanServerNotification)notification).getMBeanName())) break block2;
            try {
                this.conClient.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debug("handleLocalNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (object == null) {
            if (notification instanceof HeartBeatNotification) {
                this.handleHeartbeatNotification(notification);
            } else {
                this.handleRemoteNotification(notification);
            }
        } else {
            this.handleLocalNotification(notification);
        }
    }

    private void handleRemoteNotification(Notification notification) {
        block7: {
            ObjectName objectName;
            block8: {
                HashSet hashSet = (HashSet)this.conClient.queryNames(this.pattern, this.query);
                objectName = ((MBeanServerNotification)notification).getMBeanName();
                if (!notification.getType().equals("JMX.mbean.registered")) break block8;
                if (hashSet.contains(objectName)) {
                    Object var4_4 = null;
                    ObjectInstance objectInstance = null;
                    GenericProxy genericProxy = null;
                    try {
                        objectInstance = this.conClient.getObjectInstance(objectName);
                        genericProxy = this.conClient.getGenericProxy(objectInstance);
                        this.register(new CascadeGenericProxy(genericProxy), objectName);
                    }
                    catch (Exception exception) {
                        if (this.isDebugOn()) {
                            this.debug("handleRemoteNotification", "Could not get GenericProxy for object " + objectName + " " + exception.getMessage());
                        }
                        break block7;
                    }
                }
                break block7;
            }
            if (!notification.getType().equals("JMX.mbean.unregistered")) break block7;
            try {
                if (this.isTraceOn()) {
                    this.trace("handleRemoteNotification", "Remove deleted MBean " + objectName);
                }
                this.unregister(objectName);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block7;
                this.debug("handleRemoteNotification", "Could not unregister object  " + objectName + " " + exception.getMessage());
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 32);
    }

    public boolean isNotificationEnabled(Notification notification) {
        ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
        return this.registeredRemoteObjs.contains(objectName);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 32);
    }

    private void loadRemoteObjects(ObjectName objectName, QueryExp queryExp) throws ServiceNotFoundException, CommunicationException, IllegalAccessException {
        HashSet hashSet = null;
        hashSet = (HashSet)this.conClient.queryMBeans(objectName, queryExp);
        if (this.isDebugOn()) {
            this.debug("loadRemoteObjects", "Found " + hashSet.size() + " names");
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance;
            block12: {
                CascadeGenericProxy cascadeGenericProxy;
                GenericProxy genericProxy;
                block11: {
                    objectInstance = (ObjectInstance)iterator.next();
                    genericProxy = null;
                    cascadeGenericProxy = null;
                    try {
                        genericProxy = this.conClient.getGenericProxy(objectInstance);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block11;
                        this.debug("loadRemoteObjects", "Could not get GenericProxy for object " + objectInstance + " " + exception.getMessage());
                    }
                }
                if (cascadeGenericProxy == null) {
                    cascadeGenericProxy = new CascadeGenericProxy(genericProxy);
                }
                if (objectInstance.getObjectName().getDomain().equals("JMImplementation")) continue;
                try {
                    this.register(cascadeGenericProxy, objectInstance.getObjectName());
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    if (this.isDebugOn()) {
                        this.debugex("loadRemoteObjects", instanceAlreadyExistsException);
                    }
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    if (this.isDebugOn()) {
                        this.debugex("loadRemoteObjects", mBeanRegistrationException);
                    }
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {
                    if (!this.isDebugOn()) break block12;
                    this.debugex("loadRemoteObjects", notCompliantMBeanException);
                }
            }
            if (!this.isTraceOn()) continue;
            this.trace("loadRemoteObjects", "Proxy MBean " + objectInstance.getObjectName() + " has been registered");
        }
    }

    public void postDeregister() {
        block2: {
            try {
                this.stop();
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block2;
                this.debugex("postDeregister", exception);
            }
        }
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mserver = mBeanServer;
        if (this.conClient == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.getClientConnectorClassName());
                this.conClient = (RemoteMBeanServer)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ServiceNotFoundException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        }
        return objectName;
    }

    private synchronized void register(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mserver.registerMBean(object, objectName);
        this.registeredRemoteObjs.addElement(objectName);
    }

    public void setAddress(ConnectorAddress connectorAddress) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.address = connectorAddress;
    }

    public void setClientConnectorClassName(String string) {
        if (this.isActive) {
            throw new IllegalStateException("The cascading agent is active");
        }
        this.conClName = string;
    }

    public synchronized void start() {
        block22: {
            if (!this.isActive) {
                block21: {
                    block20: {
                        block19: {
                            if (this.conClient == null || !this.conClient.getClass().getName().equals(this.getClientConnectorClassName())) {
                                Class<?> clazz = null;
                                try {
                                    clazz = Class.forName(this.getClientConnectorClassName());
                                    this.conClient = (RemoteMBeanServer)clazz.newInstance();
                                }
                                catch (Exception exception) {
                                    if (this.isDebugOn()) {
                                        this.debug("start", "got exception while trying to get client connector: " + exception.getMessage());
                                        exception.printStackTrace();
                                    }
                                    throw new JMRuntimeException(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                                }
                            }
                            try {
                                this.conClient.connect(this.address);
                            }
                            catch (CommunicationException communicationException) {
                                if (this.isDebugOn()) {
                                    this.debug("start", "got exception while connecting: " + communicationException.getMessage());
                                    communicationException.printStackTrace();
                                }
                                throw communicationException;
                            }
                            if (this.conClient instanceof HeartBeatClientHandler) {
                                try {
                                    ((HeartBeatClientHandler)((Object)this.conClient)).setHeartBeatPeriod(2000);
                                    ((HeartBeatClientHandler)((Object)this.conClient)).addHeartBeatNotificationListener(this, null, null);
                                }
                                catch (Exception exception) {
                                    if (!this.isDebugOn()) break block19;
                                    this.debug("start", "Failed to become listener of heartbeat notifications on the remote MBean Server " + exception.getMessage());
                                }
                            }
                        }
                        try {
                            this.loadRemoteObjects(this.pattern, this.query);
                        }
                        catch (Exception exception) {
                            if (!this.isDebugOn()) break block20;
                            this.debug("start", "got exception while loading remote objects: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    try {
                        this.conClient.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block21;
                        this.debug("start", "Failed to become listener of the remote MBean Server " + exception.getMessage());
                    }
                }
                this.isActive = true;
                this.isStopping = false;
            } else if (this.isTraceOn()) {
                this.trace("start", "The CascadingAgent is already activated.");
            }
            try {
                this.mserver.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, (NotificationFilter)this, (Object)new String("local"));
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block22;
                this.debug("start", "Failed to become listener of the local MBean Server " + exception.getMessage());
            }
        }
    }

    public synchronized void stop() {
        if (this.isActive) {
            block18: {
                block17: {
                    try {
                        this.conClient.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block17;
                        this.debug("stop", "failed to remove us as a regular listener of the REMOTE mbean server: " + exception.getMessage());
                    }
                }
                if (this.conClient instanceof HeartBeatClientHandler) {
                    try {
                        ((HeartBeatClientHandler)((Object)this.conClient)).removeHeartBeatNotificationListener(this);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) break block18;
                        this.debug("stop", "failed to remove us as a heart beat listener of the REMOTE mbean server: " + exception.getMessage());
                    }
                }
            }
            this.isStopping = true;
            while (!this.registeredRemoteObjs.isEmpty()) {
                Object e = this.registeredRemoteObjs.firstElement();
                try {
                    this.unregister((ObjectName)e);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (this.isDebugOn()) {
                        this.debug("stop", "failed to unregister object: " + (ObjectName)e + ", got exception: " + instanceNotFoundException.getMessage());
                    }
                    this.registeredRemoteObjs.removeElement(e);
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    if (this.isDebugOn()) {
                        this.debug("stop", "failed (2) to unregister object: " + (ObjectName)e + ", got exception: " + mBeanRegistrationException.getMessage());
                    }
                    this.registeredRemoteObjs.removeElement(e);
                }
            }
            if (this.conClient.isConnected()) {
                this.conClient.disconnect();
            }
            this.isActive = false;
            this.isStopping = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "The CascadingAgent is already deactivated.");
        }
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 32, string, string2, string3);
    }

    private synchronized void unregister(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mserver.unregisterMBean(objectName);
        this.registeredRemoteObjs.removeElement(objectName);
    }
}

