/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServerMBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class CommunicatorServer
implements Runnable,
Serializable,
MBeanRegistration,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int RMI_TYPE = 1;
    public static final int HTTP_TYPE = 2;
    public static final int HTML_TYPE = 3;
    public static final int SNMP_TYPE = 4;
    public static final int HTTPS_TYPE = 5;
    transient int state = 1;
    ObjectName objectName;
    MBeanServer mbs;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private transient Vector clientHandlerVector = new Vector();
    private transient boolean stopRequested = false;
    int infoType;

    public CommunicatorServer(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.infoType = 256;
                break;
            }
            case 2: {
                this.infoType = 512;
                break;
            }
            case 3: {
                this.infoType = 16;
                break;
            }
            case 4: {
                this.infoType = 1024;
                break;
            }
            case 5: {
                this.infoType = 2048;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
    }

    synchronized void changeState(int n) {
        if (this.state == n) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.notifyAll();
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, this.infoType, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    int getActiveClientCount() {
        int n = this.clientHandlerVector.size();
        return n;
    }

    public String getHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    MBeanServer getMBeanServer() {
        return this.mbs;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    public int getPort() {
        return this.port;
    }

    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 3: {
                string = "STARTING";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public boolean isActive() {
        return this.state == 0;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String string = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return string;
    }

    void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        this.mbs = null;
        this.objectName = null;
        if (this.state == 0 || this.state == 3) {
            this.stop();
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        this.mbs = mBeanServer;
        this.dbgTag = this.makeDebugTag();
        return objectName;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeState(1);
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.stopRequested = false;
    }

    public void run() {
        try {
            this.doBind();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("run", "Unexpected exception = " + exception);
            }
            this.changeState(1);
            this.doError(exception);
        }
        this.changeState(0);
        if (this.isTraceOn()) {
            this.trace("run", "State is ONLINE");
        }
        ThreadDeath threadDeath = null;
        try {
            while (!this.stopRequested) {
                ++this.servedClientCount;
                this.doReceive();
                this.waitIfTooManyClients();
                this.doProcess();
            }
            if (this.isTraceOn()) {
                this.trace("run", "Stop has been requested");
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.isTraceOn()) {
                this.trace("run", "Interrupt caught");
            }
            this.changeState(2);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("run", "Unexpected exception = " + exception);
            }
            this.changeState(2);
        }
        catch (ThreadDeath threadDeath2) {
            if (this.isDebugOn()) {
                this.debug("run", "ThreadDeath caught");
            }
            threadDeath = threadDeath2;
            this.changeState(2);
        }
        try {
            this.doUnbind();
            this.waitClientTermination();
            this.changeState(1);
            if (this.isTraceOn()) {
                this.trace("run", "State is OFFLINE");
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("run", "Unexpected exception = " + exception);
            }
            this.changeState(1);
        }
        if (threadDeath != null) {
            throw threadDeath;
        }
    }

    void setMaxActiveClientCount(int n) throws IllegalStateException {
        if (this.isActive()) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.maxActiveClientCount = n;
    }

    public void setPort(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.port = n;
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.state == 1 && this.state != 3) {
            this.changeState(3);
            if (this.isTraceOn()) {
                this.trace("start", "--> Start connector ");
            }
            this.stopRequested = false;
            this.mainThread = new Thread((Runnable)this, this.makeThreadName());
            if (Thread.currentThread().getPriority() < 10) {
                this.mainThread.setPriority(Thread.currentThread().getPriority() + 1);
            }
            this.mainThread.start();
            if (this.isTraceOn()) {
                this.trace("start", "Connector started.");
            }
        } else if (this.isTraceOn()) {
            this.trace("start", "Connector is not OFFLINE");
        }
    }

    public void stop() {
        if (this.state == 0 || this.state == 3) {
            this.changeState(2);
            if (this.isTraceOn()) {
                this.trace("stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            this.mainThread.interrupt();
            if (this.isTraceOn()) {
                this.trace("stop", "terminateAllClient");
            }
            this.terminateAllClient();
            this.changeState(1);
        } else if (this.isTraceOn()) {
            this.trace("stop", "Connector is not ONLINE");
        }
    }

    private void terminateAllClient() {
        int n = this.clientHandlerVector.size();
        if (this.isTraceOn() && n >= 1) {
            this.trace("terminateAllClient", "Interrupting " + n + " clients");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.interrupt();
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    private void waitClientTermination() {
        int n = this.clientHandlerVector.size();
        if (this.isTraceOn() && n >= 1) {
            this.trace("waitClientTermination", "waiting for " + n + " clients to terminate");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.join();
        }
        if (this.isTraceOn() && n >= 1) {
            this.trace("waitClientTermination", "Ok, let's go...");
        }
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (this.isTraceOn()) {
                this.trace("waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait(5000L);
        }
    }

    public boolean waitState(int n, long l) {
        if (this.isTraceOn()) {
            this.trace("waitState", String.valueOf(n) + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        if (l < 0L) {
            return this.state == n;
        }
        boolean bl = this.state == n;
        long l2 = -1L;
        Date date = new Date(new Date().getTime() + l);
        while (!bl) {
            if (l != 0L && (l2 = date.getTime() - new Date().getTime()) <= 0L) {
                bl = true;
                break;
            }
            try {
                CommunicatorServer communicatorServer = this;
                synchronized (communicatorServer) {
                    if (l == 0L) {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        bl = this.state == n;
                        while (!bl) {
                            bl = this.state == n;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        if (this.isTraceOn()) {
                            this.trace("waitState", "Start waiting " + l2 + " current state = " + this.state);
                        }
                        this.wait(l2);
                    }
                }
                bl = this.state == n;
            }
            catch (InterruptedException interruptedException) {
                boolean bl2 = bl = this.state == n;
            }
        }
        if (this.isTraceOn()) {
            this.trace("waitState", "End, TO=" + l2);
        }
        return this.state == n;
    }
}

