/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;

class GenericHttpRequestHandler
extends ClientHandler {
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpRequestHandler(GenericHttpConnectorServer genericHttpConnectorServer, int n, GenericHttpSocket genericHttpSocket, MBeanServer mBeanServer, ObjectName objectName) {
        super(genericHttpConnectorServer, n, mBeanServer, objectName);
        if (mBeanServer == null) {
            throw new CommunicationException("No MBeanServer provided");
        }
        this.sockClient = genericHttpSocket;
        this.thread.start();
    }

    protected boolean authenticateRequest(HttpRequest httpRequest) throws IOException {
        boolean bl = true;
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        if (genericHttpConnectorServer.isAuthenticationOn()) {
            if (httpRequest.authorization == null || !httpRequest.authorization.startsWith("CRAM-MD5 ")) {
                bl = false;
            } else {
                String string = httpRequest.authorization.substring("CRAM-MD5 ".length());
                byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                String string2 = new String(byArray);
                bl = genericHttpConnectorServer.checkChallengeResponse(string2);
            }
            if (this.isDebugOn()) {
                if (bl) {
                    this.debug("processRequest", "Authentication succeeded");
                } else {
                    this.debug("processRequest", "Authentication failed");
                }
            }
        }
        return bl;
    }

    private void closeClient() {
        if (this.isTraceOn()) {
            this.trace("closeClient", "Close client ...");
        }
        if (this.sockClient != null) {
            try {
                try {
                    this.sockClient.doDisconnect();
                }
                catch (IOException iOException) {
                }
                catch (CommunicationException communicationException) {
                }
                Object var2_1 = null;
                this.sockClient = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.sockClient = null;
                throw throwable;
            }
        }
    }

    private ObjectInstance createMBean(String string, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        return this.mbs.createMBean(string, objectName);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        return this.mbs.createMBean(string, objectName, objectName2);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        return this.mbs.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        return this.mbs.createMBean(string, objectName, objectArray, stringArray);
    }

    public void doRun() {
        try {
            block19: {
                try {
                    HttpRequest httpRequest = new HttpRequest(new HttpBody());
                    boolean bl = true;
                    while (bl) {
                        HttpResponse httpResponse = null;
                        try {
                            httpRequest.readFrom(this.sockClient.doGetInputStream());
                            httpResponse = this.processRequest(httpRequest);
                        }
                        catch (MalformedHttpException malformedHttpException) {
                            if (this.isDebugOn()) {
                                this.debug("doRun", "Malformed HTTP request rejected");
                            }
                            httpResponse = this.makeErrorResponse(400, "Bad Request");
                        }
                        httpResponse.connection = httpRequest.connection;
                        httpResponse.writeTo(this.sockClient.doGetOutputStream());
                        boolean bl2 = bl = httpResponse.hasKeepAliveFlag() && !this.interruptCalled;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Request handler interrupted");
                    }
                }
                catch (EOFException eOFException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Connection closed by peer");
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        if (this.isDebugOn()) {
                            this.debug("doRun", "Request handler interrupted");
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("doRun", "I/O exception " + socketException);
                    }
                }
                catch (IOException iOException) {
                    if (!this.isDebugOn()) break block19;
                    this.debug("doRun", "I/O exception " + iOException);
                }
            }
            Object var2_6 = null;
            this.closeClient();
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket is now closed");
            }
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.closeClient();
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket is now closed");
            }
            throw throwable;
        }
    }

    private Object getAttribute(ObjectName objectName, String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("getAttribute", "getAttribute");
        }
        return this.mbs.getAttribute(objectName, string);
    }

    private AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("getAttributes", "getAttributes");
        }
        return this.mbs.getAttributes(objectName, stringArray);
    }

    private String getChallenge() {
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        if (genericHttpConnectorServer.isAuthenticationOn()) {
            String string = genericHttpConnectorServer.generateChallengeResponse();
            int n = 57;
            String string2 = new String();
            String string3 = null;
            int n2 = string.length() / 57;
            int n3 = string.length() % 57;
            int n4 = 0;
            while (n4 < n2) {
                string3 = string.substring(n4 * 57, (n4 + 1) * 57);
                string2 = String.valueOf(string2) + new BASE64Encoder().encode(string3.getBytes());
                ++n4;
            }
            if (n3 > 0) {
                string3 = string.substring(n2 * 57);
                string2 = String.valueOf(string2) + new BASE64Encoder().encode(string3.getBytes());
            }
            return "CRAM-MD5 " + string2;
        }
        return null;
    }

    private String getDefaultDomain() {
        if (this.isTraceOn()) {
            this.trace("getDefaultDomain", "getDefaultDomain");
        }
        return this.mbs.getDefaultDomain();
    }

    private Integer getMBeanCount() {
        if (this.isTraceOn()) {
            this.trace("getMBeanCount", "getMBeanCount");
        }
        return this.mbs.getMBeanCount();
    }

    private MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("getMBeanInfo", "getMBeanInfo");
        }
        return this.mbs.getMBeanInfo(objectName);
    }

    private String getMBeanServerId() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerId", "getMBeanServerId");
        }
        try {
            return (String)this.mbs.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("getObjectInstance", "getObjectInstance");
        }
        return this.mbs.getObjectInstance(objectName);
    }

    private Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("invoke", "invoke");
        }
        return this.mbs.invoke(objectName, string, objectArray, stringArray);
    }

    private boolean isRegistered(ObjectName objectName) {
        if (this.isTraceOn()) {
            this.trace("isRegistered", "isRegistered");
        }
        return this.mbs.isRegistered(objectName);
    }

    protected String makeDebugTag() {
        return "GenericHttpRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        HttpResponse httpResponse = new HttpResponse(new HttpBody());
        httpResponse.statusCode = n;
        httpResponse.reasonPhrase = string;
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        httpResponse.wwwAuthenticate = this.getChallenge();
        return httpResponse;
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = this.serialize("Exception", exception);
        }
        catch (IOException iOException) {
            this.makeErrorResponse(400, "Bad Request");
        }
        HttpBody httpBody = new HttpBody(byteArrayOutputStream.toByteArray());
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 400;
        httpResponse.reasonPhrase = "Bad Request";
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        httpResponse.wwwAuthenticate = this.getChallenge();
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(byte[] byArray) {
        HttpBody httpBody = new HttpBody(byArray);
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 200;
        httpResponse.reasonPhrase = "OK";
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        httpResponse.wwwAuthenticate = this.getChallenge();
        return httpResponse;
    }

    private String pingHeartBeatServer(String string, int n, int n2, Long l) {
        if (this.isTraceOn()) {
            this.trace("pingHeartBeatServer", "pingHeartBeatServer");
        }
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        return genericHttpConnectorServer.heartbeatServerHandler.pingHeartBeatServer(string, n, n2, l);
    }

    protected HttpResponse processPostRequest(HttpRequest httpRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        String string;
        Object object;
        block37: {
            String string2 = null;
            String string3 = null;
            ObjectName objectName = null;
            ObjectName objectName2 = null;
            Object[] objectArray = null;
            String[] stringArray = null;
            String string4 = null;
            String[] stringArray2 = null;
            String string5 = null;
            QueryExp queryExp = null;
            Attribute attribute = null;
            AttributeList attributeList = null;
            Integer n = null;
            String string6 = null;
            Integer n2 = null;
            Integer n3 = null;
            Long l = null;
            if (this.isTraceOn()) {
                this.trace("processPostRequest", "Process a POST request = " + httpRequest.getURIPath());
            }
            if (httpRequest.contentLength == 0) {
                return this.makeExceptionResponse(new CommunicationException("Content is null"));
            }
            object = null;
            string = null;
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            byteArrayOutputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(httpRequest.body.getBytes());
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                string2 = (String)objectInputStream.readObject();
                if (this.isTraceOn()) {
                    this.trace("doRun", "Remote operation: " + string2);
                }
                if (string2.equals("createMBean")) {
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    object = this.createMBean(string3, objectName);
                    string = "ObjectInstance";
                    break block37;
                }
                if (string2.equals("createMBeanParams")) {
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectInputStream = this.mbs.deserialize(string3, httpRequest.body.getBytes());
                    string2 = (String)objectInputStream.readObject();
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectArray = (Object[])objectInputStream.readObject();
                    stringArray = (String[])objectInputStream.readObject();
                    object = this.createMBean(string3, objectName, objectArray, stringArray);
                    string = "ObjectInstance";
                    break block37;
                }
                if (string2.equals("createMBeanLoader")) {
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectName2 = (ObjectName)objectInputStream.readObject();
                    object = this.createMBean(string3, objectName, objectName2);
                    string = "ObjectInstance";
                    break block37;
                }
                if (string2.equals("createMBeanLoaderParams")) {
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectName2 = (ObjectName)objectInputStream.readObject();
                    objectInputStream = this.mbs.deserialize(string3, objectName2, httpRequest.body.getBytes());
                    string2 = (String)objectInputStream.readObject();
                    string3 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectName2 = (ObjectName)objectInputStream.readObject();
                    objectArray = (Object[])objectInputStream.readObject();
                    stringArray = (String[])objectInputStream.readObject();
                    object = this.createMBean(string3, objectName, objectName2, objectArray, stringArray);
                    string = "ObjectInstance";
                    break block37;
                }
                if (string2.equals("getAttribute")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    string4 = (String)objectInputStream.readObject();
                    object = this.getAttribute(objectName, string4);
                    string = "Object";
                    break block37;
                }
                if (string2.equals("getAttributes")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    stringArray2 = (String[])objectInputStream.readObject();
                    object = this.getAttributes(objectName, stringArray2);
                    string = "AttributeList";
                    break block37;
                }
                if (string2.equals("getDefaultDomain")) {
                    object = this.getDefaultDomain();
                    string = "String";
                    break block37;
                }
                if (string2.equals("getObjectInstance")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    object = this.getObjectInstance(objectName);
                    string = "ObjectInstance";
                    break block37;
                }
                if (string2.equals("getMBeanCount")) {
                    object = this.getMBeanCount();
                    string = "Integer";
                    break block37;
                }
                if (string2.equals("getMBeanServerId")) {
                    object = this.getMBeanServerId();
                    string = "String";
                    break block37;
                }
                if (string2.equals("getMBeanInfo")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    object = this.getMBeanInfo(objectName);
                    string = "MBeanInfo";
                    break block37;
                }
                if (string2.equals("invoke")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectInputStream = this.mbs.deserialize(objectName, httpRequest.body.getBytes());
                    string2 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    string5 = (String)objectInputStream.readObject();
                    objectArray = (Object[])objectInputStream.readObject();
                    stringArray = (String[])objectInputStream.readObject();
                    object = this.invoke(objectName, string5, objectArray, stringArray);
                    string = "Object";
                    break block37;
                }
                if (string2.equals("isRegistered")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    object = new Boolean(this.isRegistered(objectName));
                    string = "Boolean";
                    break block37;
                }
                if (string2.equals("queryNames")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    queryExp = (QueryExp)objectInputStream.readObject();
                    object = this.queryNames(objectName, queryExp);
                    string = "Set";
                    break block37;
                }
                if (string2.equals("queryMBeans")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    queryExp = (QueryExp)objectInputStream.readObject();
                    object = this.queryMBeans(objectName, queryExp);
                    string = "Set";
                    break block37;
                }
                if (string2.equals("setAttribute")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectInputStream = this.mbs.deserialize(objectName, httpRequest.body.getBytes());
                    string2 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    attribute = (Attribute)objectInputStream.readObject();
                    this.setAttribute(objectName, attribute);
                    object = null;
                    string = "Object";
                    break block37;
                }
                if (string2.equals("setAttributes")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    objectInputStream = this.mbs.deserialize(objectName, httpRequest.body.getBytes());
                    string2 = (String)objectInputStream.readObject();
                    objectName = (ObjectName)objectInputStream.readObject();
                    attributeList = (AttributeList)objectInputStream.readObject();
                    object = this.setAttributes(objectName, attributeList);
                    string = "AttributeList";
                    break block37;
                }
                if (string2.equals("unregisterMBean")) {
                    objectName = (ObjectName)objectInputStream.readObject();
                    this.unregisterMBean(objectName);
                    object = null;
                    string = "Object";
                    break block37;
                }
                if (string2.equals("remoteRequest")) {
                    n = (Integer)objectInputStream.readObject();
                    objectArray = (Object[])objectInputStream.readObject();
                    object = this.remoteRequest(n, objectArray);
                    string = "Object[]";
                    break block37;
                }
                if (string2.equals("pingHeartBeatServer")) {
                    string6 = (String)objectInputStream.readObject();
                    n2 = (Integer)objectInputStream.readObject();
                    n3 = (Integer)objectInputStream.readObject();
                    l = (Long)objectInputStream.readObject();
                    object = this.pingHeartBeatServer(string6, n2, n3, l);
                    string = "String";
                    break block37;
                }
                if (this.isTraceOn()) {
                    this.trace("doRun", "Unknown remote operation: " + string2);
                }
                return this.makeErrorResponse(400, "Bad Request");
            }
            catch (MBeanException mBeanException) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + mBeanException.getMessage());
                }
                return this.makeExceptionResponse(mBeanException);
            }
            catch (OperationsException operationsException) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + operationsException.getMessage());
                }
                return this.makeExceptionResponse(operationsException);
            }
            catch (ReflectionException reflectionException) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + reflectionException.getMessage());
                }
                return this.makeExceptionResponse(reflectionException);
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + iOException.getMessage());
                }
                return this.makeExceptionResponse(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + classNotFoundException.getMessage());
                }
                return this.makeExceptionResponse(classNotFoundException);
            }
            catch (Exception exception) {
                if (this.isTraceOn()) {
                    this.trace("doRun", String.valueOf(string2) + ":" + exception.getMessage());
                }
                return this.makeExceptionResponse(exception);
            }
        }
        byteArrayOutputStream = this.serialize(string, object);
        return this.makeOkResponse(byteArrayOutputStream.toByteArray());
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.isTraceOn()) {
            this.trace("processRequest", "Process the HTTP request");
        }
        HttpResponse httpResponse = null;
        if (!this.authenticateRequest(httpRequest)) {
            httpResponse = this.makeErrorResponse(401, "Unauthorized");
        } else if (httpRequest.method == 2) {
            httpResponse = this.processPostRequest(httpRequest);
        } else {
            if (this.isDebugOn()) {
                this.debug("processRequest", "Bad request: Request method not supported");
            }
            httpResponse = this.makeErrorResponse(400, "Bad Request");
        }
        return httpResponse;
    }

    private Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (this.isTraceOn()) {
            this.trace("queryMBeans", "queryMBeans");
        }
        return this.mbs.queryMBeans(objectName, queryExp);
    }

    private Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (this.isTraceOn()) {
            this.trace("queryNames", "queryNames");
        }
        return this.mbs.queryNames(objectName, queryExp);
    }

    private Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("remoteRequest", "remoteRequest");
        }
        GenericHttpConnectorServer genericHttpConnectorServer = (GenericHttpConnectorServer)this.adaptorServer;
        return genericHttpConnectorServer.serverNotificationDispatcher.remoteRequest(n, objectArray);
    }

    private ByteArrayOutputStream serialize(String string, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream;
    }

    private void setAttribute(ObjectName objectName, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("setAttribute", "setAttribute");
        }
        this.mbs.setAttribute(objectName, attribute);
    }

    private AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("setAttributes", "setAttributes");
        }
        return this.mbs.setAttributes(objectName, attributeList);
    }

    private void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.isTraceOn()) {
            this.trace("unregisterMBean", "unregisterMBean");
        }
        this.mbs.unregisterMBean(objectName);
    }
}

