/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import java.util.Vector;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected String dbgTag = this.makeDebugTag();
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector varBind;
    protected int[] translation;

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduPacket snmpPduPacket) {
        if (this.isTraceOn()) {
            this.trace("constructor", "creating instance for request " + String.valueOf(snmpPduPacket.requestId));
        }
        this.version = snmpPduPacket.version;
        this.type = snmpPduPacket.type;
        this.agent = snmpMibAgent;
        int n = snmpPduPacket.varBindList.length;
        this.translation = new int[n];
        this.varBind = new NonSyncVector(n);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPduPacket snmpPduPacket, boolean bl) {
        this(snmpMibAgent, snmpPduPacket);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPduPacket.varBindList;
        int n2 = 0;
        while (n2 < n) {
            this.translation[n2] = n2;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[n2]);
            ++n2;
        }
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, 1024, string, string2, string3);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        if (this.version == 0 && (this.errorStatus == 224 || this.errorStatus == 225)) {
            return 2;
        }
        return this.errorStatus;
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, 1024);
    }

    protected boolean isTraceOn() {
        return Trace.isSelected(1, 1024);
    }

    protected String makeDebugTag() {
        return "SnmpSubRequestHandler";
    }

    public void run() {
        block16: {
            try {
                switch (this.type) {
                    case 160: {
                        if (this.isTraceOn()) {
                            this.trace("run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                        }
                        this.agent.get(this.varBind, this.version);
                        break;
                    }
                    case 161: {
                        if (this.isTraceOn()) {
                            this.trace("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                        }
                        this.agent.getNext(this.varBind, this.version);
                        break;
                    }
                    case 163: {
                        if (this.isTraceOn()) {
                            this.trace("run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                        }
                        this.agent.set(this.varBind, this.version);
                        break;
                    }
                    case 253: {
                        if (this.isTraceOn()) {
                            this.trace("run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                        }
                        this.agent.check(this.varBind);
                        break;
                    }
                    default: {
                        if (this.isDebugOn()) {
                            this.debug("run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                        }
                        this.errorStatus = 5;
                        this.errorIndex = 1;
                        break;
                    }
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:a Snmp error occured during the operation");
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!this.isDebugOn()) break block16;
                this.debug("run", "[" + Thread.currentThread() + "]a generic error occured during the operation");
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, 1024, string, string2, string3);
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n = this.varBind.size();
        int n2 = snmpVarBindArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.translation[n3];
            if (n4 < n2) {
                snmpVarBindArray[n4] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(n3);
            } else {
                this.debug("updateResult", "Position `" + n4 + "' is out of bound...");
            }
            ++n3;
        }
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n) {
            return this.elementData[n];
        }
    }
}

