/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMonitor;
import com.sun.jdmk.discovery.DiscoveryResponderNotification;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Vector;

class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static long sequenceNumber = 0L;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private transient boolean stopRequested = false;
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();

    public ActualMonitor(String string, int n, DiscoveryMonitor discoveryMonitor) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualMonitor";
        if (this.isTraceOn()) {
            this.trace("constructor ", "initialize multicast socket");
        }
        this.multicastGroup = string;
        this.multicastPort = n;
        this.monitor = discoveryMonitor;
    }

    private void processMsg(ResponsePDU responsePDU) throws IOException {
        if (responsePDU == null) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "received a nul pdu '");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("processMsg ", "received pdu '" + responsePDU.printState() + "'");
        }
        if (!responsePDU.getEvent()) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "not an event message");
            }
            return;
        }
        DiscoveryResponse discoveryResponse = new DiscoveryResponse();
        discoveryResponse.host = responsePDU.getHost();
        discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
        discoveryResponse.specificationName = responsePDU.getSpecificationName();
        discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
        discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
        discoveryResponse.implementationName = responsePDU.getImplementationName();
        discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
        discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
        discoveryResponse.objectList = responsePDU.getObjectList();
        DiscoveryResponderNotification discoveryResponderNotification = new DiscoveryResponderNotification(this.monitor, responsePDU.getAgentState(), discoveryResponse, ++sequenceNumber);
        this.monitor.sendNotification(discoveryResponderNotification);
    }

    public void run() {
        if (this.isTraceOn()) {
            this.trace("run ", "start");
        }
        try {
            this.connectToGroup();
        }
        catch (IOException iOException) {
            this.stopRequested = true;
        }
        while (!this.stopRequested) {
            this.state = 0;
            try {
                if (this.isTraceOn()) {
                    this.trace("run ", "Start Waiting ");
                }
                ResponsePDU responsePDU = (ResponsePDU)this.receiveMsg(this);
                this.processMsg(responsePDU);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isTraceOn()) {
                    this.trace("run ", "Stop execution ");
                }
                this.stopRequested = true;
            }
            catch (IOException iOException) {
                if (!this.isTraceOn()) continue;
                this.trace("run ", "Not a event msg - continue - ");
            }
            catch (ClassCastException classCastException) {
                if (!this.isTraceOn()) continue;
                this.trace("run ", "Not a event msg - continue - ");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.isTraceOn()) continue;
                this.trace("run ", "Not a event msg - continue - ");
            }
        }
        try {
            this.disconnectFromGroup();
            this.state = 1;
        }
        catch (IOException iOException) {}
    }

    public void stopMonitor() {
        this.stopRequested = true;
    }
}

