/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.Trace;
import com.sun.jdmk.discovery.ActualResponder;
import com.sun.jdmk.discovery.DiscoveryResponderMBean;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiscoveryResponder
implements Serializable,
DiscoveryResponderMBean,
MBeanRegistration {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    private int infoType = 4096;
    private String localClassName;
    private String dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryResponder";
    private static final String sccs_id = "@(#)DiscoveryResponder.java 4.19 00/03/15 SMI";
    private int multicastPort;
    private String multicastGroup;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int ttl = 1;
    private MBeanServer cmf = null;
    private ObjectName responderObjectName = null;
    private transient ActualResponder responder = null;
    private transient Thread responderThread = null;
    private static final String HOST = "host";
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private static final String TTL = "ttl";
    private static final String SPY = "spy";
    private String spy = "";
    private String noEvent = null;
    private transient int state = 1;

    public DiscoveryResponder() {
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + this.multicastGroup + "'");
            this.trace("constructor ", "Set port  to '" + this.multicastPort + "'");
        }
    }

    public DiscoveryResponder(String string, int n) {
        this.multicastGroup = string;
        this.multicastPort = n;
        if (this.isTraceOn()) {
            this.trace("constructor ", "Set group to '" + string + "'");
            this.trace("constructor ", "Set port  to '" + n + "'");
        }
    }

    private void debug(String string, Exception exception) {
        this.debug(this.localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, this.infoType, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
        }
        return string;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean isActive() {
        return this.state == 0;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.state == 0) {
            this.stop();
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister ", "object name   = " + objectName);
        }
        this.responderObjectName = objectName;
        this.spy = objectName.getKeyProperty(SPY);
        this.noEvent = objectName.getKeyProperty("PRIVATE_NO_EVENT");
        this.cmf = mBeanServer;
        return objectName;
    }

    public void setMulticastGroup(String string) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = string;
    }

    public void setMulticastPort(int n) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = n;
    }

    public void setTimeToLive(int n) throws IllegalStateException {
        if (this.state == 1) {
            if (n <= 0 || n > 255) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.ttl = n;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            if (this.cmf == null) {
                if (this.isTraceOn()) {
                    this.trace("start ", "Can't start discoveryResponder: JDMK MBeanServer is not set");
                }
                return;
            }
            try {
                if (this.isTraceOn()) {
                    this.trace("start ", "Create a new responder");
                }
                this.responder = new ActualResponder(this.multicastGroup, this.multicastPort, this.getTimeToLive(), this.cmf, this.spy);
                if (this.noEvent != null) {
                    this.responder.noEvent();
                }
                if (this.isTraceOn()) {
                    this.trace("start ", "call responder connect");
                }
                this.responder.connectToGroup();
                this.responderThread = new Thread(this.responder);
                this.responderThread.setName("Multicast responder");
                this.responderThread.start();
                this.state = 0;
            }
            catch (SocketException socketException) {
                if (this.isDebugOn()) {
                    this.debug("start", socketException);
                }
                throw new IOException(socketException.getMessage());
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("start ", iOException);
                }
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                if (this.isDebugOn()) {
                    this.debug("start ", nullPointerException);
                }
                throw new IOException(((Throwable)nullPointerException).getMessage());
            }
        } else if (this.isTraceOn()) {
            this.trace("start ", "Responder is not OFFLINE");
        }
    }

    public void stop() {
        if (this.state == 0) {
            this.responder.stopRequested = true;
            this.responderThread.interrupt();
            this.responder = null;
            System.runFinalization();
            this.state = 1;
        } else if (this.isTraceOn()) {
            this.trace("stop ", "Responder is not ONLINE");
        }
    }

    private void trace(String string, Exception exception) {
        this.trace(this.localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, this.infoType, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }
}

