/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.IPAcl;

import com.sun.jdmk.DefaultPaths;
import com.sun.jdmk.Trace;
import com.sun.jdmk.snmp.IPAcl.AclEntryImpl;
import com.sun.jdmk.snmp.IPAcl.AclImpl;
import com.sun.jdmk.snmp.IPAcl.IPAcl;
import com.sun.jdmk.snmp.IPAcl.ParseException;
import com.sun.jdmk.snmp.IPAcl.Parser;
import com.sun.jdmk.snmp.IPAcl.PermissionImpl;
import com.sun.jdmk.snmp.IPAcl.PrincipalImpl;
import com.sun.jdmk.snmp.IPAcl.SimpleNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JdmkAcl
implements IPAcl,
Serializable {
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable destList;
    private PrincipalImpl owner;

    public JdmkAcl(String string) throws UnknownHostException {
        block2: {
            this.dbgTag = "JdmkAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.destList = null;
            this.owner = null;
            this.destList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!this.isDebugOn()) break block2;
                this.debug("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        this.setDefautFileName();
        this.readAuthorisedListFile();
    }

    public boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    public boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    public boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.destList.get(inetAddress);
        if (vector != null) {
            if (this.isTraceOn()) {
                this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (this.isTraceOn()) {
            this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    public Enumeration getTrapDestinations() {
        return this.destList.keys();
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (this.isTraceOn()) {
                this.trace("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            block13: {
                Parser parser = null;
                try {
                    parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.isDebugOn()) {
                        this.debug("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                    }
                    this.alwaysAuthorized = true;
                    return;
                }
                try {
                    object = parser.SecurityDefs();
                    ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                    ((SimpleNode)object).buildTrapEntries(this.destList);
                }
                catch (ParseException parseException) {
                    if (this.isDebugOn()) {
                        this.debug("readAuthorisedListFile", "Parsing exception " + parseException);
                    }
                }
                catch (Error error) {
                    if (!this.isDebugOn()) break block13;
                    this.debug("readAuthorisedListFile", "Error exception");
                }
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (this.isTraceOn()) {
                    this.trace("readAuthorisedListFile", "===> " + aclEntryImpl.getPrincipal().toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!this.isTraceOn()) continue;
                    this.trace("readAuthorisedListFile", "perm = " + permission);
                }
            }
        }
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.destList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public void setAuthorizedListFile(String string) {
        if (this.isTraceOn()) {
            this.trace("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
    }

    private void setDefautFileName() {
        File file;
        String string = System.getProperty("jdmk.acl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.acl");
        }
        if ((file = new File(string)).exists()) {
            if (this.isTraceOn()) {
                this.trace("setDefautFileName", "ACL file found in " + string);
            }
        } else if (this.isDebugOn()) {
            this.debug("setDefautFileName", "ACL file not found");
        }
        this.setAuthorizedListFile(string);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

