/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibAgentMBean;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibAgent
implements SnmpMibAgentMBean,
MBeanRegistration,
Serializable {
    protected String mibName;
    protected MBeanServer server;
    private ObjectName adaptorName;
    private transient SnmpMibHandler adaptor;

    public abstract void check(Vector var1) throws SnmpStatusException;

    private void concatVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            vector.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
        }
    }

    public abstract void get(Vector var1, int var2) throws SnmpStatusException;

    public boolean getBindingState() {
        return this.adaptor != null;
    }

    public abstract void getBulk(Vector var1, int var2, int var3, int var4) throws SnmpStatusException;

    void getBulkWithGetNext(Vector vector, int n, int n2, int n3) throws SnmpStatusException {
        int n4 = vector.size();
        int n5 = Math.max(Math.min(n, n4), 0);
        int n6 = Math.max(n2, 0);
        int n7 = n4 - n5;
        boolean bl = false;
        boolean bl2 = false;
        if (n4 != 0) {
            this.getNext(vector, 1);
            Vector vector2 = this.splitFrom(vector, n5);
            int n8 = 2;
            while (n8 <= n6) {
                this.getNext(vector2, 1);
                this.concatVector(vector, vector2);
                ++n8;
            }
        }
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public String getMibName() {
        return this.mibName;
    }

    public abstract void getNext(Vector var1, int var2) throws SnmpStatusException;

    public abstract long[] getRootOid();

    public SnmpMibHandler getSnmpAdaptor() {
        return this.adaptor;
    }

    public ObjectName getSnmpAdaptorName() {
        return this.adaptorName;
    }

    public abstract void init() throws IllegalAccessException;

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public abstract ObjectName preRegister(MBeanServer var1, ObjectName var2) throws Exception;

    public abstract void set(Vector var1, int var2) throws SnmpStatusException;

    public void setSnmpAdaptor(SnmpMibHandler snmpMibHandler) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = snmpMibHandler;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    public void setSnmpAdaptorName(ObjectName objectName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(String.valueOf(this.mibName) + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] objectArray = new Object[]{this};
        String[] stringArray = new String[]{"com.sun.jdmk.snmp.agent.SnmpMibAgent"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(objectName, "addMib", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        catch (ReflectionException reflectionException) {
            throw new ServiceNotFoundException(objectName.toString());
        }
        catch (MBeanException mBeanException) {}
        this.adaptorName = objectName;
    }

    private Vector splitFrom(Vector vector, int n) {
        int n2 = vector.size();
        Vector<SnmpVarBind> vector2 = new Vector<SnmpVarBind>(n2 - n);
        int n3 = n;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            if (n3 <= 0) {
                vector2.addElement(new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value));
            }
            --n3;
        }
        return vector2;
    }
}

