/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.monitor.CounterAlarmClock;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number threshold = new Integer(0);
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private boolean notify = false;
    private boolean differenceMode = false;
    private transient Number initThreshold = new Integer(0);
    private transient Number derivedGauge = new Integer(0);
    private transient long derivedGaugeTimestamp = new Date().getTime();
    private transient Number previousScanCounter = null;
    private transient boolean modulusExceeded = false;
    private transient Number derivedGaugeExceeded = null;
    private transient boolean eventAlreadyNotified = false;
    private transient int type = 0;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient CounterAlarmClock alarmClock = null;

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public Number getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public Number getOffset() {
        return this.offset;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    boolean isThresholdTypeValid() {
        boolean bl = false;
        switch (this.type) {
            case 0: {
                if (!(this.threshold instanceof Integer) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Integer) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Integer)) break;
                bl = true;
                break;
            }
            case 1: {
                if (!(this.threshold instanceof Byte) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Byte) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Byte)) break;
                bl = true;
                break;
            }
            case 2: {
                if (!(this.threshold instanceof Short) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Short) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Short)) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(this.threshold instanceof Long) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Long) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Long)) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isThresholdTypeValid", "the threshold type is invalid");
            }
        }
        return bl;
    }

    String makeDebugTag() {
        return "CounterMonitor";
    }

    void notifyAlarmClock() {
        block27: {
            Object object = null;
            String string = null;
            try {
                boolean bl;
                if (!this.isActive()) break block27;
                if (this.getObservedObject() == null || this.getObservedAttribute() == null) {
                    this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                    this.alarmClock.start();
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(), this.getObservedAttribute());
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException("The counter monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotified & 1) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.alreadyNotified |= 1;
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (object instanceof Integer) {
                    this.type = 0;
                } else if (object instanceof Byte) {
                    this.type = 1;
                } else if (object instanceof Short) {
                    this.type = 2;
                } else if (object instanceof Long) {
                    this.type = 3;
                } else {
                    if ((this.alreadyNotified & 4) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.alreadyNotified |= 4;
                    throw new MonitorSettingException("The observed attribute type must be an integer type.");
                }
                if (!this.isThresholdTypeValid()) {
                    if ((this.alreadyNotified & 0x10) != 0) {
                        this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.THRESHOLD_ERROR;
                    this.alreadyNotified |= 0x10;
                    throw new MonitorSettingException("The threshold, offset and modulus must be of the same type as the counter.");
                }
                this.alreadyNotified = 0;
                if (this.modulusExceeded && this.derivedGauge.longValue() < this.derivedGaugeExceeded.longValue()) {
                    this.threshold = this.initThreshold;
                    this.modulusExceeded = false;
                    this.eventAlreadyNotified = false;
                }
                if (bl = this.updateDerivedGauge(object)) {
                    this.updateNotifications();
                    this.updateThreshold();
                }
                this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp, monitorSettingException.getMessage(), this.derivedGauge, null);
                this.modulusExceeded = false;
                this.eventAlreadyNotified = false;
                this.previousScanCounter = null;
                this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
        }
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        this.threshold = this.initThreshold;
    }

    void setDerivedGaugeWithDifference(Number number, Number number2) {
        switch (this.type) {
            case 0: {
                if (number2 == null) {
                    this.derivedGauge = new Integer((Integer)number - (Integer)this.previousScanCounter);
                    break;
                }
                this.derivedGauge = new Integer((Integer)number - (Integer)this.previousScanCounter + (Integer)this.modulus);
                break;
            }
            case 1: {
                if (number2 == null) {
                    this.derivedGauge = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter));
                    break;
                }
                this.derivedGauge = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter + (Byte)this.modulus));
                break;
            }
            case 2: {
                if (number2 == null) {
                    this.derivedGauge = new Short((short)((Short)number - (Short)this.previousScanCounter));
                    break;
                }
                this.derivedGauge = new Short((short)((Short)number - (Short)this.previousScanCounter + (Short)this.modulus));
                break;
            }
            case 3: {
                if (number2 == null) {
                    this.derivedGauge = new Long((Long)number - (Long)this.previousScanCounter);
                    break;
                }
                this.derivedGauge = new Long((Long)number - (Long)this.previousScanCounter + (Long)this.modulus);
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    public void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        this.threshold = this.initThreshold;
        this.modulusExceeded = false;
        this.eventAlreadyNotified = false;
        this.previousScanCounter = null;
    }

    public void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The modulus cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The modulus must be greater than or equal to zero.");
        }
        this.modulus = number;
        this.alreadyNotified &= 0xFFFFFFEF;
        this.modulusExceeded = false;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The offset cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The offset must be greater than or equal to zero.");
        }
        this.offset = number;
        this.alreadyNotified &= 0xFFFFFFEF;
    }

    public void setThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The threshold cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold must be greater than or equal to zero.");
        }
        this.threshold = number;
        this.initThreshold = number;
        this.alreadyNotified &= 0xFFFFFFEF;
        this.modulusExceeded = false;
        this.eventAlreadyNotified = false;
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        if (!this.isActive()) {
            this.alarmClock = new CounterAlarmClock(this, this.getGranularityPeriod());
            this.alarmClock.start();
            this.isActive = true;
            this.threshold = this.initThreshold;
            this.modulusExceeded = false;
            this.eventAlreadyNotified = false;
            this.previousScanCounter = null;
        } else if (this.isTraceOn()) {
            this.trace("start", "the counter monitor is already activated");
        }
    }

    public synchronized void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        if (this.isActive()) {
            if (this.alarmClock != null) {
                this.alarmClock.interrupt();
                try {
                    this.alarmClock.join();
                }
                catch (InterruptedException interruptedException) {}
                this.alarmClock = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the counter monitor is already deactivated");
        }
    }

    private boolean updateDerivedGauge(Object object) {
        boolean bl;
        this.derivedGaugeTimestamp = new Date().getTime();
        if (this.differenceMode) {
            if (this.previousScanCounter != null) {
                this.setDerivedGaugeWithDifference((Number)object, null);
                if (this.derivedGauge.longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)object, this.modulus);
                    }
                    this.threshold = this.initThreshold;
                    this.eventAlreadyNotified = false;
                }
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanCounter = (Number)object;
        } else {
            this.derivedGauge = (Number)object;
            bl = true;
        }
        return bl;
    }

    private void updateNotifications() {
        Object var1_1 = null;
        if (!this.eventAlreadyNotified) {
            if (this.derivedGauge.longValue() >= this.threshold.longValue()) {
                if (this.notify) {
                    this.sendNotification(MonitorNotification.THRESHOLD_VALUE_EXCEEDED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.threshold);
                }
                this.eventAlreadyNotified = true;
            }
        } else if (this.isTraceOn()) {
            this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject() + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge + "has already been sent");
        }
    }

    private void updateThreshold() {
        if (this.derivedGauge.longValue() >= this.threshold.longValue()) {
            if (this.offset.longValue() > 0L) {
                long l = this.threshold.longValue();
                while (this.derivedGauge.longValue() >= l) {
                    l += this.offset.longValue();
                }
                switch (this.type) {
                    case 0: {
                        this.threshold = new Integer((int)l);
                        break;
                    }
                    case 1: {
                        this.threshold = new Byte((byte)l);
                        break;
                    }
                    case 2: {
                        this.threshold = new Short((short)l);
                        break;
                    }
                    case 3: {
                        this.threshold = new Long(l);
                        break;
                    }
                    default: {
                        if (!this.isDebugOn()) break;
                        this.debug("updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold.longValue() > this.modulus.longValue()) {
                    this.modulusExceeded = true;
                    this.derivedGaugeExceeded = this.derivedGauge;
                }
                this.eventAlreadyNotified = false;
            } else {
                this.modulusExceeded = true;
                this.derivedGaugeExceeded = this.derivedGauge;
            }
        }
    }
}

