/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import javax.management.snmp.SnmpCounter;
import javax.management.snmp.SnmpCounter64;
import javax.management.snmp.SnmpDataTypeEnums;
import javax.management.snmp.SnmpGauge;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpIpAddress;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpOpaque;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpStringFixed;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class SnmpVar
extends SnmpVarBind
implements SnmpDataTypeEnums,
Cloneable {
    public static final String[] statusLegend = new String[]{"Status Mapper", "Value not initialized", "Valid Value", "No such object", "No such Instance", "End of Mib View"};
    public static final int stValueUnspecified = 1;
    public static final int stValueOk = 2;
    public static final int stValueNoSuchObject = 3;
    public static final int stValueNoSuchInstance = 4;
    public static final int stValueEndOfMibView = 5;
    private int _status;

    public SnmpVar(String string) throws SnmpStatusException {
        block5: {
            this._status = 1;
            if (string.startsWith(".")) {
                this.oid = new SnmpOid(string);
            } else {
                SnmpOidRecord snmpOidRecord = null;
                try {
                    int n = string.indexOf(46);
                    this.handleLong(string, n);
                    this.oid = new SnmpOid(string);
                }
                catch (NumberFormatException numberFormatException) {
                    int n = string.indexOf(46);
                    if (n <= 0) {
                        snmpOidRecord = this.resolveVarName(string);
                        this.oid = new SnmpOid(snmpOidRecord.getName());
                        break block5;
                    }
                    snmpOidRecord = this.resolveVarName(string.substring(0, n));
                    this.oid = new SnmpOid(String.valueOf(snmpOidRecord.getName()) + string.substring(n));
                }
            }
        }
    }

    public SnmpVar(SnmpOid snmpOid) {
        this._status = 1;
        this.oid = snmpOid;
    }

    public SnmpVar(SnmpOid snmpOid, SnmpValue snmpValue) {
        this._status = 1;
        this.oid = snmpOid;
        this.setSnmpValue(snmpValue);
    }

    public final void addInstance(long l) {
        this.oid.append(l);
    }

    public final void addInstance(String string) throws SnmpStatusException {
        if (string != null) {
            this.oid.addToOid(string);
        }
    }

    public final void addInstance(long[] lArray) throws SnmpStatusException {
        this.oid.addToOid(lArray);
    }

    public final void clearValue() {
        this.value = null;
        this._status = 1;
    }

    public final Object clone() {
        SnmpVar snmpVar = null;
        try {
            snmpVar = (SnmpVar)super.clone();
            snmpVar.copyValueAndOid(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpVar;
    }

    public final Object cloneWithoutValue() {
        SnmpOid snmpOid = (SnmpOid)this.oid.clone();
        return new SnmpVar(snmpOid);
    }

    public void copyValue(SnmpVar snmpVar) {
        if (snmpVar.validValue()) {
            this.value = snmpVar.getSnmpValue().duplicate();
            this.setValueValid();
        } else {
            this._status = snmpVar.getValueStatus();
        }
    }

    public void copyValueAndOid(SnmpVar snmpVar) {
        this.setOid((SnmpOid)snmpVar.getOid().clone());
        this.copyValue(snmpVar);
    }

    public final SnmpOid getOid() {
        return this.oid;
    }

    public final SnmpCounter64 getSnmpCounter64Value() throws ClassCastException {
        return (SnmpCounter64)this.value;
    }

    public final SnmpCounter getSnmpCounterValue() throws ClassCastException {
        return (SnmpCounter)this.value;
    }

    public final SnmpGauge getSnmpGaugeValue() throws ClassCastException {
        return (SnmpGauge)this.value;
    }

    public final SnmpInt getSnmpIntValue() throws ClassCastException {
        return (SnmpInt)this.value;
    }

    public final SnmpIpAddress getSnmpIpAddressValue() throws ClassCastException {
        return (SnmpIpAddress)this.value;
    }

    public final SnmpOid getSnmpOidValue() throws ClassCastException {
        return (SnmpOid)this.value;
    }

    public final SnmpOpaque getSnmpOpaqueValue() throws ClassCastException {
        return (SnmpOpaque)this.value;
    }

    public final SnmpStringFixed getSnmpStringFixedValue() throws ClassCastException {
        return (SnmpStringFixed)this.value;
    }

    public final SnmpString getSnmpStringValue() throws ClassCastException {
        return (SnmpString)this.value;
    }

    public final SnmpTimeticks getSnmpTimeticksValue() throws ClassCastException {
        return (SnmpTimeticks)this.value;
    }

    public final synchronized SnmpValue getSnmpValue() {
        return this.value;
    }

    public final String getStringValue() {
        return this.value.toString();
    }

    public final int getValueStatus() {
        return this._status;
    }

    public final String getValueStatusLegend() {
        return statusLegend[this._status];
    }

    private void handleLong(String string, int n) throws NumberFormatException, SnmpStatusException {
        String string2 = n > 0 ? string.substring(0, n) : string;
        Long.parseLong(string2);
    }

    public final synchronized boolean hasVbException() {
        switch (this._status) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void illegalCall(String string) throws SnmpStatusException {
        throw new SnmpStatusException(string);
    }

    public final boolean isOidEqual(SnmpVar snmpVar) {
        return this.oid.equals(snmpVar.getOid());
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidTable snmpOidTable = SnmpOid.getSnmpOidTable();
        if (snmpOidTable == null) {
            throw new SnmpStatusException(2);
        }
        int n = string.indexOf(46);
        if (n < 0) {
            return snmpOidTable.resolveVarName(string);
        }
        return snmpOidTable.resolveVarOid(string);
    }

    public final void setOid(SnmpOid snmpOid) {
        this.oid = snmpOid;
        this.clearValue();
    }

    public final void setSnmpCounter64Value(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter64(l);
        this.setValueValid();
    }

    public final void setSnmpCounterValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter(l);
        this.setValueValid();
    }

    public final void setSnmpGaugeValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpGauge(l);
        this.setValueValid();
    }

    public final void setSnmpIntValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpInt(l);
        this.setValueValid();
    }

    public final void setSnmpIpAddressValue(String string) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpIpAddress(string);
        this.setValueValid();
    }

    public final void setSnmpOidValue(String string) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpOid(string);
        this.setValueValid();
    }

    public final void setSnmpOpaqueValue(byte[] byArray) {
        this.clearValue();
        this.value = new SnmpOpaque(byArray);
        this.setValueValid();
    }

    public final void setSnmpStringFixedValue(String string) {
        this.clearValue();
        this.value = new SnmpStringFixed(string);
        this.setValueValid();
    }

    public final void setSnmpStringValue(String string) {
        this.clearValue();
        this.value = new SnmpString(string);
        this.setValueValid();
    }

    public final void setSnmpTimeticksValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpTimeticks(l);
        this.setValueValid();
    }

    public final void setSnmpValue(SnmpValue snmpValue) {
        this.value = snmpValue;
        this.setValueValid();
    }

    public final void setValueEndOfMibView() {
        this._status = 5;
    }

    public final void setValueNoSuchInstance() {
        this._status = 4;
    }

    public final void setValueNoSuchObject() {
        this._status = 3;
    }

    private void setValueValid() {
        this._status = 2;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("Object ID : " + this.oid.toString());
        if (this.validValue()) {
            stringBuffer.append("  (Syntax : " + this.value.getTypeName() + ")\n");
            stringBuffer.append("Value : " + this.value.toString());
        } else {
            stringBuffer.append("\nValue Exception : " + this.getValueStatusLegend());
        }
        return stringBuffer.toString();
    }

    public final synchronized boolean unspecifiedValue() {
        return this._status == 1;
    }

    public final boolean validValue() {
        return this._status == 2;
    }
}

