/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.im.iiimp.InvalidSyntaxException;
import sun.awt.im.iiimp.LWESyntax;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.PCE;
import sun.awt.im.iiimp.ProtocolDriver;

class ManageRule {
    private static final String PROTOCOL_DRIVER_NAME = "sun.awt.im.iiimp.ProtocolDriver";
    private static final String DEFAULT_PCE_RULE = "sun/awt/im/iiimp/sample.lwesyntax";
    private String ruleString = null;
    private Vector imVector;
    private PCE pce;
    private String ccdef;

    ManageRule(String string) {
        this.ruleString = string;
        this.parseRule(this.ruleString);
    }

    ManageRule(InputStreamReader inputStreamReader) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ruleString = stringBuffer.toString();
        this.parseRule(this.ruleString);
    }

    public String toString() {
        return this.ruleString;
    }

    int size() {
        return this.imVector.size();
    }

    boolean contains(Object object) {
        Class<?> clazz = object.getClass();
        int n = 0;
        while (n < this.imVector.size()) {
            Class<?> clazz2 = this.imVector.get(n).getClass();
            if (clazz == clazz2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    IIIMListener get(int n) {
        return (IIIMListener)this.imVector.get(n);
    }

    void setCCDEF(String string) {
        this.ccdef = string;
        if (this.pce != null) {
            try {
                this.pce.pushSyntax(new LWESyntax(string));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.debug(" err = " + invalidSyntaxException);
            }
        }
    }

    private void parseRule(String string) {
        this.imVector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.imVector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            ProtocolDriver protocolDriver;
            String string2 = stringTokenizer.nextToken();
            try {
                protocolDriver = string2.equals(PROTOCOL_DRIVER_NAME) ? ProtocolDriver.getInstance() : Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            if (protocolDriver == null || !(protocolDriver instanceof IIIMListener)) continue;
            if (protocolDriver instanceof PCE) {
                LWESyntax lWESyntax;
                block11: {
                    this.pce = (PCE)((Object)protocolDriver);
                    lWESyntax = null;
                    if (this.ccdef == null) {
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_PCE_RULE);
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        try {
                            lWESyntax = new LWESyntax(inputStreamReader);
                            break block11;
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            this.debug(" err : " + invalidSyntaxException);
                            continue;
                        }
                    }
                    try {
                        lWESyntax = new LWESyntax(this.ccdef);
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        this.debug(" err : " + invalidSyntaxException);
                        continue;
                    }
                }
                ((PCE)((Object)protocolDriver)).pushSyntax(lWESyntax);
            } else if (protocolDriver instanceof ProtocolDriver) {
                Manager.setPD(protocolDriver);
            }
            this.imVector.add(protocolDriver);
        }
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }
}

