/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCardService;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.common.SmartcardDES;
import com.sun.opencard.utils.OCFUtils;
import java.security.SecureRandom;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class ChallengeResponseCardService
extends OCFCardService {
    private static final int RESPONSE_LENGTH = 6;
    private static final int DES_BLOCK_SIZE = 8;
    private static final int DES_KEY_SIZE = 8;
    protected OCFCode ocf_codes;

    public boolean challenge(String string, String string2) throws OpenCardException, OCFCardException {
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        secureRandom.nextBytes(byArray);
        try {
            this.setupChallengeResponse();
            byte[] byArray2 = this.getCardChallengeReply(string, byArray);
            byte[] byArray3 = this.getKey(string, string2);
            byte[] byArray4 = this.getIV(string2);
            byte[] byArray5 = new byte[8];
            SmartcardDES smartcardDES = new SmartcardDES();
            smartcardDES.init(byArray3);
            smartcardDES.encrypt(byArray, byArray5);
            int n = 0;
            while (n < 6) {
                if (byArray2[n] != byArray5[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] getCardChallengeReply(String string, byte[] byArray) throws OCFCardException, OpenCardException {
        byte[] byArray2 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
        byte[] byArray3 = ServiceUtil.arrayJoin(byArray2, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(new ISOCommandAPDU((int)this.ocf_codes.UserClassByte(), (int)this.ocf_codes.CHALLENGE_RESPONSE_Byte(), 0, 0, byArray3, 6));
        return responseAPDU.data();
    }

    protected byte[] getKey(String string, String string2) {
        byte[] byArray = new byte[8];
        try {
            String string3 = OCFUtils.getProperty("ocf.server.keys.chkey." + string + "." + string2, null);
            if (string3.length() != 16) {
                return null;
            }
            char[] cArray = string3.toCharArray();
            int n = 0;
            while (n < byArray.length) {
                short s = cArray[2 * n] > '@' ? (short)(cArray[2 * n] - 55) : (short)(cArray[2 * n] - 48);
                short s2 = cArray[2 * n + 1] > '@' ? (short)(cArray[2 * n + 1] - 55) : (short)(cArray[2 * n + 1] - 48);
                byArray[n] = (byte)(s * 16 + s2);
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return byArray;
        }
    }

    protected byte[] getIV(String string) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = 0;
            ++n;
        }
        return byArray;
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private void setupChallengeResponse() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            openCardException.printStackTrace();
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    private ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }
}

