/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CardInfo;
import com.sun.smartcard.scf.CardRemovedException;
import com.sun.smartcard.scf.CardRemovedMonitor;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.SCFException;
import com.sun.smartcard.scf.TerminalEventDispatcher;
import com.sun.smartcard.scf.spi.CardProvider;

class InternalCard
implements Runnable {
    private boolean isActive;
    private CardProvider cardProvider;
    private CardInfo cardInfo;
    private TerminalEventDispatcher eventDispatcher;
    private CardRemovedMonitor cardRemovedMonitor;
    private final Logger logger = Logger.createLogger("InternalCard");

    InternalCard() {
        this.cardRemovedMonitor = new CardRemovedMonitor();
    }

    void init(CardProvider cardProvider, TerminalEventDispatcher terminalEventDispatcher) {
        this.logger.log("init", "");
        this.cardProvider = cardProvider;
        this.eventDispatcher = terminalEventDispatcher;
        this.cardInfo = new CardInfo();
    }

    void activate() throws InvalidStateException, CommException, InternalException, CardRemovedException {
        this.logger.log("activate", "");
        this.cardInfo.put("model", this.cardProvider.getCardType());
        this.cardInfo.put("atr", this.cardProvider.getATR());
        this.isActive = true;
        new Thread(this).start();
    }

    void close() {
        this.logger.log("close", "");
        this.isActive = false;
        this.cardRemovedMonitor.cardRemoved();
    }

    CardRemovedMonitor getCardRemovedMonitor() {
        return this.cardRemovedMonitor;
    }

    CardInfo getCardInfo() {
        return this.cardInfo;
    }

    CardProvider getCardProvider() {
        return this.cardProvider;
    }

    public void run() {
        this.logger.log("run", "Thread started");
        try {
            while (this.isActive) {
                this.cardProvider.waitForCardReset();
                if (!this.isActive) {
                    return;
                }
                this.logger.log("monitorReset", "Card has been reset.");
                this.cardInfo.put("model", this.cardProvider.getCardType());
                this.cardInfo.put("atr", this.cardProvider.getATR());
                this.eventDispatcher.notifyListeners(16);
            }
        }
        catch (CardRemovedException cardRemovedException) {
        }
        catch (InvalidStateException invalidStateException) {
        }
        catch (SCFException sCFException) {
            this.logger.log("monitorReset", sCFException + ": " + sCFException.getMessage());
        }
    }
}

