/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.IFDCardTerminal;

import com.sun.opencard.terminal.IFDCardTerminal.IFDCardTerminalNative;
import java.util.Enumeration;
import java.util.Properties;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.util.Tracer;

class IFDCardTerminal
extends CardTerminal {
    private CardID[] cachedATR = null;
    private boolean isTerminalOpen = false;
    private IFDCardTerminalNative ifdNative = null;
    private int readerIndex = 0;
    private CardStatusCheckThread statusCheck = null;
    private Tracer tracer = new Tracer(class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminal == null ? (class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminal = IFDCardTerminal.class$("com.sun.opencard.terminal.IFDCardTerminal.IFDCardTerminal")) : class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminal);
    static /* synthetic */ Class class$com$sun$opencard$terminal$IFDCardTerminal$IFDCardTerminal;

    IFDCardTerminal(String string, String string2, String string3, IFDCardTerminalNative iFDCardTerminalNative, int n) throws CardTerminalException {
        super(string, string2, string3);
        this.tracer.debug("Constructor", "entering IFDCardTerminal constructor");
        if (n < 0) {
            throw new CardTerminalException("Invalid instance index");
        }
        if (iFDCardTerminalNative == null) {
            throw new CardTerminalException("IFDCardTerminaNative invalid");
        }
        this.readerIndex = n;
        this.ifdNative = iFDCardTerminalNative;
    }

    public void close() throws CardTerminalException {
        this.tracer.debug("close()", "Entering...");
        if (this.isTerminalOpen) {
            this.statusCheck.interrupt();
            try {
                this.statusCheck.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = false;
            this.ifdNative.IFDHPowerICC(this.readerIndex, 0, 1);
            int n = 0;
            while (n < this.cachedATR.length) {
                this.invalidateCache(n);
                ++n;
            }
            bl = this.ifdNative.IFDHCloseChannel(this.readerIndex);
            if (!bl) {
                throw new CardTerminalException("Failed to close terminal");
            }
            this.isTerminalOpen = false;
        }
        this.tracer.debug("close()", "leaving...");
    }

    public void open() throws CardTerminalException {
        int n;
        this.tracer.debug("open()", "entering...");
        if (!this.isTerminalOpen) {
            n = 0;
            n = this.ifdNative.IFDHCreateChannel(this.readerIndex, this.getAddress()) ? 1 : 0;
            if (n != 1) {
                throw new CardTerminalException("Failed to open terminal");
            }
            this.isTerminalOpen = true;
        }
        n = this.ifdNative.getNumSlots(this.readerIndex);
        this.tracer.debug("open()", "Number of slots supported = " + n);
        this.addSlots(n);
        this.cachedATR = new CardID[n];
        this.statusCheck = new CardStatusCheckThread();
        this.statusCheck.start();
        this.tracer.debug("open()", "leaving....");
    }

    public CardID getCardID(int n) throws CardTerminalException {
        this.tracer.debug("getCardID(slotID)", "slot " + n);
        this.validateState(n);
        Object var2_2 = null;
        if (this.isCardPresent(n)) {
            if (this.cachedATR[n] == null) {
                this.powerUpCard(n);
            }
        } else {
            this.invalidateCache(n);
        }
        return this.cachedATR[n];
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        this.tracer.debug("getCardID(slotID, ms)", "slot " + n + " msec " + n2);
        return this.getCardID(n);
    }

    protected Properties internalFeatures(Properties properties) {
        this.tracer.debug("internalFeatures(features)", "entering internalFeatures");
        Properties properties2 = null;
        try {
            properties2 = this.ifdNative.IFDHGetCapabilities(this.readerIndex);
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        if (properties2 != null) {
            Enumeration<Object> enumeration = properties2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties2.getProperty(string);
                properties.put(string, string2);
            }
        }
        return properties2;
    }

    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        this.tracer.debug("internalReset(slotID, ms)", "entering....");
        this.validateState(n);
        byte[] byArray = this.ifdNative.IFDHPowerICC(this.readerIndex, n, 2);
        this.cachedATR[n] = new CardID(new Slot((CardTerminal)this, n), byArray);
        return this.cachedATR[n];
    }

    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        this.tracer.debug("internalSendAPDU()", "entering....");
        if (commandAPDU == null) {
            return null;
        }
        this.validateState(n);
        byte[] byArray = this.ifdNative.IFDHTransmitICC(this.readerIndex, n, commandAPDU.getBuffer());
        if (byArray == null) {
            throw new CardTerminalException("Error in during data exchange");
        }
        return new ResponseAPDU(byArray);
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        this.validateState(n);
        return this.ifdNative.IFDHICCPresence(this.readerIndex, n);
    }

    private void powerUpCard(int n) throws CardTerminalException {
        this.tracer.debug("powerUpCard", "entering...slotID = " + n);
        this.validateState(n);
        byte[] byArray = this.ifdNative.IFDHPowerICC(this.readerIndex, n, 0);
        if (byArray == null) {
            this.tracer.debug("powerUpCard", "powerUpCard: No ATR");
            throw new CardTerminalException("power up failed");
        }
        this.cachedATR[n] = new CardID(new Slot((CardTerminal)this, n), byArray);
        this.tracer.debug("powerUpCard", "cachedATR=" + this.cachedATR[n]);
        this.tracer.debug("powerUpCard", "Leaving...For slotID = " + n);
    }

    private void invalidateCache(int n) {
        this.cachedATR[n] = null;
    }

    private void validateState(int n) throws CardTerminalException {
        if (!this.isTerminalOpen) {
            throw new CardTerminalException("Card terminal is closed");
        }
        if (n < 0 || n >= this.cachedATR.length) {
            throw new CardTerminalException("Invalid slot id: " + n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CardStatusCheckThread
    extends Thread {
        private boolean[] cardIsInserted;
        private boolean continueCheck = true;

        private CardStatusCheckThread() {
        }

        public void run() {
            this.cardIsInserted = new boolean[IFDCardTerminal.this.cachedATR.length];
            int n = 0;
            while (n < this.cardIsInserted.length) {
                this.cardIsInserted[n] = false;
                ++n;
            }
            while (this.continueCheck) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    this.continueCheck = false;
                }
                if (this.continueCheck) {
                    try {
                        int n2 = 0;
                        while (n2 < IFDCardTerminal.this.cachedATR.length) {
                            boolean bl = IFDCardTerminal.this.isCardPresent(n2);
                            if (bl) {
                                if (!this.cardIsInserted[n2]) {
                                    if (IFDCardTerminal.this.cachedATR[n2] == null) {
                                        IFDCardTerminal.this.powerUpCard(n2);
                                    }
                                    IFDCardTerminal.super.cardInserted(n2);
                                }
                            } else if (this.cardIsInserted[n2]) {
                                IFDCardTerminal.this.invalidateCache(n2);
                                IFDCardTerminal.super.cardRemoved(n2);
                            }
                            this.cardIsInserted[n2] = bl;
                            ++n2;
                        }
                    }
                    catch (CardTerminalException cardTerminalException) {
                        cardTerminalException.printStackTrace();
                    }
                }
                if (!Thread.interrupted()) continue;
                this.continueCheck = false;
            }
        }
    }
}

