/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.cmd;

import com.sun.opencard.cmd.CmdUtils;
import com.sun.opencard.cmd.OCFGetOpt;
import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.CardletAdminCardService;
import com.sun.smartcard.KeyImportCardService;
import com.sun.smartcard.PinCardService;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.TimeoutSpec;
import com.sun.smartcard.UserInfo;
import com.sun.smartcard.UserInfoCardService;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.misc.BASE64Decoder;

public class SolarisAuthAppletInit {
    private final String AID = "A000000062030400";
    static String PIN;
    static String PIN_DESC;
    static String APPLICATION;
    static String APPLICATION_DESC;
    static String USER;
    static String USER_DESC;
    static String PASSWORD;
    static String PASSWORD_DESC;
    static String PRIVATE_KEY;
    static String PRIVATE_KEY_DESC;
    static String CERT;
    static String CERT_DESC;
    private static ResourceBundle messages;
    private static MessageFormat msgFormatter;
    private Hashtable props = new Hashtable();
    private Hashtable nvs = new Hashtable();
    boolean iPresent = true;
    boolean PPresent = false;
    boolean aidPresent = false;
    boolean LPresent = false;
    boolean rPresent = false;
    boolean sPresent = false;
    boolean isSetProperties = false;
    String aid = null;
    String rn = null;
    String sn = null;
    String pin = null;

    public Boolean knows(String string) {
        return new Boolean(string.equals("A000000062030400"));
    }

    public void run(String[] stringArray) throws Exception {
        Smartcard smartcard = null;
        try {
            SolarisAuthAppletInit.initialize();
            this.init();
            this.parseCmdLine(stringArray);
            smartcard = new Smartcard("default", "1");
            Card card = null;
            try {
                card = smartcard.waitForCardInserted(new CardSpec(), this.rn == null ? new ReaderSpec() : new ReaderSpec(this.rn), new AIDSpec(), new TimeoutSpec());
                smartcard.cardPresent(new CardSpec(), new ReaderSpec());
            }
            catch (Exception exception) {
                System.out.println(messages.getString("OCFInit.ReaderException"));
                smartcard.cleanup();
                System.exit(1);
            }
            if (this.PPresent) {
                this.setCard(this.aid, card);
            } else if (this.LPresent) {
                this.listProperties(this.aid);
            } else if (this.aidPresent) {
                this.listApplets(card);
            } else {
                smartcard.cleanup();
                this.usage();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            if (smartcard != null) {
                smartcard.cleanup();
            }
            this.usage();
        }
        smartcard.cleanup();
    }

    public String[] listApplets(Card card) throws Exception {
        String[] stringArray = null;
        try {
            CardletAdminCardService cardletAdminCardService = (CardletAdminCardService)card.getCardService("com.sun.smartcard.CardletAdminCardService");
            Vector vector = cardletAdminCardService.listApplets();
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = new String((String)vector.elementAt(n));
                System.out.println(stringArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(messages.getString("OCFInit.ListAppletsFailed"));
            return null;
        }
        return stringArray;
    }

    public String[] listProperties(String string) throws Exception {
        System.out.println(PIN + ": " + PIN_DESC);
        System.out.println(APPLICATION + ": " + APPLICATION_DESC);
        System.out.println(USER + ": " + USER_DESC);
        System.out.println(PASSWORD + ": " + PASSWORD_DESC);
        System.out.println(PRIVATE_KEY + ": " + PRIVATE_KEY_DESC);
        System.out.println(CERT + ": " + CERT_DESC);
        return null;
    }

    public void setCard(String string, Card card) throws Exception {
        try {
            Object object;
            Object object2;
            Object object3;
            PinCardService pinCardService = (PinCardService)card.getCardService("com.sun.smartcard.PinCardService");
            UserInfoCardService userInfoCardService = (UserInfoCardService)card.getCardService("com.sun.smartcard.UserInfoCardService");
            KeyImportCardService keyImportCardService = (KeyImportCardService)card.getCardService("com.sun.smartcard.KeyImportCardService");
            if (!pinCardService.validateAndUnlock(this.pin)) {
                System.out.println(messages.getString("OCFInit.invalidPin"));
                System.exit(1);
            }
            if ((String)this.nvs.get(USER) != null) {
                object3 = new UserInfo((String)this.nvs.get(APPLICATION), (String)this.nvs.get(USER));
                userInfoCardService.setUserInfo(object3);
            }
            if ((String)this.nvs.get(PASSWORD) != null) {
                userInfoCardService.setUserPassword((String)this.nvs.get(APPLICATION), (String)this.nvs.get(PASSWORD));
            }
            if ((String)this.nvs.get(PRIVATE_KEY) != null) {
                object3 = new FileInputStream((String)this.nvs.get(PRIVATE_KEY));
                byte[] byArray = new byte[object3.available()];
                object3.read(byArray);
                object2 = KeyFactory.getInstance("RSA");
                object = new PKCS8EncodedKeySpec(byArray);
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((KeyFactory)object2).generatePrivate((KeySpec)object);
                keyImportCardService.importPrivateKey("default", rSAPrivateKey.getEncoded());
            }
            if ((String)this.nvs.get(CERT) != null) {
                String string2;
                object2 = new StringBuffer();
                FileInputStream fileInputStream = null;
                try {
                    string2 = (String)this.nvs.get(CERT);
                    fileInputStream = new FileInputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException.getMessage());
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                object = bufferedReader.readLine();
                int n = ((String)object).compareTo("-----BEGIN CERTIFICATE-----");
                if (n == 0) {
                    while (((String)(object = bufferedReader.readLine())).compareTo("-----END CERTIFICATE-----") != 0) {
                        ((StringBuffer)object2).append((String)object);
                    }
                } else {
                    do {
                        ((StringBuffer)object2).append((String)object);
                    } while ((n = (object = bufferedReader.readLine()) != null ? ((String)object).compareTo("-----END CERTIFICATE-----") : 0) != 0);
                }
                string2 = new BASE64Decoder();
                object3 = string2.decodeBuffer(((StringBuffer)object2).toString());
                ((InputStream)fileInputStream).close();
                bufferedReader.close();
                keyImportCardService.importCertificate("default", (byte[])object3);
            }
            if ((String)this.nvs.get(PIN) != null) {
                try {
                    pinCardService.changePin(this.pin, (String)this.nvs.get(PIN));
                    System.out.println(messages.getString("OCFInit.ChangePinOK"));
                }
                catch (Exception exception) {
                    System.out.println(messages.getString("OCFInit.ChangePinFailed"));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(messages.getString("OCFInit.Exception"));
        }
    }

    private void parseCmdLine(String[] stringArray) throws Exception {
        OCFGetOpt oCFGetOpt = new OCFGetOpt(stringArray, "A:Ls:r:P:");
        oCFGetOpt.optErr = true;
        int n = -1;
        while ((n = oCFGetOpt.getopt()) != -1) {
            switch (n) {
                case 65: {
                    this.aid = oCFGetOpt.optArgGet();
                    this.iPresent = true;
                    break;
                }
                case 76: {
                    this.LPresent = true;
                    break;
                }
                case 114: {
                    this.rn = oCFGetOpt.optArgGet();
                    this.rPresent = true;
                    break;
                }
                case 115: {
                    this.sn = oCFGetOpt.optArgGet();
                    this.sPresent = true;
                    break;
                }
                case 80: {
                    this.pin = oCFGetOpt.optArgGet();
                    this.PPresent = true;
                    break;
                }
            }
            if (this.aid == null) continue;
            this.aidPresent = true;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            n3 = stringArray[n2].indexOf(61);
            if (n3 != -1) {
                this.addProperty(stringArray[n2].substring(0, n3), stringArray[n2].substring(n3 + 1, stringArray[n2].length()));
            }
            ++n2;
        }
        if (this.nvs.size() != 0) {
            this.isSetProperties = true;
            if (((String)this.nvs.get(USER) != null || (String)this.nvs.get(PASSWORD) != null) && (String)this.nvs.get(APPLICATION) == null) {
                this.usage();
            }
            if ((String)this.nvs.get(USER) == null && (String)this.nvs.get(APPLICATION) != null) {
                this.usage();
            }
        }
    }

    private static void initialize() {
        try {
            Locale locale = CmdUtils.initLocale();
            msgFormatter = new MessageFormat("");
            msgFormatter.setLocale(locale);
            messages = CmdUtils.getMessageBundle(locale);
            PIN = new String("pin");
            PIN_DESC = messages.getString("OCFInit.PIN_DESC");
            APPLICATION = new String("application");
            APPLICATION_DESC = messages.getString("OCFInit.APPLICATION_DESC");
            USER = new String("user");
            USER_DESC = messages.getString("OCFInit.USER_DESC");
            PASSWORD = new String("password");
            PASSWORD_DESC = messages.getString("OCFInit.PASSWORD_DESC");
            PRIVATE_KEY = new String("privatekey");
            PRIVATE_KEY_DESC = messages.getString("OCFInit.PRIVATE_KEY_DESC");
            CERT = new String("certificate");
            CERT_DESC = messages.getString("OCFInit.CERT_DESC");
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    private void init() {
        this.props.put(PIN, PIN_DESC);
        this.props.put(APPLICATION, APPLICATION_DESC);
        this.props.put(USER, USER_DESC);
        this.props.put(PASSWORD, PASSWORD_DESC);
        this.props.put(PRIVATE_KEY, PRIVATE_KEY_DESC);
        this.props.put(CERT, CERT_DESC);
    }

    private void addProperty(String string, String string2) {
        this.nvs.put(string, string2);
    }

    private void usage() {
        System.out.println(messages.getString("OCFInit.usage"));
        System.exit(1);
    }
}

