/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.ConsoleCallback;
import com.sun.management.services.common.Debug;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpSession;

public class ConsoleCallbackHandler
implements CallbackHandler {
    private HttpSession session = null;
    private Locale locale = null;
    private String thisVB = null;
    private String curVB = null;

    public ConsoleCallbackHandler(HttpSession httpSession, Locale locale) {
        this.session = httpSession;
        this.locale = locale;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray != null) {
            int n = 0;
            while (n < callbackArray.length) {
                if (callbackArray[n] instanceof ConsoleCallback) {
                    ConsoleCallback consoleCallback = (ConsoleCallback)callbackArray[n];
                    if (consoleCallback != null) {
                        consoleCallback.setLocale(this.locale);
                        this.thisVB = consoleCallback.getViewBean();
                        this.session.setAttribute("thisVB", (Object)this.thisVB);
                        consoleCallback.getDataBeforeCallback(this.session);
                        if (!consoleCallback.isDataAvailable()) {
                            if (this.curVB == null || !this.curVB.equals(this.thisVB)) {
                                this.getUserData("forward_to:" + this.thisVB);
                                this.curVB = this.thisVB;
                            } else if (this.curVB.equals(this.thisVB)) {
                                this.getUserData("auth_error");
                            }
                        }
                        consoleCallback.getDataAfterCallback(this.session);
                    }
                } else {
                    throw new UnsupportedCallbackException(callbackArray[n], "Unrecognized Callback");
                }
                Debug.trace1((String)("Done Handling Callback class: " + callbackArray[n].getClass().getName()));
                ++n;
            }
        }
    }

    private String getUserData(String string) {
        this.session.setAttribute("serverconv", (Object)string);
        Debug.trace1((String)("SENDING SERVER RESPONSE : " + string));
        boolean bl = true;
        String string2 = null;
        Debug.trace1((String)" WAITING FOR USER RESPONSE ");
        do {
            try {
                string2 = (String)this.session.getAttribute("clientconv");
                if (string2 != null) {
                    bl = false;
                    this.session.removeAttribute("clientconv");
                    continue;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                Debug.trace1((String)"session timed out waiting for user input");
                break;
            }
        } while (bl);
        Debug.trace1((String)("DONE WAITING FOR USER , RESPONSE IS : " + string2));
        return string2;
    }
}

