/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.ConsoleCallback;
import com.sun.management.services.authentication.ExecProcess;
import com.sun.management.services.authentication.PamCallback;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserRoleCredential;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PamLoginModule
implements LoginModule {
    private Subject subject;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private CallbackHandler ccbh;
    private UserRolePrincipal up = null;
    private UserRoleCredential pc = null;
    private String commandPath = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.ccbh = callbackHandler;
        this.sharedState = map;
        if (map2 != null) {
            this.options = map2;
            this.commandPath = (String)map2.get("commandPath");
            if (this.commandPath == null) {
                this.commandPath = "/usr/sadm/lib/webconsole/bin";
            }
        } else {
            this.commandPath = "/usr/sadm/lib/webconsole/bin";
        }
    }

    public boolean login() throws LoginException {
        Object object;
        String string = null;
        String string2 = null;
        PasswordCredential passwordCredential = null;
        int n = -1;
        Callback[] callbackArray = new Callback[1];
        try {
            callbackArray[0] = new PamCallback();
            this.ccbh.handle(callbackArray);
            object = (PamCallback)callbackArray[0];
            string = ((ConsoleCallback)object).getHost();
            string2 = ((ConsoleCallback)object).getUser();
            passwordCredential = ((ConsoleCallback)object).getUserCredential();
        }
        catch (Exception exception) {
            LoginException loginException = new LoginException("call_back_failure");
            loginException.fillInStackTrace();
            throw loginException;
        }
        object = null;
        try {
            Object object2;
            String string3 = this.commandPath + "/pamverifier";
            String[] stringArray = new String[]{string3, "authuser", string2, "NULL", passwordCredential.getUserPassword()};
            object = new ExecProcess(stringArray);
            Vector vector = null;
            try {
                vector = ((ExecProcess)object).exec();
            }
            catch (Exception exception) {
                LoginException loginException = new LoginException("exec_proc_failure");
                loginException.fillInStackTrace();
                throw loginException;
            }
            if (vector != null) {
                object2 = (String[])vector.elementAt(0);
                n = Integer.parseInt(object2[0].trim());
            }
            if (n == 0) {
                Debug.trace1((String)"inside PAM Login: user is valid ");
                this.up = new UserRolePrincipal(string2, null);
                this.up.setHostName(string);
                this.pc = new UserRoleCredential(passwordCredential.getUserPassword(), null);
                this.pc.setHostName(string);
                Debug.trace1((String)"inside PAM Login: getting roles");
                object2 = new Vector();
                String[] stringArray2 = new String[]{string3, "getUserRoles", string2};
                object = new ExecProcess(stringArray2);
                try {
                    object2 = ((ExecProcess)object).exec();
                }
                catch (Exception exception) {
                    Debug.trace1((String)"inside PAM Login: exception get roles");
                    LoginException loginException = new LoginException("exec_proc_failure");
                    loginException.fillInStackTrace();
                    throw loginException;
                }
                if (object2 != null && ((Vector)object2).size() != 0) {
                    String[] stringArray3 = (String[])((Vector)object2).elementAt(0);
                    if (stringArray3 != null && stringArray3.length != 0) {
                        int n2 = 0;
                        while (n2 < stringArray3.length) {
                            stringArray3[n2] = stringArray3[n2].trim();
                            Debug.trace1((String)("ROLE : " + stringArray3[n2]));
                            ++n2;
                        }
                    }
                    this.sharedState.put("roleList", stringArray3);
                }
                this.succeeded = true;
                return true;
            }
            object2 = new FailedLoginException("login_failed_invalid_user_or_cred");
            ((Throwable)object2).fillInStackTrace();
            Debug.trace2((String)"login failed", (Throwable)object2);
            throw object2;
        }
        catch (Exception exception) {
            FailedLoginException failedLoginException = new FailedLoginException("login_failed");
            failedLoginException.fillInStackTrace();
            Debug.trace2((String)"login failed", (Throwable)failedLoginException);
            throw failedLoginException;
        }
    }

    public boolean commit() throws LoginException {
        if (this.subject != null) {
            if (!this.subject.getPrincipals().contains(this.up)) {
                this.subject.getPrincipals().add(this.up);
            }
            if (!this.subject.getPrivateCredentials().contains(this.pc)) {
                this.subject.getPrivateCredentials().add(this.pc);
            }
            this.commitSucceeded = true;
            return true;
        }
        throw new LoginException("login_failed_see_log");
    }

    public boolean abort() throws LoginException {
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.up = null;
            if (this.pc != null) {
                this.pc = null;
            }
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.subject != null) {
            Object[] objectArray = this.subject.getPrincipals().toArray();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof UserRolePrincipal) {
                    this.subject.getPrincipals().remove(objectArray[n]);
                    break;
                }
                ++n;
            }
            objectArray = this.subject.getPrivateCredentials().toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof UserRoleCredential) {
                    this.subject.getPrivateCredentials().remove(objectArray[n2]);
                    break;
                }
                ++n2;
            }
            this.succeeded = this.commitSucceeded;
            return true;
        }
        throw new LoginException("subject_is_null");
    }
}

