/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authorization;

import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationUtility;
import com.sun.management.services.authorization.SolarisRbacPermission;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;

public final class SolarisRbacAuthorizationService
implements AuthorizationService {
    public Permission createPermission(String string, String[][] stringArray) throws AuthorizationException {
        if (stringArray == null) {
            throw new AuthorizationException("NULL_PERMISSION_SET");
        }
        String string2 = stringArray[0][1];
        SolarisRbacPermission solarisRbacPermission = new SolarisRbacPermission(string2);
        return solarisRbacPermission;
    }

    public boolean checkPermission(Permission permission) throws AuthorizationException {
        return false;
    }

    public boolean checkPermission(Principal principal, Permission permission) throws AuthorizationException {
        if (principal == null) {
            throw new AuthorizationException("PRINCIPAL_IS_NULL");
        }
        UserRolePrincipal userRolePrincipal = (UserRolePrincipal)principal;
        String string = userRolePrincipal.getRoleName();
        String string2 = userRolePrincipal.getUserName();
        if (string == null) {
            return AuthorizationUtility.checkAuthName(string2, permission.getName());
        }
        return AuthorizationUtility.checkAuthName(string, permission.getName());
    }

    public boolean checkPermission(Subject subject, Permission permission) throws AuthorizationException {
        if (subject == null) {
            throw new AuthorizationException("SUBJECT_IS_NULL");
        }
        String string = null;
        String string2 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.management.services.authentication.UserPrincipal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            AuthorizationException authorizationException = new AuthorizationException("NO_CLASS_FOUND");
            throw authorizationException;
        }
        Object[] objectArray = subject.getPrincipals(clazz).toArray();
        if (objectArray == null) {
            throw new AuthorizationException("NO_PRINCIPALS");
        }
        if (objectArray.length == 0) {
            throw new AuthorizationException("NO_PRINCIPALS");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof UserRolePrincipal) {
                string = ((UserRolePrincipal)objectArray[n]).getRoleName();
                string2 = ((UserRolePrincipal)objectArray[n]).getUserName();
            }
            ++n;
        }
        if (string == null) {
            return AuthorizationUtility.checkAuthName(string2, permission.getName());
        }
        return AuthorizationUtility.checkAuthName(string, permission.getName());
    }
}

