/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.logging;

import com.sun.management.services.common.Debug;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class ConsoleLogHandler
extends Handler {
    private LogManager manager = LogManager.getLogManager();
    private boolean open = true;
    protected static final int SYSLOG_DEBUG = 7;
    protected static final int SYSLOG_INFO = 6;
    protected static final int SYSLOG_NOTICE = 5;
    protected static final int SYSLOG_WARNING = 4;
    protected static final int SYSLOG_ERR = 3;
    protected static final int SYSLOG_CRIT = 2;
    protected static final int SYSLOG_ALERT = 1;
    protected static final int SYSLOG_EMERG = 0;
    private static String logResBundle = "com.sun.management.services.logging.resources.Resource";
    private static boolean library_loaded = false;

    private static native void doSyslog(String var0, String var1, int var2);

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (!library_loaded) {
            return;
        }
        int n = 0;
        int n2 = logRecord.getLevel().intValue();
        if (n2 == Level.SEVERE.intValue()) {
            n = 2;
        } else if (n2 == Level.WARNING.intValue()) {
            n = 4;
        } else if (n2 == Level.INFO.intValue()) {
            n = 6;
        } else if (n2 == Level.CONFIG.intValue()) {
            n = 7;
        }
        String string2 = null;
        String string3 = null;
        ResourceBundle resourceBundle = null;
        resourceBundle = logRecord.getResourceBundle();
        Object[] objectArray = logRecord.getParameters();
        string3 = string = logRecord.getMessage();
        string2 = string;
        if (resourceBundle != null) {
            Debug.trace1((String)"log resource bundle is not null...");
            try {
                string3 = resourceBundle.getString(string);
                string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
            }
            catch (Exception exception) {}
        } else {
            Debug.trace1((String)"log resource bundle is null...");
        }
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(logResBundle, Locale.getDefault(), this.getClass().getClassLoader());
            string3 = resourceBundle2.getString("MSG_HEADER");
            if (string3.equals("MSG_HEADER")) {
                string3 = string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Debug.trace1((String)"message contents before logging...");
        Debug.trace1((String)("detailedMsg: " + string2));
        Debug.trace1((String)("msgHeader: " + string3));
        Debug.trace1((String)("sys_severity: " + n));
        ConsoleLogHandler.doSyslog(string2, string3, n);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        this.open = false;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (!this.open) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    static {
        try {
            System.loadLibrary("consyslog");
            library_loaded = true;
        }
        catch (Throwable throwable) {
            Debug.trace1((String)("SysLog Service failed to init - " + throwable.getMessage()));
            Debug.trace2((String)"SysLog Service failed to init", (Throwable)throwable);
        }
    }
}

