/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authorization.AuthorizationException;
import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.registration.AuthType;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import java.security.Permission;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public class AppFilter {
    private Subject subject = null;

    public boolean checkUserPermission(HttpServletRequest httpServletRequest, String string) throws RegistrationException {
        String string2 = MgmtAppRegistrationServiceFactory.getPluginName((String)string);
        RegistrationInfo registrationInfo = MgmtAppRegistrationServiceFactory.getRegistrationInfo((String)string2);
        return this.checkUserPermission(httpServletRequest, registrationInfo);
    }

    public boolean checkUserPermission(HttpServletRequest httpServletRequest, RegistrationInfo registrationInfo) throws RegistrationException {
        this.subject = this.getSubject(httpServletRequest);
        ArrayList arrayList = registrationInfo.getAuthTypes().getAuthTypeList();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            AuthType authType = (AuthType)arrayList.get(n2);
            if (!authType.isSet()) {
                return true;
            }
            String string = authType.getClassType();
            String[][] stringArray = authType.getPermissionParams();
            try {
                AuthorizationService authorizationService = AuthorizationServiceFactory.getAuthorizationService((String)authType.getName());
                if (authorizationService != null) {
                    Permission permission = authorizationService.createPermission(string, stringArray);
                    return authorizationService.checkPermission(this.subject, permission);
                }
            }
            catch (AuthorizationException authorizationException) {
                authorizationException.printStackTrace();
            }
            ++n2;
        }
        return false;
    }

    private Subject getSubject(HttpServletRequest httpServletRequest) throws RegistrationException {
        Subject subject = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            subject = sSOToken.getSubject();
        }
        catch (Exception exception) {
            throw new RegistrationException("er_nosubject", exception.getLocalizedMessage());
        }
        return subject;
    }
}

