/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Graphics;
import sam.gui.ObjectIcon;
import sam.model.Media;
import sam.resource.ResourceManager;

public class MediaIcon
extends ObjectIcon {
    private Media media;

    public static String getIconResource(Media media) {
        try {
            return ResourceManager.getMediaIcon(media.getTypeString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.media == null) {
            return;
        }
        if (this.media.isBarcoded()) {
            this.drawBarcode(graphics);
        }
        if (this.media.isMarkedDamaged()) {
            this.drawDamaged(graphics);
        }
        if (this.media.isReadOnly() || this.media.isWriteProtected()) {
            this.drawLocked(graphics);
        }
        if (this.media.isCleaning()) {
            this.drawCleaning(graphics);
        }
        if (this.media.isMarkedRecycle()) {
            this.drawRecycle(graphics);
        }
    }

    public int getPaintedAttributes() {
        int n = super.getPaintedAttributes();
        if (this.media == null) {
            return n;
        }
        n <<= 1;
        if (this.media.isBarcoded()) {
            ++n;
        }
        n <<= 1;
        if (this.media.isMarkedDamaged()) {
            ++n;
        }
        n <<= 1;
        if (this.media.isReadOnly()) {
            ++n;
        }
        n <<= 1;
        if (this.media.isWriteProtected()) {
            ++n;
        }
        n <<= 1;
        if (this.media.isCleaning()) {
            ++n;
        }
        n <<= 1;
        if (this.media.isMarkedRecycle()) {
            ++n;
        }
        return n;
    }

    public void drawBarcode(Graphics graphics) {
        int n = this.percentHeight(0.9);
        int n2 = this.percentHeight(0.1);
        int n3 = this.percentWidth(0.1);
        int n4 = this.percentWidth(0.8);
        if (n2 < 2) {
            n2 = 2;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n3, n, n4, n2);
        int n5 = n2 / 2;
        int n6 = n4 / 20;
        if (n6 < 0) {
            n6 = 1;
        }
        int n7 = n3 + n6;
        graphics.setColor(Color.black);
        int n8 = 0;
        while (n8 < 10) {
            switch (n8) {
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    graphics.fillRect(n7, n + n5, n6, n2 - n5);
                    break;
                }
                default: {
                    graphics.fillRect(n7, n, n6, n2);
                }
            }
            ++n8;
            n7 += n6 * 2;
        }
    }

    public void drawDamaged(Graphics graphics) {
        graphics.setColor(this.getBackground());
        int n = this.percentWidth(0.05);
        int n2 = this.percentWidth(0.5) - n / 2;
        int n3 = this.percentHeight(0.5);
        int n4 = this.percentWidth(0.1);
        int n5 = this.percentHeight(0.1);
        int n6 = 0;
        while (n6 < n) {
            graphics.drawLine(n2, 0, n2 - n4, n3);
            graphics.drawLine(n2 - n4, n3, n2 + n4, n3 - n5);
            graphics.drawLine(n2 + n4, n3 - n5, n2, this.size.height);
            ++n6;
            ++n2;
        }
    }

    public void drawLocked(Graphics graphics) {
        if (this.media.isWriteProtected()) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.yellow);
        }
        int n = this.percentWidth(0.15);
        int n2 = this.percentHeight(0.15);
        int n3 = this.percentWidth(0.5) - n / 2;
        int n4 = this.percentHeight(0.5) - n2 / 2;
        graphics.fillRect(n3, n4, n, n2);
        n3 += n / 7;
        n4 -= n2 / 2 + n2 / 7;
        int n5 = n / 5;
        n -= 2 * n / 7;
        n2 -= n2 / 7;
        if (n5 == 0) {
            n5 = 1;
        }
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawOval(n3, n4, n, n2);
            ++n6;
            n -= 2;
            --n2;
            ++n3;
            ++n4;
        }
    }

    public void drawCleaning(Graphics graphics) {
        graphics.setXORMode(Color.yellow);
        this.drawImage(graphics);
        graphics.setPaintMode();
    }

    public void drawRecycle(Graphics graphics) {
        graphics.setColor(Color.green);
        int n = this.percentWidth(0.1);
        int n2 = this.percentWidth(0.3);
        int n3 = this.percentHeight(0.3);
        int n4 = this.percentWidth(0.5);
        int n5 = 0;
        while (n5 < n) {
            graphics.drawLine(n2 + n5, this.size.height - n3 - n5, n4, n3 + n5);
            graphics.drawLine(n4, n3 + n5, this.size.width - n2 - n5, this.size.height - n3 - n5);
            graphics.drawLine(this.size.width - n2 - n5, this.size.height - n3 - n5, n2 + n5, this.size.height - n3 - n5);
            ++n5;
        }
    }

    public void setMedia(Media media) {
        if (this.media != null) {
            this.media.deleteObserver(this);
        }
        this.media = media;
        this.setImage(MediaIcon.getIconResource(this.media));
        if (this.media != null) {
            this.media.addObserver(this);
        }
    }

    public MediaIcon(Media media, int n, int n2) {
        super(MediaIcon.getIconResource(media), n, n2);
        this.media = media;
        if (media != null) {
            media.addObserver(this);
        }
    }

    public MediaIcon(Media media) {
        super(MediaIcon.getIconResource(media));
        this.media = media;
        if (media != null) {
            media.addObserver(this);
        }
    }
}

